/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.exts;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.infinispan.commons.equivalence.Equivalence;
import org.infinispan.commons.equivalence.EquivalentHashMap;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.util.FastCopyHashMap;
import org.infinispan.commons.util.Util;
import org.jboss.marshalling.util.IdentityIntMap;

public class MapExternalizer
extends AbstractExternalizer<Map> {
    private static final int HASHMAP = 0;
    private static final int TREEMAP = 1;
    private static final int FASTCOPYHASHMAP = 2;
    private static final int EQUIVALENTHASHMAP = 3;
    private final IdentityIntMap<Class<?>> numbers = new IdentityIntMap(4);

    public MapExternalizer() {
        this.numbers.put(HashMap.class, 0);
        this.numbers.put(TreeMap.class, 1);
        this.numbers.put(FastCopyHashMap.class, 2);
        this.numbers.put(EquivalentHashMap.class, 3);
    }

    @Override
    public void writeObject(ObjectOutput output, Map map) throws IOException {
        int number = this.numbers.get(map.getClass(), -1);
        output.write(number);
        switch (number) {
            case 3: {
                EquivalentHashMap equivalentMap = (EquivalentHashMap)map;
                output.writeObject(equivalentMap.getKeyEquivalence());
                output.writeObject(equivalentMap.getValueEquivalence());
            }
        }
        MarshallUtil.marshallMap(map, output);
    }

    @Override
    public Map readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        int magicNumber = input.readUnsignedByte();
        Map subject = null;
        switch (magicNumber) {
            case 0: {
                subject = new HashMap();
                break;
            }
            case 1: {
                subject = new TreeMap();
                break;
            }
            case 2: {
                subject = new FastCopyHashMap();
                break;
            }
            case 3: {
                Equivalence keyEq = (Equivalence)input.readObject();
                Equivalence valueEq = (Equivalence)input.readObject();
                subject = new EquivalentHashMap(keyEq, valueEq);
            }
        }
        MarshallUtil.unmarshallMap(subject, input);
        return subject;
    }

    @Override
    public Integer getId() {
        return 2;
    }

    @Override
    public Set<Class<? extends Map>> getTypeClasses() {
        return Util.asSet(HashMap.class, TreeMap.class, FastCopyHashMap.class, EquivalentHashMap.class);
    }
}

