/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.file;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.infinispan.commons.equivalence.AnyEquivalence;
import org.infinispan.commons.equivalence.Equivalence;
import org.infinispan.commons.equivalence.EquivalentLinkedHashMap;
import org.infinispan.commons.io.ByteBuffer;
import org.infinispan.commons.io.ByteBufferFactory;
import org.infinispan.commons.util.CollectionFactory;
import org.infinispan.configuration.cache.SingleFileStoreConfiguration;
import org.infinispan.executors.ExecutorAllCompletionService;
import org.infinispan.marshall.core.MarshalledEntry;
import org.infinispan.persistence.PersistenceUtil;
import org.infinispan.persistence.TaskContextImpl;
import org.infinispan.persistence.spi.AdvancedCacheLoader;
import org.infinispan.persistence.spi.AdvancedCacheWriter;
import org.infinispan.persistence.spi.AdvancedLoadWriteStore;
import org.infinispan.persistence.spi.InitializationContext;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.util.KeyValuePair;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class SingleFileStore
implements AdvancedLoadWriteStore {
    private static final Log log = LogFactory.getLog(SingleFileStore.class);
    private static final boolean trace = log.isTraceEnabled();
    private static final byte[] MAGIC = new byte[]{70, 67, 83, 49};
    private static final byte[] ZERO_INT = new byte[]{0, 0, 0, 0};
    private static final int KEYLEN_POS = 4;
    private static final int KEY_POS = 24;
    private SingleFileStoreConfiguration configuration;
    protected InitializationContext ctx;
    private FileChannel channel;
    private Map<Object, FileEntry> entries;
    private SortedSet<FileEntry> freeList;
    private long filePos = MAGIC.length;
    private File file;
    private ReadWriteLock resizeLock = new ReentrantReadWriteLock();

    @Override
    public void init(InitializationContext ctx) {
        this.ctx = ctx;
        this.configuration = (SingleFileStoreConfiguration)ctx.getConfiguration();
    }

    @Override
    public void start() {
        try {
            File dir;
            String location = this.configuration.location();
            if (location == null || location.trim().length() == 0) {
                location = "Infinispan-SingleFileStore";
            }
            this.file = new File(location, this.ctx.getCache().getName() + ".dat");
            if (!(this.file.exists() || (dir = this.file.getParentFile()).mkdirs() || dir.exists())) {
                throw log.directoryCannotBeCreated(dir.getAbsolutePath());
            }
            this.channel = new RandomAccessFile(this.file, "rw").getChannel();
            this.entries = this.newEntryMap();
            this.freeList = Collections.synchronizedSortedSet(new TreeSet());
            byte[] header = new byte[MAGIC.length];
            if (this.channel.read(java.nio.ByteBuffer.wrap(header), 0L) == MAGIC.length && Arrays.equals(MAGIC, header)) {
                this.rebuildIndex();
            } else {
                this.clear();
            }
        }
        catch (Exception e) {
            throw new PersistenceException(e);
        }
    }

    private Map<Object, FileEntry> newEntryMap() {
        Equivalence keyEq = this.ctx.getCache().getCacheConfiguration().dataContainer().keyEquivalence();
        Map entryMap = this.configuration.maxEntries() > 0 ? CollectionFactory.makeLinkedMap(16, 0.75f, EquivalentLinkedHashMap.IterationOrder.ACCESS_ORDER, keyEq, AnyEquivalence.getInstance()) : CollectionFactory.makeMap(keyEq, AnyEquivalence.getInstance());
        return Collections.synchronizedMap(entryMap);
    }

    @Override
    public void stop() {
        try {
            if (this.channel != null) {
                log.tracef("Stopping store %s, size = %d, file size = %d", (Object)this.ctx.getCache().getName(), (Object)this.entries.size(), (Object)this.channel.size());
                this.channel.close();
                this.channel = null;
                this.entries = null;
                this.freeList = null;
                this.filePos = MAGIC.length;
            }
        }
        catch (Exception e) {
            throw new PersistenceException(e);
        }
    }

    private void rebuildIndex() throws Exception {
        java.nio.ByteBuffer buf = java.nio.ByteBuffer.allocate(24);
        while (true) {
            buf.clear().limit(24);
            this.channel.read(buf, this.filePos);
            if (buf.remaining() > 0) {
                return;
            }
            buf.flip();
            int entrySize = buf.getInt();
            int keyLen = buf.getInt();
            int dataLen = buf.getInt();
            int metadataLen = buf.getInt();
            long expiryTime = buf.getLong();
            FileEntry fe = new FileEntry(this.filePos, entrySize, keyLen, dataLen, metadataLen, expiryTime);
            if (fe.size < 24 + fe.keyLen + fe.dataLen + fe.metadataLen) {
                throw log.errorReadingFileStore(this.file.getPath(), this.filePos);
            }
            this.filePos += (long)fe.size;
            if (fe.keyLen > 0) {
                if (buf.capacity() < fe.keyLen) {
                    buf = java.nio.ByteBuffer.allocate(fe.keyLen);
                }
                buf.clear().limit(fe.keyLen);
                this.channel.read(buf, fe.offset + 24L);
                Object key = this.ctx.getMarshaller().objectFromByteBuffer(buf.array(), 0, fe.keyLen);
                this.entries.put(key, fe);
                continue;
            }
            this.freeList.add(fe);
        }
    }

    @Override
    public boolean contains(Object key) {
        return this.entries.containsKey(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileEntry allocate(int len) {
        SortedSet<FileEntry> sortedSet = this.freeList;
        synchronized (sortedSet) {
            SortedSet<FileEntry> candidates = this.freeList.tailSet(new FileEntry(0L, len));
            Iterator it = candidates.iterator();
            while (it.hasNext()) {
                FileEntry free = (FileEntry)it.next();
                if (free.isLocked()) continue;
                it.remove();
                return free;
            }
            FileEntry fe = new FileEntry(this.filePos, len);
            this.filePos += (long)len;
            log.tracef("New entry allocated, file size is %d", (Object)this.filePos);
            return fe;
        }
    }

    private void free(FileEntry fe) throws IOException {
        if (fe != null) {
            this.channel.write(java.nio.ByteBuffer.wrap(ZERO_INT), fe.offset + 4L);
            if (trace) {
                log.tracef("Deleted entry at %d", (Object)fe.offset);
            }
            this.freeList.add(fe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(MarshalledEntry marshalledEntry) {
        try {
            ByteBuffer key = marshalledEntry.getKeyBytes();
            ByteBuffer data = marshalledEntry.getValueBytes();
            ByteBuffer metadata = marshalledEntry.getMetadataBytes();
            int metadataLength = metadata == null ? 0 : metadata.getLength();
            int len = 24 + key.getLength() + data.getLength() + metadataLength;
            FileEntry fe = null;
            this.resizeLock.readLock().lock();
            try {
                fe = this.allocate(len);
                long expiryTime = metadata != null ? marshalledEntry.getMetadata().expiryTime() : -1L;
                fe = new FileEntry(fe, key.getLength(), data.getLength(), metadataLength, expiryTime);
                java.nio.ByteBuffer buf = java.nio.ByteBuffer.allocate(len);
                buf.putInt(fe.size);
                buf.putInt(fe.keyLen);
                buf.putInt(fe.dataLen);
                buf.putInt(fe.metadataLen);
                buf.putLong(fe.expiryTime);
                buf.put(key.getBuf(), key.getOffset(), key.getLength());
                buf.put(data.getBuf(), data.getOffset(), data.getLength());
                if (metadata != null) {
                    buf.put(metadata.getBuf(), metadata.getOffset(), metadata.getLength());
                }
                buf.flip();
                this.channel.write(buf, fe.offset);
                if (trace) {
                    log.tracef("Wrote entry %s at %d", marshalledEntry.getKey(), (Object)fe.offset);
                }
                if ((fe = this.entries.put(marshalledEntry.getKey(), fe)) == null) {
                    fe = this.evict();
                }
            }
            finally {
                try {
                    this.free(fe);
                }
                finally {
                    this.resizeLock.readLock().unlock();
                }
            }
        }
        catch (Exception e) {
            throw new PersistenceException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileEntry evict() {
        if (this.configuration.maxEntries() > 0) {
            Map<Object, FileEntry> map = this.entries;
            synchronized (map) {
                if (this.entries.size() > this.configuration.maxEntries()) {
                    Iterator<FileEntry> it = this.entries.values().iterator();
                    FileEntry fe = it.next();
                    it.remove();
                    return fe;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.resizeLock.writeLock().lock();
        try {
            Map<Object, FileEntry> map = this.entries;
            synchronized (map) {
                SortedSet<FileEntry> sortedSet = this.freeList;
                synchronized (sortedSet) {
                    for (FileEntry fe : this.entries.values()) {
                        fe.waitUnlocked();
                    }
                    for (FileEntry fe : this.freeList) {
                        fe.waitUnlocked();
                    }
                    this.entries.clear();
                    this.freeList.clear();
                    if (trace) {
                        log.tracef("Truncating file, current size is %d", (Object)this.filePos);
                    }
                    this.channel.truncate(0L);
                    this.channel.write(java.nio.ByteBuffer.wrap(MAGIC), 0L);
                    this.filePos = MAGIC.length;
                }
            }
        }
        catch (Exception e) {
            throw new PersistenceException(e);
        }
        finally {
            this.resizeLock.writeLock().unlock();
        }
    }

    @Override
    public boolean delete(Object key) {
        this.resizeLock.readLock().lock();
        try {
            FileEntry fe = this.entries.remove(key);
            this.free(fe);
            boolean bl = fe != null;
            return bl;
        }
        catch (Exception e) {
            throw new PersistenceException(e);
        }
        finally {
            this.resizeLock.readLock().unlock();
        }
    }

    @Override
    public MarshalledEntry load(Object key) {
        return this._load(key, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MarshalledEntry _load(Object key, boolean loadValue, boolean loadMetadata) {
        byte[] data;
        FileEntry fe;
        block21: {
            this.resizeLock.readLock().lock();
            try {
                boolean expired;
                Map<Object, FileEntry> map = this.entries;
                synchronized (map) {
                    block20: {
                        fe = this.entries.get(key);
                        if (fe != null) break block20;
                        MarshalledEntry marshalledEntry = null;
                        return marshalledEntry;
                    }
                    expired = fe.isExpired(System.currentTimeMillis());
                    if (expired) {
                        this.entries.remove(key);
                    } else {
                        fe.lock();
                    }
                }
                if (!expired) break block21;
                try {
                    this.free(fe);
                }
                catch (IOException e) {
                    throw new PersistenceException(e);
                }
                MarshalledEntry e = null;
                return e;
            }
            finally {
                this.resizeLock.readLock().unlock();
            }
        }
        try {
            data = new byte[fe.keyLen + (loadValue ? fe.dataLen : 0) + (loadMetadata ? fe.metadataLen : 0)];
            this.channel.read(java.nio.ByteBuffer.wrap(data), fe.offset + 24L);
        }
        catch (Exception e) {
            throw new PersistenceException(e);
        }
        finally {
            fe.unlock();
        }
        if (trace) {
            log.tracef("Read entry %s at %d", key, (Object)fe.offset);
        }
        ByteBufferFactory factory = this.ctx.getByteBufferFactory();
        ByteBuffer keyBb = factory.newByteBuffer(data, 0, fe.keyLen);
        ByteBuffer valueBb = null;
        ByteBuffer metadataBb = null;
        if (loadValue) {
            valueBb = factory.newByteBuffer(data, fe.keyLen, fe.dataLen);
            if (loadMetadata && fe.metadataLen > 0) {
                metadataBb = factory.newByteBuffer(data, fe.keyLen + fe.dataLen, fe.metadataLen);
            }
        }
        return this.ctx.getMarshalledEntryFactory().newMarshalledEntry(keyBb, valueBb, metadataBb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(AdvancedCacheLoader.KeyFilter filter, final AdvancedCacheLoader.CacheLoaderTask task, Executor executor, final boolean fetchValue, final boolean fetchMetadata) {
        filter = PersistenceUtil.notNull(filter);
        HashSet<Object> keysToLoad = new HashSet<Object>(this.entries.size());
        Map<Object, FileEntry> map = this.entries;
        synchronized (map) {
            for (Object k : this.entries.keySet()) {
                if (!filter.shouldLoadKey(k)) continue;
                keysToLoad.add(k);
            }
        }
        ExecutorAllCompletionService eacs = new ExecutorAllCompletionService(executor);
        final TaskContextImpl taskContext = new TaskContextImpl();
        boolean taskCount = false;
        for (final Object e : keysToLoad) {
            if (taskContext.isStopped()) break;
            eacs.submit(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    try {
                        MarshalledEntry marshalledEntry = SingleFileStore.this._load(e, fetchValue, fetchMetadata);
                        if (marshalledEntry != null) {
                            task.processEntry(marshalledEntry, taskContext);
                        }
                        return null;
                    }
                    catch (Exception e2) {
                        log.errorExecutingParallelStoreTask(e2);
                        throw e2;
                    }
                }
            });
        }
        eacs.waitUntilAllCompleted();
        if (eacs.isExceptionThrown()) {
            throw new PersistenceException("Execution exception!", eacs.getFirstException());
        }
    }

    @Override
    public void purge(Executor threadPool, final AdvancedCacheWriter.PurgeListener task) {
        threadPool.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                long now = System.currentTimeMillis();
                ArrayList entriesToPurge = new ArrayList();
                Map map = SingleFileStore.this.entries;
                synchronized (map) {
                    Iterator it = SingleFileStore.this.entries.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry next = it.next();
                        FileEntry fe = (FileEntry)next.getValue();
                        if (!fe.isExpired(now)) continue;
                        it.remove();
                        entriesToPurge.add(new KeyValuePair(next.getKey(), fe));
                    }
                }
                SingleFileStore.this.resizeLock.readLock().lock();
                try {
                    Iterator it = entriesToPurge.iterator();
                    while (it.hasNext()) {
                        KeyValuePair next = (KeyValuePair)it.next();
                        FileEntry fe = (FileEntry)next.getValue();
                        if (!fe.isExpired(now)) continue;
                        it.remove();
                        try {
                            SingleFileStore.this.free(fe);
                        }
                        catch (Exception e) {
                            throw new PersistenceException(e);
                        }
                        if (task == null) continue;
                        task.entryPurged(next.getKey());
                    }
                }
                finally {
                    SingleFileStore.this.resizeLock.readLock().unlock();
                }
            }
        });
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    Map<Object, FileEntry> getEntries() {
        return this.entries;
    }

    SortedSet<FileEntry> getFreeList() {
        return this.freeList;
    }

    long getFileSize() {
        return this.filePos;
    }

    public SingleFileStoreConfiguration getConfiguration() {
        return this.configuration;
    }

    private static class FileEntry
    implements Comparable<FileEntry> {
        private final long offset;
        private final int size;
        private final int keyLen;
        private final int dataLen;
        private final int metadataLen;
        private final long expiryTime;
        private transient int readers = 0;

        public FileEntry(long offset, int size) {
            this(offset, size, 0, 0, 0, -1L);
        }

        public FileEntry(long offset, int size, int keyLen, int dataLen, int metadataLen, long expiryTime) {
            this.offset = offset;
            this.size = size;
            this.keyLen = keyLen;
            this.dataLen = dataLen;
            this.metadataLen = metadataLen;
            this.expiryTime = expiryTime;
        }

        public FileEntry(FileEntry fe, int keyLen, int dataLen, int metadataLen, long expiryTime) {
            this(fe.offset, fe.size, keyLen, dataLen, metadataLen, expiryTime);
        }

        public synchronized boolean isLocked() {
            return this.readers > 0;
        }

        public synchronized void lock() {
            ++this.readers;
        }

        public synchronized void unlock() {
            --this.readers;
            if (this.readers == 0) {
                this.notifyAll();
            }
        }

        public synchronized void waitUnlocked() {
            while (this.readers > 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        public boolean isExpired(long now) {
            return this.expiryTime > 0L && this.expiryTime < now;
        }

        @Override
        public int compareTo(FileEntry fe) {
            int diff = this.size - fe.size;
            return diff != 0 ? diff : (this.offset > fe.offset ? 1 : -1);
        }
    }
}

