/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.support;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.infinispan.commons.equivalence.AnyEquivalence;
import org.infinispan.commons.equivalence.Equivalence;
import org.infinispan.commons.util.CollectionFactory;
import org.infinispan.marshall.core.MarshalledEntry;
import org.infinispan.persistence.PersistenceUtil;
import org.infinispan.persistence.spi.AdvancedCacheLoader;
import org.infinispan.util.TimeService;

public final class Bucket {
    final Map<Object, MarshalledEntry> entries;
    private transient Integer bucketId;
    private transient String bucketIdStr;

    public Bucket(Equivalence<Object> keyEquivalence) {
        this.entries = CollectionFactory.makeMap(32, keyEquivalence, AnyEquivalence.getInstance());
    }

    public Bucket(Map<Object, MarshalledEntry> entries, Equivalence<Object> keyEquivalence) {
        this.entries = CollectionFactory.makeMap(entries, keyEquivalence, AnyEquivalence.getInstance());
    }

    public final void addEntry(Object key, MarshalledEntry sv) {
        this.entries.put(key, sv);
    }

    public final boolean removeEntry(Object key) {
        return this.entries.remove(key) != null;
    }

    public final MarshalledEntry getEntry(Object key, TimeService timeService) {
        MarshalledEntry marshalledEntry = this.entries.get(key);
        if (marshalledEntry == null) {
            return null;
        }
        if (marshalledEntry.getMetadata() != null && marshalledEntry.getMetadata().isExpired(timeService.wallClockTime())) {
            return null;
        }
        return marshalledEntry;
    }

    public Integer getBucketId() {
        return this.bucketId;
    }

    public void setBucketId(Integer bucketId) {
        this.bucketId = bucketId;
        this.bucketIdStr = bucketId.toString();
    }

    public void setBucketId(String bucketId) {
        try {
            this.setBucketId(Integer.parseInt(bucketId));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("bucketId: " + bucketId + " (expected: integer)");
        }
    }

    public String getBucketIdAsString() {
        return this.bucketIdStr;
    }

    public Set<Object> removeExpiredEntries(TimeService timeService) {
        HashSet<Object> result = new HashSet<Object>();
        long currentTimeMillis = 0L;
        Iterator<Map.Entry<Object, MarshalledEntry>> entryIterator = this.entries.entrySet().iterator();
        while (entryIterator.hasNext()) {
            Map.Entry<Object, MarshalledEntry> entry = entryIterator.next();
            MarshalledEntry value = entry.getValue();
            if (value.getMetadata() == null) continue;
            if (currentTimeMillis == 0L) {
                currentTimeMillis = timeService.wallClockTime();
            }
            if (!value.getMetadata().isExpired(currentTimeMillis)) continue;
            result.add(entry.getKey());
            entryIterator.remove();
        }
        return result;
    }

    public Map<Object, MarshalledEntry> getStoredEntries() {
        return this.entries;
    }

    public Map<Object, MarshalledEntry> getStoredEntries(AdvancedCacheLoader.KeyFilter filter, TimeService timeService) {
        filter = PersistenceUtil.notNull(filter);
        long currentTimeMillis = timeService.wallClockTime();
        HashMap<Object, MarshalledEntry> result = new HashMap<Object, MarshalledEntry>();
        for (Map.Entry<Object, MarshalledEntry> entry : this.getStoredEntries().entrySet()) {
            MarshalledEntry me = entry.getValue();
            if (this.isExpired(currentTimeMillis, me) || !filter.shouldLoadKey(entry.getKey())) continue;
            result.put(entry.getKey(), me);
        }
        return result;
    }

    private boolean isExpired(long currentTimeMillis, MarshalledEntry me) {
        return me != null && me.getMetadata() != null && me.getMetadata().isExpired(currentTimeMillis);
    }

    public long timestampOfFirstEntryToExpire() {
        long result = Long.MAX_VALUE;
        for (MarshalledEntry se : this.entries.values()) {
            if (se.getMetadata() == null || se.getMetadata().expiryTime() >= result) continue;
            result = se.getMetadata().expiryTime();
        }
        return result;
    }

    public String toString() {
        return "Bucket{entries=" + this.entries + ", bucketId='" + this.bucketId + '\'' + '}';
    }

    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    public boolean contains(Object key, TimeService timeService) {
        return this.getEntry(key, timeService) != null;
    }
}

