/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting;

import java.util.concurrent.TimeUnit;
import org.infinispan.commands.CancellableCommand;
import org.infinispan.commands.CancellationService;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.TopologyAffectedCommand;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.commands.remote.MultipleRpcCommand;
import org.infinispan.commands.remote.SingleRpcCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.totalorder.TotalOrderCommitCommand;
import org.infinispan.commands.tx.totalorder.TotalOrderPrepareCommand;
import org.infinispan.commands.tx.totalorder.TotalOrderRollbackCommand;
import org.infinispan.commands.tx.totalorder.TotalOrderVersionedCommitCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.interceptors.totalorder.RetryPrepareException;
import org.infinispan.remoting.InboundInvocationHandler;
import org.infinispan.remoting.responses.CacheNotFoundResponse;
import org.infinispan.remoting.responses.ExceptionResponse;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.ResponseGenerator;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.statetransfer.StateTransferLock;
import org.infinispan.statetransfer.StateTransferManager;
import org.infinispan.transaction.TotalOrderRemoteTransactionState;
import org.infinispan.transaction.totalorder.TotalOrderLatch;
import org.infinispan.transaction.totalorder.TotalOrderManager;
import org.infinispan.util.concurrent.BlockingRunnable;
import org.infinispan.util.concurrent.BlockingTaskAwareExecutorService;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Scope(value=Scopes.GLOBAL)
public class InboundInvocationHandlerImpl
implements InboundInvocationHandler {
    private GlobalComponentRegistry gcr;
    private static final Log log = LogFactory.getLog(InboundInvocationHandlerImpl.class);
    private static final boolean trace = log.isTraceEnabled();
    private Transport transport;
    private CancellationService cancelService;
    private BlockingTaskAwareExecutorService remoteCommandsExecutor;
    private BlockingTaskAwareExecutorService totalOrderExecutorService;

    @Inject
    public void inject(GlobalComponentRegistry gcr, Transport transport, @ComponentName(value="org.infinispan.executors.remote") BlockingTaskAwareExecutorService remoteCommandsExecutor, @ComponentName(value="org.infinispan.executors.totalOrderExecutor") BlockingTaskAwareExecutorService totalOrderExecutorService, CancellationService cancelService) {
        this.gcr = gcr;
        this.transport = transport;
        this.cancelService = cancelService;
        this.remoteCommandsExecutor = remoteCommandsExecutor;
        this.totalOrderExecutorService = totalOrderExecutorService;
    }

    @Override
    public void handle(CacheRpcCommand cmd, Address origin, org.jgroups.blocks.Response response, boolean preserveOrder) throws Throwable {
        cmd.setOrigin(origin);
        String cacheName = cmd.getCacheName();
        ComponentRegistry cr = this.gcr.getNamedComponentRegistry(cacheName);
        if (cr == null) {
            if (trace) {
                log.tracef("Silently ignoring that %s cache is not defined", (Object)cacheName);
            }
            this.reply(response, CacheNotFoundResponse.INSTANCE);
            return;
        }
        this.handleWithWaitForBlocks(cmd, cr, response, preserveOrder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response handleInternal(CacheRpcCommand cmd, ComponentRegistry cr) throws Throwable {
        try {
            if (trace) {
                log.tracef("Calling perform() on %s", (Object)cmd);
            }
            ResponseGenerator respGen = cr.getResponseGenerator();
            if (cmd instanceof CancellableCommand) {
                this.cancelService.register(Thread.currentThread(), ((CancellableCommand)cmd).getUUID());
            }
            Object retval = cmd.perform(null);
            Response response = respGen.getResponse(cmd, retval);
            log.tracef("About to send back response %s for command %s", (Object)response, (Object)cmd);
            Response response2 = response;
            return response2;
        }
        catch (Exception e) {
            log.exceptionExecutingInboundCommand(e);
            ExceptionResponse exceptionResponse = new ExceptionResponse(e);
            return exceptionResponse;
        }
        finally {
            if (cmd instanceof CancellableCommand) {
                this.cancelService.unregister(((CancellableCommand)cmd).getUUID());
            }
        }
    }

    private void handleWithWaitForBlocks(final CacheRpcCommand cmd, final ComponentRegistry cr, final org.jgroups.blocks.Response response, boolean preserveOrder) throws Throwable {
        StateTransferManager stm = cr.getStateTransferManager();
        if (cmd instanceof TotalOrderPrepareCommand && !stm.ownsData()) {
            this.reply(response, null);
            return;
        }
        CommandsFactory commandsFactory = cr.getCommandsFactory();
        commandsFactory.initializeReplicableCommand(cmd, true);
        if (cmd instanceof TotalOrderPrepareCommand) {
            final TotalOrderRemoteTransactionState state = ((TotalOrderPrepareCommand)cmd).getOrCreateState();
            final TotalOrderManager totalOrderManager = cr.getTotalOrderManager();
            totalOrderManager.ensureOrder(state, ((PrepareCommand)cmd).getAffectedKeysToLock(false));
            this.totalOrderExecutorService.execute(new BlockingRunnable(){

                @Override
                public boolean isReady() {
                    for (TotalOrderLatch block : state.getConflictingTransactionBlocks()) {
                        if (!block.isBlocked()) continue;
                        return false;
                    }
                    return true;
                }

                @Override
                public void run() {
                    Response resp;
                    try {
                        resp = InboundInvocationHandlerImpl.this.handleInternal(cmd, cr);
                    }
                    catch (RetryPrepareException retry) {
                        log.debugf((Throwable)retry, "Prepare [%s] conflicted with state transfer", (Object)cmd);
                        resp = new ExceptionResponse(retry);
                    }
                    catch (Throwable throwable) {
                        log.exceptionHandlingCommand(cmd, throwable);
                        resp = new ExceptionResponse(new CacheException("Problems invoking command.", throwable));
                    }
                    InboundInvocationHandlerImpl.this.reply(response, resp);
                    if (resp instanceof ExceptionResponse) {
                        totalOrderManager.release(state);
                    }
                    InboundInvocationHandlerImpl.this.afterResponseSent(cmd, resp);
                }
            });
        } else {
            final StateTransferLock stateTransferLock = cr.getStateTransferLock();
            final int commandTopologyId = this.extractCommandTopologyId(cmd);
            if (!preserveOrder && cmd.canBlock()) {
                this.remoteCommandsExecutor.execute(new BlockingRunnable(){

                    @Override
                    public boolean isReady() {
                        return stateTransferLock.transactionDataReceived(commandTopologyId);
                    }

                    @Override
                    public void run() {
                        Response resp;
                        try {
                            resp = InboundInvocationHandlerImpl.this.handleInternal(cmd, cr);
                        }
                        catch (Throwable throwable) {
                            log.exceptionHandlingCommand(cmd, throwable);
                            resp = new ExceptionResponse(new CacheException("Problems invoking command.", throwable));
                        }
                        InboundInvocationHandlerImpl.this.reply(response, resp);
                        InboundInvocationHandlerImpl.this.afterResponseSent(cmd, resp);
                    }
                });
            } else {
                stateTransferLock.waitForTransactionData(commandTopologyId, 1L, TimeUnit.DAYS);
                Response resp = this.handleInternal(cmd, cr);
                if (trace && resp != null && !resp.isValid()) {
                    log.tracef("Unable to execute command, got invalid response %s", (Object)resp);
                }
                this.reply(response, resp);
                this.afterResponseSent(cmd, resp);
            }
        }
    }

    private int extractCommandTopologyId(CacheRpcCommand cmd) {
        int commandTopologyId = -1;
        if (cmd instanceof SingleRpcCommand) {
            ReplicableCommand innerCmd = ((SingleRpcCommand)cmd).getCommand();
            if (innerCmd instanceof TopologyAffectedCommand) {
                commandTopologyId = ((TopologyAffectedCommand)innerCmd).getTopologyId();
            }
        } else if (cmd instanceof MultipleRpcCommand) {
            for (ReplicableCommand innerCmd : ((MultipleRpcCommand)cmd).getCommands()) {
                if (!(innerCmd instanceof TopologyAffectedCommand)) continue;
                commandTopologyId = Math.max(((TopologyAffectedCommand)innerCmd).getTopologyId(), commandTopologyId);
            }
        } else if (cmd instanceof TopologyAffectedCommand) {
            commandTopologyId = ((TopologyAffectedCommand)((Object)cmd)).getTopologyId();
        }
        return commandTopologyId;
    }

    private void reply(org.jgroups.blocks.Response response, Object retVal) {
        if (response != null) {
            response.send(retVal, false);
        }
    }

    private void afterResponseSent(CacheRpcCommand command, Response resp) {
        if (command instanceof TotalOrderCommitCommand || command instanceof TotalOrderVersionedCommitCommand || command instanceof TotalOrderRollbackCommand || command instanceof TotalOrderPrepareCommand && (((PrepareCommand)command).isOnePhaseCommit() || resp instanceof ExceptionResponse)) {
            this.totalOrderExecutorService.checkForReadyTasks();
        }
    }
}

