/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.remote.MultipleRpcCommand;
import org.infinispan.configuration.cache.AsyncConfiguration;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.remoting.ReplicationQueue;
import org.infinispan.remoting.rpc.ResponseMode;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class ReplicationQueueImpl
implements ReplicationQueue {
    private static final Log log = LogFactory.getLog(ReplicationQueue.class);
    private long maxElements = 500L;
    private final BlockingQueue<ReplicableCommand> elements = new LinkedBlockingQueue<ReplicableCommand>();
    private ScheduledExecutorService scheduledExecutor = null;
    private RpcManager rpcManager;
    private Configuration configuration;
    private boolean enabled;
    private CommandsFactory commandsFactory;
    private volatile ScheduledFuture<?> scheduledFuture;
    private boolean trace;
    private String cacheName;

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Inject
    public void injectDependencies(@ComponentName(value="org.infinispan.executors.replicationQueue") ScheduledExecutorService executor, RpcManager rpcManager, Configuration configuration, CommandsFactory commandsFactory, Cache cache) {
        this.injectDependencies(executor, rpcManager, configuration, commandsFactory, cache.getName());
    }

    public void injectDependencies(ScheduledExecutorService executor, RpcManager rpcManager, Configuration configuration, CommandsFactory commandsFactory, String cacheName) {
        this.rpcManager = rpcManager;
        this.configuration = configuration;
        this.commandsFactory = commandsFactory;
        this.scheduledExecutor = executor;
        this.cacheName = cacheName;
    }

    @Override
    @Start
    public void start() {
        AsyncConfiguration asyncCfg = this.configuration.clustering().async();
        long interval = asyncCfg.replQueueInterval();
        this.trace = log.isTraceEnabled();
        if (this.trace) {
            log.tracef("Starting replication queue, with interval %d and maxElements %s", (Object)interval, (Object)this.maxElements);
        }
        this.maxElements = asyncCfg.replQueueMaxElements();
        this.enabled = asyncCfg.useReplQueue();
        if (this.enabled && interval > 0L) {
            this.scheduledFuture = this.scheduledExecutor.scheduleWithFixedDelay(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    LogFactory.pushNDC(ReplicationQueueImpl.this.cacheName, ReplicationQueueImpl.this.trace);
                    try {
                        ReplicationQueueImpl.this.flush();
                    }
                    finally {
                        LogFactory.popNDC(ReplicationQueueImpl.this.trace);
                    }
                }
            }, interval, interval, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    @Stop(priority=9)
    public void stop() {
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(true);
        }
        try {
            this.flush();
        }
        catch (Exception e) {
            log.debug("Unable to perform final flush before shutting down", e);
        }
        this.scheduledExecutor = null;
    }

    @Override
    public void add(ReplicableCommand job) {
        if (job == null) {
            throw new NullPointerException("job is null");
        }
        try {
            this.elements.put(job);
            if ((long)this.elements.size() >= this.maxElements) {
                this.flush();
            }
        }
        catch (InterruptedException ie) {
            Thread.interrupted();
        }
    }

    @Override
    public synchronized int flush() {
        int toReplicateSize;
        List<ReplicableCommand> toReplicate = this.drainReplQueue();
        if (this.trace) {
            log.tracef("flush(): flushing repl queue (num elements=%s)", (Object)toReplicate.size());
        }
        if ((toReplicateSize = toReplicate.size()) > 0) {
            try {
                log.tracef("Flushing %s elements", (Object)toReplicateSize);
                MultipleRpcCommand multipleRpcCommand = this.commandsFactory.buildReplicateCommand(toReplicate);
                this.rpcManager.invokeRemotely(null, (ReplicableCommand)multipleRpcCommand, this.rpcManager.getRpcOptionsBuilder(ResponseMode.getAsyncResponseMode(this.configuration)).skipReplicationQueue(true).build());
            }
            catch (Throwable t) {
                log.failedReplicatingQueue(toReplicate.size(), t);
            }
        }
        return toReplicateSize;
    }

    protected List<ReplicableCommand> drainReplQueue() {
        LinkedList<ReplicableCommand> toReplicate = new LinkedList<ReplicableCommand>();
        this.elements.drainTo(toReplicate);
        return toReplicate;
    }

    protected Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public int getElementsCount() {
        return this.elements.size();
    }

    @Override
    public void reset() {
        this.elements.clear();
    }
}

