/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.topology;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import org.infinispan.commons.hash.Hash;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.distribution.ch.ConsistentHashFactory;

public class CacheJoinInfo {
    private final ConsistentHashFactory consistentHashFactory;
    private final Hash hashFunction;
    private final int numSegments;
    private final int numOwners;
    private final long timeout;
    private final boolean totalOrder;
    private final boolean distributed;
    private final float capacityFactor;

    public CacheJoinInfo(ConsistentHashFactory consistentHashFactory, Hash hashFunction, int numSegments, int numOwners, long timeout, boolean totalOrder, boolean distributed, float capacityFactor) {
        this.consistentHashFactory = consistentHashFactory;
        this.hashFunction = hashFunction;
        this.numSegments = numSegments;
        this.numOwners = numOwners;
        this.timeout = timeout;
        this.totalOrder = totalOrder;
        this.distributed = distributed;
        this.capacityFactor = capacityFactor;
    }

    public ConsistentHashFactory getConsistentHashFactory() {
        return this.consistentHashFactory;
    }

    public Hash getHashFunction() {
        return this.hashFunction;
    }

    public int getNumSegments() {
        return this.numSegments;
    }

    public int getNumOwners() {
        return this.numOwners;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public boolean isTotalOrder() {
        return this.totalOrder;
    }

    public boolean isDistributed() {
        return this.distributed;
    }

    public float getCapacityFactor() {
        return this.capacityFactor;
    }

    public String toString() {
        return "CacheJoinInfo{consistentHashFactory=" + this.consistentHashFactory + ", hashFunction=" + this.hashFunction + ", numSegments=" + this.numSegments + ", numOwners=" + this.numOwners + ", timeout=" + this.timeout + ", totalOrder=" + this.totalOrder + ", distributed=" + this.distributed + '}';
    }

    public static class Externalizer
    extends AbstractExternalizer<CacheJoinInfo> {
        @Override
        public void writeObject(ObjectOutput output, CacheJoinInfo cacheJoinInfo) throws IOException {
            output.writeObject(cacheJoinInfo.consistentHashFactory);
            output.writeObject(cacheJoinInfo.hashFunction);
            output.writeInt(cacheJoinInfo.numSegments);
            output.writeInt(cacheJoinInfo.numOwners);
            output.writeLong(cacheJoinInfo.timeout);
            output.writeBoolean(cacheJoinInfo.totalOrder);
            output.writeBoolean(cacheJoinInfo.distributed);
            output.writeFloat(cacheJoinInfo.capacityFactor);
        }

        @Override
        public CacheJoinInfo readObject(ObjectInput unmarshaller) throws IOException, ClassNotFoundException {
            ConsistentHashFactory consistentHashFactory = (ConsistentHashFactory)unmarshaller.readObject();
            Hash hashFunction = (Hash)unmarshaller.readObject();
            int numSegments = unmarshaller.readInt();
            int numOwners = unmarshaller.readInt();
            long timeout = unmarshaller.readLong();
            boolean totalOrder = unmarshaller.readBoolean();
            boolean distributed = unmarshaller.readBoolean();
            float capacityFactor = unmarshaller.readFloat();
            return new CacheJoinInfo(consistentHashFactory, hashFunction, numSegments, numOwners, timeout, totalOrder, distributed, capacityFactor);
        }

        @Override
        public Integer getId() {
            return 87;
        }

        @Override
        public Set<Class<? extends CacheJoinInfo>> getTypeClasses() {
            return Collections.singleton(CacheJoinInfo.class);
        }
    }
}

