/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.infinispan;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.camel.Endpoint;
import org.apache.camel.InvokeOnHeader;
import org.apache.camel.InvokeOnHeaders;
import org.apache.camel.Message;
import org.apache.camel.component.infinispan.InfinispanConfiguration;
import org.apache.camel.component.infinispan.InfinispanEndpoint;
import org.apache.camel.component.infinispan.InfinispanManager;
import org.apache.camel.component.infinispan.InfinispanUtil;
import org.apache.camel.component.infinispan.remote.InfinispanRemoteOperation;
import org.apache.camel.impl.HeaderSelectorProducer;
import org.apache.camel.util.ObjectHelper;
import org.infinispan.commons.api.BasicCache;
import org.infinispan.query.dsl.Query;
import org.infinispan.stats.Stats;

public class InfinispanProducer
extends HeaderSelectorProducer {
    private final String cacheName;
    private final InfinispanConfiguration configuration;
    private final InfinispanManager manager;

    public InfinispanProducer(InfinispanEndpoint endpoint, String cacheName, InfinispanConfiguration configuration) {
        super((Endpoint)endpoint, "CamelInfinispanOperation", () -> configuration.getOperationOrDefault().name(), false);
        this.cacheName = cacheName;
        this.configuration = configuration;
        this.manager = new InfinispanManager(endpoint.getCamelContext(), configuration);
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.manager.start();
    }

    protected void doStop() throws Exception {
        this.manager.stop();
        super.doStop();
    }

    @InvokeOnHeaders(value={@InvokeOnHeader(value="PUT"), @InvokeOnHeader(value="CamelInfinispanOperationPut")})
    void onPut(Message message) {
        Object result;
        BasicCache<Object, Object> cache = this.manager.getCache(message, this.cacheName);
        Object key = message.getHeader("CamelInfinispanKey");
        Object value = message.getHeader("CamelInfinispanValue");
        if (this.hasLifespan(message)) {
            long lifespan = (Long)message.getHeader("CamelInfinispanLifespanTime", Long.TYPE);
            TimeUnit timeUnit = (TimeUnit)((Object)message.getHeader("CamelInfinispanTimeUnit", TimeUnit.class));
            if (this.hasMaxIdleTime(message)) {
                long maxIdle = (Long)message.getHeader("CamelInfinispanMaxIdleTime", Long.TYPE);
                TimeUnit maxIdleTimeUnit = (TimeUnit)((Object)message.getHeader("CamelInfinispanMaxIdleTimeUnit", TimeUnit.class));
                result = cache.put(key, value, lifespan, timeUnit, maxIdle, maxIdleTimeUnit);
            } else {
                result = cache.put(key, value, lifespan, timeUnit);
            }
        } else {
            result = cache.put(key, value);
        }
        this.setResult(message, result);
    }

    @InvokeOnHeaders(value={@InvokeOnHeader(value="PUTASYNC"), @InvokeOnHeader(value="CamelInfinispanOperationPutAsync")})
    void onPutAsync(Message message) {
        CompletableFuture<Object> result;
        BasicCache<Object, Object> cache = this.manager.getCache(message, this.cacheName);
        Object key = message.getHeader("CamelInfinispanKey");
        Object value = message.getHeader("CamelInfinispanValue");
        if (this.hasLifespan(message)) {
            long lifespan = (Long)message.getHeader("CamelInfinispanLifespanTime", Long.TYPE);
            TimeUnit timeUnit = (TimeUnit)((Object)message.getHeader("CamelInfinispanTimeUnit", TimeUnit.class));
            if (this.hasMaxIdleTime(message)) {
                long maxIdle = (Long)message.getHeader("CamelInfinispanMaxIdleTime", Long.TYPE);
                TimeUnit maxIdleTimeUnit = (TimeUnit)((Object)message.getHeader("CamelInfinispanMaxIdleTimeUnit", TimeUnit.class));
                result = cache.putAsync(key, value, lifespan, timeUnit, maxIdle, maxIdleTimeUnit);
            } else {
                result = cache.putAsync(key, value, lifespan, timeUnit);
            }
        } else {
            result = cache.putAsync(key, value);
        }
        this.setResult(message, result);
    }

    @InvokeOnHeaders(value={@InvokeOnHeader(value="PUTALL"), @InvokeOnHeader(value="CamelInfinispanOperationPutAll")})
    void onPutAll(Message message) {
        BasicCache cache = this.manager.getCache(message, this.cacheName);
        Map map = (Map)message.getHeader("CamelInfinispanMap", Map.class);
        if (this.hasLifespan(message)) {
            long lifespan = (Long)message.getHeader("CamelInfinispanLifespanTime", Long.TYPE);
            TimeUnit timeUnit = (TimeUnit)((Object)message.getHeader("CamelInfinispanTimeUnit", TimeUnit.class));
            if (this.hasMaxIdleTime(message)) {
                long maxIdle = (Long)message.getHeader("CamelInfinispanMaxIdleTime", Long.TYPE);
                TimeUnit maxIdleTimeUnit = (TimeUnit)((Object)message.getHeader("CamelInfinispanMaxIdleTimeUnit", TimeUnit.class));
                cache.putAll(map, lifespan, timeUnit, maxIdle, maxIdleTimeUnit);
            } else {
                cache.putAll(map, lifespan, timeUnit);
            }
        } else {
            cache.putAll(map);
        }
    }

    @InvokeOnHeaders(value={@InvokeOnHeader(value="PUTALLASYNC"), @InvokeOnHeader(value="CamelInfinispanOperationPutAllAsync")})
    void onPutAllAsync(Message message) {
        CompletableFuture<Void> result;
        BasicCache cache = this.manager.getCache(message, this.cacheName);
        Map map = (Map)message.getHeader("CamelInfinispanMap", Map.class);
        if (this.hasLifespan(message)) {
            long lifespan = (Long)message.getHeader("CamelInfinispanLifespanTime", Long.TYPE);
            TimeUnit timeUnit = (TimeUnit)((Object)message.getHeader("CamelInfinispanTimeUnit", TimeUnit.class));
            if (this.hasMaxIdleTime(message)) {
                long maxIdle = (Long)message.getHeader("CamelInfinispanMaxIdleTime", Long.TYPE);
                TimeUnit maxIdleTimeUnit = (TimeUnit)((Object)message.getHeader("CamelInfinispanMaxIdleTimeUnit", TimeUnit.class));
                result = cache.putAllAsync(map, lifespan, timeUnit, maxIdle, maxIdleTimeUnit);
            } else {
                result = cache.putAllAsync(map, lifespan, timeUnit);
            }
        } else {
            result = cache.putAllAsync(map);
        }
        this.setResult(message, result);
    }

    @InvokeOnHeaders(value={@InvokeOnHeader(value="PUTIFABSENT"), @InvokeOnHeader(value="CamelInfinispanOperationPutIfAbsent")})
    void onPutIfAbsent(Message message) {
        Object result;
        BasicCache<Object, Object> cache = this.manager.getCache(message, this.cacheName);
        Object key = message.getHeader("CamelInfinispanKey");
        Object value = message.getHeader("CamelInfinispanValue");
        if (this.hasLifespan(message)) {
            long lifespan = (Long)message.getHeader("CamelInfinispanLifespanTime", Long.TYPE);
            TimeUnit timeUnit = (TimeUnit)((Object)message.getHeader("CamelInfinispanTimeUnit", TimeUnit.class));
            if (this.hasMaxIdleTime(message)) {
                long maxIdle = (Long)message.getHeader("CamelInfinispanMaxIdleTime", Long.TYPE);
                TimeUnit maxIdleTimeUnit = (TimeUnit)((Object)message.getHeader("CamelInfinispanMaxIdleTimeUnit", TimeUnit.class));
                result = cache.putIfAbsent(key, value, lifespan, timeUnit, maxIdle, maxIdleTimeUnit);
            } else {
                result = cache.putIfAbsent(key, value, lifespan, timeUnit);
            }
        } else {
            result = cache.putIfAbsent(key, value);
        }
        this.setResult(message, result);
    }

    @InvokeOnHeaders(value={@InvokeOnHeader(value="PUTIFABSENTASYNC"), @InvokeOnHeader(value="CamelInfinispanOperationPutIfAbsentAsync")})
    void onPutIfAbsentAsync(Message message) {
        CompletableFuture<Object> result;
        BasicCache<Object, Object> cache = this.manager.getCache(message, this.cacheName);
        Object key = message.getHeader("CamelInfinispanKey");
        Object value = message.getHeader("CamelInfinispanValue");
        if (this.hasLifespan(message)) {
            long lifespan = (Long)message.getHeader("CamelInfinispanLifespanTime", Long.TYPE);
            TimeUnit timeUnit = (TimeUnit)((Object)message.getHeader("CamelInfinispanTimeUnit", TimeUnit.class));
            if (this.hasMaxIdleTime(message)) {
                long maxIdle = (Long)message.getHeader("CamelInfinispanMaxIdleTime", Long.TYPE);
                TimeUnit maxIdleTimeUnit = (TimeUnit)((Object)message.getHeader("CamelInfinispanMaxIdleTimeUnit", TimeUnit.class));
                result = cache.putIfAbsentAsync(key, value, lifespan, timeUnit, maxIdle, maxIdleTimeUnit);
            } else {
                result = cache.putIfAbsentAsync(key, value, lifespan, timeUnit);
            }
        } else {
            result = cache.putIfAbsentAsync(key, value);
        }
        this.setResult(message, result);
    }

    @InvokeOnHeaders(value={@InvokeOnHeader(value="GET"), @InvokeOnHeader(value="CamelInfinispanOperationGet")})
    void onGet(Message message) {
        BasicCache cache = this.manager.getCache(message, this.cacheName);
        Object key = message.getHeader("CamelInfinispanKey");
        Object result = cache.get(key);
        this.setResult(message, result);
    }

    @InvokeOnHeader(value="GETORDEFAULT")
    void onGetOrDefault(Message message) {
        BasicCache cache = this.manager.getCache(message, this.cacheName);
        Object key = message.getHeader("CamelInfinispanKey");
        Object defaultValue = message.getHeader("CamelInfinispanDefaultValue");
        Object result = cache.getOrDefault(key, defaultValue);
        this.setResult(message, result);
    }

    @InvokeOnHeaders(value={@InvokeOnHeader(value="CONTAINSKEY"), @InvokeOnHeader(value="CamelInfinispanOperationContainsKey")})
    void onContainsKey(Message message) {
        BasicCache cache = this.manager.getCache(message, this.cacheName);
        Object key = message.getHeader("CamelInfinispanKey");
        Boolean result = cache.containsKey(key);
        this.setResult(message, result);
    }

    @InvokeOnHeaders(value={@InvokeOnHeader(value="CONTAINSVALUE"), @InvokeOnHeader(value="CamelInfinispanOperationContainsValue")})
    void onContainsValue(Message message) {
        BasicCache cache = this.manager.getCache(message, this.cacheName);
        Object value = message.getHeader("CamelInfinispanValue");
        Boolean result = cache.containsValue(value);
        this.setResult(message, result);
    }

    @InvokeOnHeaders(value={@InvokeOnHeader(value="REMOVE"), @InvokeOnHeader(value="CamelInfinispanOperationRemove")})
    void onRemove(Message message) {
        BasicCache cache = this.manager.getCache(message, this.cacheName);
        Object key = message.getHeader("CamelInfinispanKey");
        Object value = message.getHeader("CamelInfinispanValue");
        Object result = ObjectHelper.isEmpty((Object)value) ? cache.remove(key) : Boolean.valueOf(cache.remove(key, value));
        this.setResult(message, result);
    }

    @InvokeOnHeaders(value={@InvokeOnHeader(value="REMOVEASYNC"), @InvokeOnHeader(value="CamelInfinispanOperationRemoveAsync")})
    void onRemoveAsync(Message message) {
        BasicCache cache = this.manager.getCache(message, this.cacheName);
        Object key = message.getHeader("CamelInfinispanKey");
        Object value = message.getHeader("CamelInfinispanValue");
        if (ObjectHelper.isEmpty((Object)value)) {
            CompletableFuture resultRemoveAsyncKey = cache.removeAsync(key);
            this.setResult(message, resultRemoveAsyncKey);
        } else {
            CompletableFuture<Boolean> resultRemoveAsyncKeyValue = cache.removeAsync(key, value);
            this.setResult(message, resultRemoveAsyncKeyValue);
        }
    }

    @InvokeOnHeaders(value={@InvokeOnHeader(value="REPLACE"), @InvokeOnHeader(value="CamelInfinispanOperationReplace")})
    void onReplace(Message message) {
        Object result;
        BasicCache<Object, Object> cache = this.manager.getCache(message, this.cacheName);
        Object key = message.getHeader("CamelInfinispanKey");
        Object value = message.getHeader("CamelInfinispanValue");
        Object oldValue = message.getHeader("CamelInfinispanOldValue");
        if (this.hasLifespan(message)) {
            long lifespan = (Long)message.getHeader("CamelInfinispanLifespanTime", Long.TYPE);
            TimeUnit timeUnit = (TimeUnit)((Object)message.getHeader("CamelInfinispanTimeUnit", TimeUnit.class));
            if (this.hasMaxIdleTime(message)) {
                long maxIdle = (Long)message.getHeader("CamelInfinispanMaxIdleTime", Long.TYPE);
                TimeUnit maxIdleTimeUnit = (TimeUnit)((Object)message.getHeader("CamelInfinispanMaxIdleTimeUnit", TimeUnit.class));
                result = ObjectHelper.isEmpty((Object)oldValue) ? cache.replace(key, value, lifespan, timeUnit, maxIdle, maxIdleTimeUnit) : Boolean.valueOf(cache.replace(key, oldValue, value, lifespan, timeUnit, maxIdle, maxIdleTimeUnit));
            } else {
                result = ObjectHelper.isEmpty((Object)oldValue) ? cache.replace(key, value, lifespan, timeUnit) : Boolean.valueOf(cache.replace(key, oldValue, value, lifespan, timeUnit));
            }
        } else {
            result = ObjectHelper.isEmpty((Object)oldValue) ? cache.replace(key, value) : Boolean.valueOf(cache.replace(key, oldValue, value));
        }
        this.setResult(message, result);
    }

    @InvokeOnHeaders(value={@InvokeOnHeader(value="REPLACEASYNC"), @InvokeOnHeader(value="CamelInfinispanOperationReplaceAsync")})
    void onReplaceAsync(Message message) {
        BasicCache<Object, Object> cache = this.manager.getCache(message, this.cacheName);
        Object key = message.getHeader("CamelInfinispanKey");
        Object value = message.getHeader("CamelInfinispanValue");
        Object oldValue = message.getHeader("CamelInfinispanOldValue");
        if (this.hasLifespan(message)) {
            long lifespan = (Long)message.getHeader("CamelInfinispanLifespanTime", Long.TYPE);
            TimeUnit timeUnit = (TimeUnit)((Object)message.getHeader("CamelInfinispanTimeUnit", TimeUnit.class));
            if (this.hasMaxIdleTime(message)) {
                long maxIdle = (Long)message.getHeader("CamelInfinispanMaxIdleTime", Long.TYPE);
                TimeUnit maxIdleTimeUnit = (TimeUnit)((Object)message.getHeader("CamelInfinispanMaxIdleTimeUnit", TimeUnit.class));
                if (ObjectHelper.isEmpty((Object)oldValue)) {
                    CompletableFuture<Object> resultWithNewValue = cache.replaceAsync(key, value, lifespan, timeUnit, maxIdle, maxIdleTimeUnit);
                    this.setResult(message, resultWithNewValue);
                } else {
                    CompletableFuture<Boolean> resultWithNewAndOldValue = cache.replaceAsync(key, oldValue, value, lifespan, timeUnit, maxIdle, maxIdleTimeUnit);
                    this.setResult(message, resultWithNewAndOldValue);
                }
            } else if (ObjectHelper.isEmpty((Object)oldValue)) {
                CompletableFuture<Object> resultWithNewValue = cache.replaceAsync(key, value, lifespan, timeUnit);
                this.setResult(message, resultWithNewValue);
            } else {
                CompletableFuture<Boolean> resultWithNewAndOldValue = cache.replaceAsync(key, oldValue, value, lifespan, timeUnit);
                this.setResult(message, resultWithNewAndOldValue);
            }
        } else if (ObjectHelper.isEmpty((Object)oldValue)) {
            CompletableFuture<Object> resultWithNewValue = cache.replaceAsync(key, value);
            this.setResult(message, resultWithNewValue);
        } else {
            CompletableFuture<Boolean> resultWithNewAndOldValue = cache.replaceAsync(key, oldValue, value);
            this.setResult(message, resultWithNewAndOldValue);
        }
    }

    @InvokeOnHeaders(value={@InvokeOnHeader(value="SIZE"), @InvokeOnHeader(value="CamelInfinispanOperationSize")})
    void onSize(Message message) {
        BasicCache cache = this.manager.getCache(message, this.cacheName);
        Integer result = cache.size();
        this.setResult(message, result);
    }

    @InvokeOnHeaders(value={@InvokeOnHeader(value="CLEAR"), @InvokeOnHeader(value="CamelInfinispanOperationClear")})
    void onClear(Message message) {
        BasicCache cache = this.manager.getCache(message, this.cacheName);
        cache.clear();
    }

    @InvokeOnHeaders(value={@InvokeOnHeader(value="CLEARASYNC"), @InvokeOnHeader(value="CamelInfinispanOperationClearAsync")})
    void onCLearAsync(Message message) {
        BasicCache cache = this.manager.getCache(message, this.cacheName);
        CompletableFuture<Void> result = cache.clearAsync();
        this.setResult(message, result);
    }

    @InvokeOnHeaders(value={@InvokeOnHeader(value="QUERY"), @InvokeOnHeader(value="CamelInfinispanOperationQuery")})
    void onQuery(Message message) {
        BasicCache<Object, Object> cache = this.manager.getCache(message, this.cacheName);
        if (InfinispanUtil.isRemote(cache)) {
            Query query = InfinispanRemoteOperation.buildQuery(this.configuration, cache, message);
            if (query != null) {
                this.setResult(message, query.list());
            }
        } else {
            throw new UnsupportedOperationException("Query is supported on remote cache only");
        }
    }

    @InvokeOnHeaders(value={@InvokeOnHeader(value="STATS"), @InvokeOnHeader(value="CamelInfinispanOperationStats")})
    void onStats(Message message) {
        BasicCache cache = this.manager.getCache(message, this.cacheName);
        Stats result = InfinispanUtil.asAdvanced(cache).getStats();
        this.setResult(message, result);
    }

    private boolean hasLifespan(Message message) {
        return !InfinispanUtil.isHeaderEmpty(message, "CamelInfinispanLifespanTime") && !InfinispanUtil.isHeaderEmpty(message, "CamelInfinispanTimeUnit");
    }

    private boolean hasMaxIdleTime(Message message) {
        return !InfinispanUtil.isHeaderEmpty(message, "CamelInfinispanMaxIdleTime") && !InfinispanUtil.isHeaderEmpty(message, "CamelInfinispanMaxIdleTimeUnit");
    }

    private void setResult(Message message, Object result) {
        String resultHeader = (String)message.getHeader("CamelInfinispanOperationResultHeader", this.configuration::getResultHeader, String.class);
        if (resultHeader != null) {
            message.setHeader(resultHeader, result);
        } else {
            message.setBody(result);
        }
    }
}

