/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.infinispan;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ResourceHelper;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.commons.api.BasicCache;
import org.infinispan.commons.api.BasicCacheContainer;
import org.infinispan.context.Flag;
import org.infinispan.manager.EmbeddedCacheManager;

public final class InfinispanUtil {
    private InfinispanUtil() {
    }

    public static boolean isEmbedded(BasicCacheContainer container) {
        try {
            return container instanceof EmbeddedCacheManager;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static <K, V> boolean isEmbedded(BasicCache<K, V> cache) {
        try {
            return cache instanceof Cache;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static boolean isRemote(BasicCacheContainer container) {
        try {
            return container instanceof RemoteCacheManager;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static RemoteCacheManager asRemote(BasicCacheContainer container) {
        return (RemoteCacheManager)RemoteCacheManager.class.cast(container);
    }

    public static <K, V> boolean isRemote(BasicCache<K, V> cache) {
        try {
            return cache instanceof RemoteCache;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static <K, V> Cache<K, V> asEmbedded(BasicCache<K, V> cache) {
        return (Cache)Cache.class.cast(cache);
    }

    public static <K, V> RemoteCache<K, V> asRemote(BasicCache<K, V> cache) {
        return (RemoteCache)RemoteCache.class.cast(cache);
    }

    public static <K, V> AdvancedCache<K, V> asAdvanced(BasicCache<K, V> cache) {
        return ((Cache)Cache.class.cast(cache)).getAdvancedCache();
    }

    public static <K, V> BasicCache<K, V> ignoreReturnValuesCache(BasicCache<K, V> cache) {
        if (InfinispanUtil.isEmbedded(cache)) {
            return ((Cache)cache).getAdvancedCache().withFlags(Flag.IGNORE_RETURN_VALUES);
        }
        return cache;
    }

    public static boolean isInHeaderEmpty(Exchange exchange, String header) {
        return InfinispanUtil.isHeaderEmpty(exchange.getIn(), header);
    }

    public static boolean isHeaderEmpty(Message message, String header) {
        return ObjectHelper.isEmpty((Object)message.getHeader(header));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Properties loadProperties(CamelContext camelContext, String uri) throws Exception {
        try (InputStream is = InfinispanUtil.openInputStream(camelContext, uri);){
            Properties properties = new Properties();
            properties.load(is);
            Properties properties2 = properties;
            return properties2;
        }
        catch (IOException iOException) {
            throw new FileNotFoundException("Cannot find resource: " + uri);
        }
    }

    public static InputStream openInputStream(CamelContext camelContext, String uri) throws Exception {
        if (camelContext != null) {
            uri = camelContext.resolvePropertyPlaceholders(uri);
            return ResourceHelper.resolveMandatoryResourceAsInputStream((CamelContext)camelContext, (String)uri);
        }
        return Thread.currentThread().getContextClassLoader().getResourceAsStream(uri);
    }
}

