/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.infinispan.remote;

import org.apache.camel.component.infinispan.InfinispanConfiguration;
import org.apache.camel.component.infinispan.InfinispanConsumer;
import org.apache.camel.component.infinispan.InfinispanConsumerHandler;
import org.apache.camel.component.infinispan.InfinispanEventListener;
import org.apache.camel.component.infinispan.InfinispanUtil;
import org.apache.camel.component.infinispan.remote.InfinispanRemoteEventListener;
import org.infinispan.client.hotrod.RemoteCache;

public final class InfinispanConsumerRemoteHandler
implements InfinispanConsumerHandler {
    public static final InfinispanConsumerHandler INSTANCE = new InfinispanConsumerRemoteHandler();

    private InfinispanConsumerRemoteHandler() {
    }

    @Override
    public InfinispanEventListener start(InfinispanConsumer consumer) {
        InfinispanEventListener listener;
        if (consumer.getConfiguration().isSync()) {
            throw new UnsupportedOperationException("Sync listeners not supported for remote caches.");
        }
        RemoteCache<Object, Object> remoteCache = InfinispanUtil.asRemote(consumer.getCache());
        InfinispanConfiguration configuration = consumer.getConfiguration();
        if (configuration.hasCustomListener()) {
            listener = configuration.getCustomListener();
            listener.setInfinispanConsumer(consumer);
        } else {
            listener = new InfinispanRemoteEventListener(consumer, configuration.getEventTypes());
        }
        remoteCache.addClientListener(listener);
        listener.setCacheName(remoteCache.getName());
        return listener;
    }

    @Override
    public void stop(InfinispanConsumer consumer) {
        InfinispanUtil.asRemote(consumer.getCache()).removeClientListener(consumer.getListener());
    }
}

