/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.lang.invoke.MethodHandles;
import java.util.Set;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.cache.AbstractSecurityConfigurationChildBuilder;
import org.infinispan.configuration.cache.AuthorizationConfiguration;
import org.infinispan.configuration.cache.SecurityConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class AuthorizationConfigurationBuilder
extends AbstractSecurityConfigurationChildBuilder
implements Builder<AuthorizationConfiguration> {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass(), Log.class);
    private final AttributeSet attributes = AuthorizationConfiguration.attributeDefinitionSet();

    public AuthorizationConfigurationBuilder(SecurityConfigurationBuilder securityBuilder) {
        super(securityBuilder);
    }

    public AuthorizationConfigurationBuilder disable() {
        this.attributes.attribute(AuthorizationConfiguration.ENABLED).set(false);
        return this;
    }

    public AuthorizationConfigurationBuilder enable() {
        this.attributes.attribute(AuthorizationConfiguration.ENABLED).set(true);
        return this;
    }

    public AuthorizationConfigurationBuilder enabled(boolean enabled) {
        this.attributes.attribute(AuthorizationConfiguration.ENABLED).set(enabled);
        return this;
    }

    public AuthorizationConfigurationBuilder role(String name) {
        Set roles = this.attributes.attribute(AuthorizationConfiguration.ROLES).get();
        roles.add(name);
        this.attributes.attribute(AuthorizationConfiguration.ROLES).set(roles);
        return this;
    }

    @Override
    public void validate() {
    }

    @Override
    public void validate(GlobalConfiguration globalConfig) {
        if (this.attributes.attribute(AuthorizationConfiguration.ENABLED).get().booleanValue() && !globalConfig.security().authorization().enabled()) {
            throw log.globalSecurityAuthShouldBeEnabled();
        }
    }

    @Override
    public AuthorizationConfiguration create() {
        return new AuthorizationConfiguration(this.attributes.protect());
    }

    @Override
    public Builder<?> read(AuthorizationConfiguration template) {
        this.attributes.read(template.attributes());
        return this;
    }

    public String toString() {
        return "AuthorizationConfigurationBuilder [attributes=" + this.attributes + "]";
    }
}

