/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.filter;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.filter.KeyFilter;

public class CollectionKeyFilter<K>
implements KeyFilter<K> {
    private final Collection<? extends K> keys;
    private final boolean accept;

    public CollectionKeyFilter(Collection<? extends K> keys) {
        this(keys, false);
    }

    public CollectionKeyFilter(Collection<? extends K> keys, boolean accept) {
        this.keys = keys;
        this.accept = accept;
    }

    @Override
    public boolean accept(K key) {
        return this.accept ? this.keys.contains(key) : !this.keys.contains(key);
    }

    public static class Externalizer
    extends AbstractExternalizer<CollectionKeyFilter> {
        @Override
        public Set<Class<? extends CollectionKeyFilter>> getTypeClasses() {
            return Collections.singleton(CollectionKeyFilter.class);
        }

        @Override
        public void writeObject(ObjectOutput output, CollectionKeyFilter object) throws IOException {
            output.writeObject(object.keys);
            output.writeBoolean(object.accept);
        }

        @Override
        public CollectionKeyFilter readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new CollectionKeyFilter((Collection)input.readObject(), input.readBoolean());
        }

        @Override
        public Integer getId() {
            return 64;
        }
    }
}

