/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.locking;

import java.util.Collection;
import org.infinispan.InvalidCacheUsageException;
import org.infinispan.commands.DataCommand;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.write.DataWriteCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.interceptors.locking.AbstractTxLockingInterceptor;
import org.infinispan.transaction.impl.AbstractCacheTransaction;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class OptimisticLockingInterceptor
extends AbstractTxLockingInterceptor {
    private static final Log log = LogFactory.getLog(OptimisticLockingInterceptor.class);
    private static final boolean trace = log.isTraceEnabled();

    @Override
    protected Log getLog() {
        return log;
    }

    @Override
    public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        Collection<Object> keysToLock = command.getKeysToLock();
        ctx.addAllAffectedKeys(command.getAffectedKeys());
        if (!keysToLock.isEmpty()) {
            if (command.isRetriedCommand() && ctx.isOriginLocal()) {
                ((AbstractCacheTransaction)ctx.getCacheTransaction()).cleanupBackupLocks();
                keysToLock.removeAll(ctx.getLockedKeys());
            }
            this.lockAllOrRegisterBackupLock(ctx, keysToLock, this.cacheConfiguration.locking().lockAcquisitionTimeout());
        }
        if (!command.isOnePhaseCommit()) {
            return this.invokeNext(ctx, command);
        }
        return this.invokeNextAndFinally(ctx, command, (rCtx, rCommand, rv, t) -> this.releaseLockOnTxCompletion((TxInvocationContext)rCtx));
    }

    @Override
    protected Object visitDataReadCommand(InvocationContext ctx, DataCommand command) throws Throwable {
        return this.invokeNext(ctx, command);
    }

    @Override
    protected Object visitDataWriteCommand(InvocationContext ctx, DataWriteCommand command) throws Throwable {
        return this.invokeNextAndFinally(ctx, command, this.unlockAllReturnHandler);
    }

    @Override
    protected Object handleReadManyCommand(InvocationContext ctx, FlagAffectedCommand command, Collection<?> keys) {
        return this.invokeNext(ctx, command);
    }

    @Override
    protected <K> Object handleWriteManyCommand(InvocationContext ctx, FlagAffectedCommand command, Collection<K> keys, boolean forwarded) throws Throwable {
        return this.invokeNextAndFinally(ctx, command, this.unlockAllReturnHandler);
    }

    @Override
    public Object visitLockControlCommand(TxInvocationContext ctx, LockControlCommand command) throws Throwable {
        throw new InvalidCacheUsageException("Explicit locking is not allowed with optimistic caches!");
    }
}

