/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.inboundhandler.action;

import org.infinispan.remoting.inboundhandler.TrianglePerCacheInboundInvocationHandler;
import org.infinispan.remoting.inboundhandler.action.Action;
import org.infinispan.remoting.inboundhandler.action.ActionState;
import org.infinispan.remoting.inboundhandler.action.ActionStatus;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class TriangleOrderAction
implements Action {
    private static final Log log = LogFactory.getLog(TriangleOrderAction.class);
    private static final boolean trace = log.isTraceEnabled();
    private final Object key;
    private final long sequenceNumber;
    private final TrianglePerCacheInboundInvocationHandler handler;
    private volatile int segmentId = -1;

    public TriangleOrderAction(TrianglePerCacheInboundInvocationHandler handler, long sequenceNumber, Object key) {
        this.handler = handler;
        this.sequenceNumber = sequenceNumber;
        this.key = key;
    }

    @Override
    public ActionStatus check(ActionState state) {
        int localSegmentId = this.computeSegmentIdIfNeeded();
        if (trace) {
            log.tracef("Checking if next for segment %s and sequence %s", (long)localSegmentId, this.sequenceNumber);
        }
        return this.handler.getTriangleOrderManager().isNext(localSegmentId, this.sequenceNumber, state.getCommandTopologyId()) ? ActionStatus.READY : ActionStatus.NOT_READY;
    }

    @Override
    public void onFinally(ActionState state) {
        this.handler.getTriangleOrderManager().markDelivered(this.computeSegmentIdIfNeeded(), this.sequenceNumber, state.getCommandTopologyId());
        this.handler.getRemoteExecutor().checkForReadyTasks();
    }

    private int computeSegmentIdIfNeeded() {
        int tmp = this.segmentId;
        if (tmp == -1) {
            this.segmentId = tmp = this.handler.getClusteringDependentLogic().getCacheTopology().getSegment(this.key);
        }
        return tmp;
    }
}

