/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.transport.jgroups;

import java.util.Collections;
import java.util.Map;
import org.infinispan.remoting.responses.CacheNotFoundResponse;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.ValidResponse;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.ValidSingleResponseCollector;

class SingletonMapResponseCollector
extends ValidSingleResponseCollector<Map<Address, Response>> {
    private final boolean ignoreLeavers;

    SingletonMapResponseCollector(boolean ignoreLeavers) {
        this.ignoreLeavers = ignoreLeavers;
    }

    @Override
    protected Map<Address, Response> withValidResponse(Address sender, ValidResponse response) {
        return Collections.singletonMap(sender, response);
    }

    @Override
    protected Map<Address, Response> targetNotFound(Address sender) {
        if (!this.ignoreLeavers) {
            throw log.remoteNodeSuspected(sender);
        }
        return Collections.singletonMap(sender, CacheNotFoundResponse.INSTANCE);
    }
}

