/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction.xa;

import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.infinispan.transaction.impl.AbstractEnlistmentAdapter;
import org.infinispan.transaction.xa.LocalXaTransaction;
import org.infinispan.transaction.xa.XaTransactionTable;
import org.infinispan.transaction.xa.recovery.RecoveryManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class TransactionXaAdapter
extends AbstractEnlistmentAdapter
implements XAResource {
    private static final Log log = LogFactory.getLog(TransactionXaAdapter.class);
    private static boolean trace = log.isTraceEnabled();
    private int txTimeout;
    private final XaTransactionTable txTable;
    private final LocalXaTransaction localTransaction;
    private volatile RecoveryManager.RecoveryIterator recoveryIterator;

    public TransactionXaAdapter(LocalXaTransaction localTransaction, XaTransactionTable txTable) {
        super(localTransaction);
        this.txTable = txTable;
        this.localTransaction = localTransaction;
    }

    public TransactionXaAdapter(XaTransactionTable txTable) {
        this.txTable = txTable;
        this.localTransaction = null;
    }

    @Override
    public int prepare(Xid externalXid) throws XAException {
        return this.txTable.prepare(externalXid);
    }

    @Override
    public void commit(Xid externalXid, boolean isOnePhase) throws XAException {
        this.txTable.commit(externalXid, isOnePhase);
    }

    @Override
    public void rollback(Xid externalXid) throws XAException {
        this.txTable.rollback(externalXid);
    }

    @Override
    public void start(Xid externalXid, int i) throws XAException {
        this.txTable.start(externalXid, this.localTransaction);
    }

    @Override
    public void end(Xid externalXid, int i) throws XAException {
        this.txTable.end(this.localTransaction);
    }

    @Override
    public void forget(Xid externalXid) throws XAException {
        this.txTable.forget(externalXid);
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        if (trace) {
            log.trace("start called");
        }
        return this.txTimeout;
    }

    @Override
    public boolean isSameRM(XAResource xaResource) throws XAException {
        return this.isIsSameRM(xaResource);
    }

    private boolean isIsSameRM(XAResource xaResource) {
        if (!(xaResource instanceof TransactionXaAdapter)) {
            return false;
        }
        TransactionXaAdapter other = (TransactionXaAdapter)xaResource;
        return this.txTable == other.txTable;
    }

    @Override
    public Xid[] recover(int flag) throws XAException {
        if (!this.txTable.isRecoveryEnabled()) {
            log.recoveryIgnored();
            return RecoveryManager.RecoveryIterator.NOTHING;
        }
        if (trace) {
            log.trace("recover called: " + flag);
        }
        if (this.isFlag(flag, 0x1000000)) {
            this.recoveryIterator = this.txTable.recoveryManager.getPreparedTransactionsFromCluster();
            if (trace) {
                log.tracef("Fetched a new recovery iterator: %s", (Object)this.recoveryIterator);
            }
        }
        if (this.isFlag(flag, 0x800000)) {
            if (trace) {
                log.trace("Flushing the iterator");
            }
            return this.recoveryIterator.all();
        }
        if (!this.isFlag(flag, 0x1000000) && !this.isFlag(flag, 0)) {
            throw new IllegalArgumentException("TMNOFLAGS this flag must be used when no other flags are specified. Received " + flag);
        }
        return this.recoveryIterator.hasNext() ? (Xid[])this.recoveryIterator.next() : RecoveryManager.RecoveryIterator.NOTHING;
    }

    @Override
    public boolean setTransactionTimeout(int i) throws XAException {
        this.txTimeout = i;
        return true;
    }

    public String toString() {
        return "TransactionXaAdapter{localTransaction=" + this.localTransaction + '}';
    }

    public LocalXaTransaction getLocalTransaction() {
        return this.localTransaction;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionXaAdapter that = (TransactionXaAdapter)o;
        if (this.localTransaction != null ? !this.localTransaction.equals(that.localTransaction) : that.localTransaction != null) {
            return false;
        }
        return this.txTable == that.txTable;
    }

    private boolean isFlag(int value, int flag) {
        return (value & flag) != 0;
    }
}

