/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.pbcast;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.protocols.pbcast.GMS;
import org.jgroups.protocols.pbcast.GmsImpl;
import org.jgroups.protocols.pbcast.JoinRsp;
import org.jgroups.protocols.pbcast.ServerGmsImpl;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Digest;
import org.jgroups.util.MergeId;
import org.jgroups.util.MutableDigest;
import org.jgroups.util.Tuple;
import org.jgroups.util.Util;

public class CoordGmsImpl
extends ServerGmsImpl {
    protected static final Long MAX_SUSPEND_TIMEOUT = 30000L;

    public CoordGmsImpl(GMS g) {
        super(g);
    }

    public MergeId getMergeId() {
        return this.merger.getMergeId();
    }

    @Override
    public void init() throws Exception {
        super.init();
        this.merger.cancelMerge(null);
    }

    @Override
    public void join(Address mbr, boolean useFlushIfPresent) {
        this.wrongMethod("join");
    }

    @Override
    public void joinWithStateTransfer(Address mbr, boolean useFlushIfPresent) {
        this.wrongMethod("join");
    }

    @Override
    public void leave(Address mbr) {
        if (mbr == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error(Util.getMessage("MemberSAddressIsNull"));
            }
            return;
        }
        if (mbr.equals(this.gms.local_addr)) {
            this.leaving = true;
        }
        this.gms.getViewHandler().add(new GmsImpl.Request(2, mbr, false));
    }

    @Override
    public void suspect(Address mbr) {
        if (mbr.equals(this.gms.local_addr)) {
            if (this.log.isWarnEnabled()) {
                this.log.warn("I am the coord and I'm suspected -- will probably leave shortly");
            }
            return;
        }
        LinkedHashSet<GmsImpl.Request> suspected = new LinkedHashSet<GmsImpl.Request>(1);
        suspected.add(new GmsImpl.Request(3, mbr, true));
        this.handleMembershipChange(suspected);
    }

    void fixDigests() {
        this.merger.fixDigests();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleMembershipChange(Collection<GmsImpl.Request> requests) {
        boolean joinAndStateTransferInitiated = false;
        boolean useFlushIfPresent = this.gms.use_flush_if_present;
        LinkedHashSet<Address> new_mbrs = new LinkedHashSet<Address>(requests.size());
        LinkedHashSet<Address> suspected_mbrs = new LinkedHashSet<Address>(requests.size());
        LinkedHashSet<Address> leaving_mbrs = new LinkedHashSet<Address>(requests.size());
        boolean self_leaving = false;
        for (GmsImpl.Request req : requests) {
            switch (req.type) {
                case 1: {
                    new_mbrs.add(req.mbr);
                    if (!req.useFlushIfPresent) break;
                    useFlushIfPresent = true;
                    break;
                }
                case 6: {
                    new_mbrs.add(req.mbr);
                    joinAndStateTransferInitiated = true;
                    if (!req.useFlushIfPresent) break;
                    useFlushIfPresent = true;
                    break;
                }
                case 2: {
                    if (req.suspected) {
                        suspected_mbrs.add(req.mbr);
                        break;
                    }
                    leaving_mbrs.add(req.mbr);
                    if (!Objects.equals(this.gms.local_addr, req.mbr)) break;
                    self_leaving = true;
                    break;
                }
                case 3: {
                    suspected_mbrs.add(req.mbr);
                }
            }
        }
        new_mbrs.remove(this.gms.local_addr);
        if (this.gms.getViewId() == null) {
            this.log.debug("gms.view_id is null, I'm not the coordinator anymore (leaving=%b); the new coordinator will handle the leave request", self_leaving);
            return;
        }
        List<Address> current_members = this.gms.members.getMembers();
        leaving_mbrs.retainAll(current_members);
        if (suspected_mbrs.remove(this.gms.local_addr)) {
            this.log.warn("I am the coord and I'm being suspected -- will probably leave shortly");
        }
        suspected_mbrs.retainAll(current_members);
        Iterator it = new_mbrs.iterator();
        while (it.hasNext()) {
            Address mbr = (Address)it.next();
            if (!this.gms.members.contains(mbr)) continue;
            this.log.trace("%s: %s already present; returning existing view %s", this.gms.local_addr, mbr, this.gms.view);
            Tuple<View, Digest> tuple = this.gms.getViewAndDigest();
            if (tuple != null) {
                this.gms.sendJoinResponse(new JoinRsp(tuple.getVal1(), tuple.getVal2()), mbr);
            } else {
                this.log.warn("%s: did not find a digest matching view %s; dropping JOIN-RSP", this.gms.local_addr, this.gms.view);
            }
            it.remove();
        }
        if (new_mbrs.isEmpty() && leaving_mbrs.isEmpty() && suspected_mbrs.isEmpty()) {
            this.log.trace("%s: found no members to add or remove, will not create new view", this.gms.local_addr);
            return;
        }
        View new_view = this.gms.getNextView(new_mbrs, leaving_mbrs, suspected_mbrs);
        if (new_view.size() == 0 && this.gms.local_addr != null && this.gms.local_addr.equals(new_view.getCreator())) {
            if (self_leaving) {
                this.gms.initState();
            }
            return;
        }
        this.log.trace("%s: joiners=%s, suspected=%s, leaving=%s, new view: %s", this.gms.local_addr, new_mbrs, suspected_mbrs, leaving_mbrs, new_view);
        JoinRsp join_rsp = null;
        boolean hasJoiningMembers = !new_mbrs.isEmpty();
        try {
            boolean successfulFlush;
            boolean bl = successfulFlush = !useFlushIfPresent || !this.gms.flushProtocolInStack || this.gms.startFlush(new_view);
            if (!successfulFlush && hasJoiningMembers) {
                this.sendLeaveResponses(leaving_mbrs);
                return;
            }
            if (hasJoiningMembers) {
                ((Protocol)this.gms.getDownProtocol()).down(new Event(65, MAX_SUSPEND_TIMEOUT));
                MutableDigest join_digest = new MutableDigest(new_view.getMembersRaw()).set(this.gms.getDigest());
                for (Address member : new_mbrs) {
                    join_digest.set(member, 0L, 0L);
                }
                if (join_digest.allSet() || join_digest.set(this.gms.getDigest()).allSet()) {
                    join_rsp = new JoinRsp(new_view, join_digest);
                } else {
                    this.log.warn("%s: digest does not match view (missing seqnos for %s); dropping JOIN-RSP", this.gms.local_addr, Arrays.toString(join_digest.getNonSetMembers()));
                }
            }
            this.sendLeaveResponses(leaving_mbrs);
            this.gms.castViewChangeAndSendJoinRsps(new_view, null, new_view.getMembers(), new_mbrs, join_rsp);
        }
        finally {
            if (hasJoiningMembers) {
                ((Protocol)this.gms.getDownProtocol()).down(new Event(66));
            }
            if (!joinAndStateTransferInitiated && useFlushIfPresent) {
                this.gms.stopFlush();
            }
            if (self_leaving) {
                this.gms.initState();
            }
        }
    }

    @Override
    public void handleViewChange(View new_view, Digest digest) {
        if (this.leaving && !new_view.containsMember(this.gms.local_addr)) {
            return;
        }
        this.gms.installView(new_view, digest);
    }

    @Override
    public void stop() {
        super.stop();
        this.merger.stop();
    }

    private void sendLeaveResponses(Collection<Address> leaving_members) {
        for (Address address : leaving_members) {
            Message msg = new Message(address).setFlag(Message.Flag.OOB, Message.Flag.INTERNAL, Message.Flag.NO_RELIABILITY).putHeader(this.gms.getId(), new GMS.GmsHeader(4));
            this.log.trace("%s: sending LEAVE response to %s", this.gms.local_addr, address);
            ((Protocol)this.gms.getDownProtocol()).down(msg);
        }
    }
}

