/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.pbcast;

import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import org.jgroups.logging.Log;
import org.jgroups.protocols.pbcast.GMS;
import org.jgroups.util.BoundedList;
import org.jgroups.util.Util;

public class ViewHandler<R> {
    protected final Collection<R> requests = new LinkedHashSet<R>();
    protected R first_req;
    protected final Lock lock = new ReentrantLock();
    protected final AtomicInteger count = new AtomicInteger();
    protected volatile boolean suspended;
    protected final GMS gms;
    protected final Consumer<Collection<R>> req_processor;
    protected final BiPredicate<R, R> req_matcher;
    protected final BoundedList<String> history = new BoundedList(20);
    protected final R END_MARKER = new Object(){

        public String toString() {
            return "[end]";
        }
    };
    protected static final long THREAD_WAIT_TIME = 5000L;

    public ViewHandler(GMS gms, Consumer<Collection<R>> req_processor, BiPredicate<R, R> req_matcher) {
        if (req_processor == null) {
            throw new IllegalArgumentException("request processor cannot be null");
        }
        this.gms = gms;
        this.req_processor = req_processor;
        this.req_matcher = req_matcher != null ? req_matcher : (a, b) -> true;
    }

    public boolean suspended() {
        return this.suspended;
    }

    public int size() {
        return this.requests.size();
    }

    public void add(R req) {
        if (this.suspended) {
            this.log().trace("%s: queue is suspended; request %s is discarded", this.gms.getLocalAddress(), req);
            return;
        }
        this.count.incrementAndGet();
        this.history.add(new Date() + ": " + req.toString());
        this.lock.lock();
        try {
            if (this.first_req == null) {
                this.first_req = req;
                this.requests.add(req);
            } else if (this.req_matcher.test(this.first_req, req)) {
                this.requests.add(req);
            } else {
                this.process(this.requests);
            }
            if (this.count.decrementAndGet() == 0) {
                this.process(this.requests);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(R ... reqs) {
        if (this.suspended) {
            this.log().trace("%s: queue is suspended; requests are discarded", this.gms.getLocalAddress());
            return;
        }
        this.count.incrementAndGet();
        this.lock.lock();
        try {
            for (R req : reqs) {
                this.history.add(new Date() + ": " + req.toString());
                if (this.first_req == null) {
                    this.first_req = req;
                    this.requests.add(req);
                    continue;
                }
                if (this.req_matcher.test(this.first_req, req)) {
                    this.requests.add(req);
                    continue;
                }
                this.process(this.requests);
                this.first_req = req;
                this.requests.add(req);
            }
            if (this.count.decrementAndGet() == 0) {
                this.process(this.requests);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void suspend() {
        this.lock.lock();
        try {
            if (!this.suspended) {
                this.suspended = true;
                this.requests.clear();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void resume() {
        this.lock.lock();
        try {
            if (this.suspended) {
                this.suspended = false;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public String dumpQueue() {
        return this.requests.stream().collect(StringBuilder::new, (sb, el) -> sb.append(el).append("\n"), StringBuilder::append).toString();
    }

    public String dumpHistory() {
        return this.history.stream().collect(StringBuilder::new, (sb, el) -> sb.append(el + "\n"), StringBuilder::append).toString();
    }

    public String toString() {
        return Util.printListWithDelimiter(this.requests, ", ");
    }

    protected Log log() {
        return this.gms.getLog();
    }

    protected void process(Collection<R> requests) {
        try {
            this.req_processor.accept(requests);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        requests.clear();
        this.first_req = null;
    }

    protected static void join(Thread t) {
        try {
            t.join(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

