/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.CompletableObserver;
import io.reactivex.CompletableSource;
import io.reactivex.Flowable;
import io.reactivex.FlowableSubscriber;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.AtomicThrowable;
import io.reactivex.internal.util.HalfSerializer;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableMergeWithCompletable<T>
extends AbstractFlowableWithUpstream<T, T> {
    final CompletableSource other;

    public FlowableMergeWithCompletable(Flowable<T> source, CompletableSource other) {
        super(source);
        this.other = other;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> observer) {
        MergeWithSubscriber<? super T> parent = new MergeWithSubscriber<T>(observer);
        observer.onSubscribe(parent);
        this.source.subscribe(parent);
        this.other.subscribe(parent.otherObserver);
    }

    static final class MergeWithSubscriber<T>
    extends AtomicInteger
    implements FlowableSubscriber<T>,
    Subscription {
        private static final long serialVersionUID = -4592979584110982903L;
        final Subscriber<? super T> actual;
        final AtomicReference<Subscription> mainSubscription;
        final OtherObserver otherObserver;
        final AtomicThrowable error;
        final AtomicLong requested;
        volatile boolean mainDone;
        volatile boolean otherDone;

        MergeWithSubscriber(Subscriber<? super T> actual) {
            this.actual = actual;
            this.mainSubscription = new AtomicReference();
            this.otherObserver = new OtherObserver(this);
            this.error = new AtomicThrowable();
            this.requested = new AtomicLong();
        }

        @Override
        public void onSubscribe(Subscription d) {
            SubscriptionHelper.deferredSetOnce(this.mainSubscription, this.requested, d);
        }

        @Override
        public void onNext(T t) {
            HalfSerializer.onNext(this.actual, t, (AtomicInteger)this, this.error);
        }

        @Override
        public void onError(Throwable ex) {
            SubscriptionHelper.cancel(this.mainSubscription);
            HalfSerializer.onError(this.actual, ex, (AtomicInteger)this, this.error);
        }

        @Override
        public void onComplete() {
            this.mainDone = true;
            if (this.otherDone) {
                HalfSerializer.onComplete(this.actual, (AtomicInteger)this, this.error);
            }
        }

        @Override
        public void request(long n) {
            SubscriptionHelper.deferredRequest(this.mainSubscription, this.requested, n);
        }

        @Override
        public void cancel() {
            SubscriptionHelper.cancel(this.mainSubscription);
            DisposableHelper.dispose(this.otherObserver);
        }

        void otherError(Throwable ex) {
            SubscriptionHelper.cancel(this.mainSubscription);
            HalfSerializer.onError(this.actual, ex, (AtomicInteger)this, this.error);
        }

        void otherComplete() {
            this.otherDone = true;
            if (this.mainDone) {
                HalfSerializer.onComplete(this.actual, (AtomicInteger)this, this.error);
            }
        }

        static final class OtherObserver
        extends AtomicReference<Disposable>
        implements CompletableObserver {
            private static final long serialVersionUID = -2935427570954647017L;
            final MergeWithSubscriber<?> parent;

            OtherObserver(MergeWithSubscriber<?> parent) {
                this.parent = parent;
            }

            @Override
            public void onSubscribe(Disposable d) {
                DisposableHelper.setOnce(this, d);
            }

            @Override
            public void onError(Throwable e) {
                this.parent.otherError(e);
            }

            @Override
            public void onComplete() {
                this.parent.otherComplete();
            }
        }
    }
}

