/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.Flowable;
import io.reactivex.FlowableSubscriber;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.exceptions.MissingBackpressureException;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.internal.queue.MpscLinkedQueue;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.AtomicThrowable;
import io.reactivex.internal.util.BackpressureHelper;
import io.reactivex.plugins.RxJavaPlugins;
import io.reactivex.processors.UnicastProcessor;
import io.reactivex.subscribers.DisposableSubscriber;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableWindowBoundarySupplier<T, B>
extends AbstractFlowableWithUpstream<T, Flowable<T>> {
    final Callable<? extends Publisher<B>> other;
    final int capacityHint;

    public FlowableWindowBoundarySupplier(Flowable<T> source, Callable<? extends Publisher<B>> other, int capacityHint) {
        super(source);
        this.other = other;
        this.capacityHint = capacityHint;
    }

    @Override
    protected void subscribeActual(Subscriber<? super Flowable<T>> subscriber) {
        WindowBoundaryMainSubscriber parent = new WindowBoundaryMainSubscriber(subscriber, this.capacityHint, this.other);
        this.source.subscribe(parent);
    }

    static final class WindowBoundaryInnerSubscriber<T, B>
    extends DisposableSubscriber<B> {
        final WindowBoundaryMainSubscriber<T, B> parent;
        boolean done;

        WindowBoundaryInnerSubscriber(WindowBoundaryMainSubscriber<T, B> parent) {
            this.parent = parent;
        }

        @Override
        public void onNext(B t) {
            if (this.done) {
                return;
            }
            this.done = true;
            this.dispose();
            this.parent.innerNext(this);
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError(t);
                return;
            }
            this.done = true;
            this.parent.innerError(t);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.parent.innerComplete();
        }
    }

    static final class WindowBoundaryMainSubscriber<T, B>
    extends AtomicInteger
    implements FlowableSubscriber<T>,
    Subscription,
    Runnable {
        private static final long serialVersionUID = 2233020065421370272L;
        final Subscriber<? super Flowable<T>> downstream;
        final int capacityHint;
        final AtomicReference<WindowBoundaryInnerSubscriber<T, B>> boundarySubscriber;
        static final WindowBoundaryInnerSubscriber<Object, Object> BOUNDARY_DISPOSED = new WindowBoundaryInnerSubscriber(null);
        final AtomicInteger windows;
        final MpscLinkedQueue<Object> queue;
        final AtomicThrowable errors;
        final AtomicBoolean stopWindows;
        final Callable<? extends Publisher<B>> other;
        static final Object NEXT_WINDOW = new Object();
        final AtomicLong requested;
        Subscription upstream;
        volatile boolean done;
        UnicastProcessor<T> window;
        long emitted;

        WindowBoundaryMainSubscriber(Subscriber<? super Flowable<T>> downstream, int capacityHint, Callable<? extends Publisher<B>> other) {
            this.downstream = downstream;
            this.capacityHint = capacityHint;
            this.boundarySubscriber = new AtomicReference();
            this.windows = new AtomicInteger(1);
            this.queue = new MpscLinkedQueue();
            this.errors = new AtomicThrowable();
            this.stopWindows = new AtomicBoolean();
            this.other = other;
            this.requested = new AtomicLong();
        }

        @Override
        public void onSubscribe(Subscription d) {
            if (SubscriptionHelper.validate(this.upstream, d)) {
                this.upstream = d;
                this.downstream.onSubscribe(this);
                this.queue.offer(NEXT_WINDOW);
                this.drain();
                d.request(Long.MAX_VALUE);
            }
        }

        @Override
        public void onNext(T t) {
            this.queue.offer(t);
            this.drain();
        }

        @Override
        public void onError(Throwable e) {
            this.disposeBoundary();
            if (this.errors.addThrowable(e)) {
                this.done = true;
                this.drain();
            } else {
                RxJavaPlugins.onError(e);
            }
        }

        @Override
        public void onComplete() {
            this.disposeBoundary();
            this.done = true;
            this.drain();
        }

        @Override
        public void cancel() {
            if (this.stopWindows.compareAndSet(false, true)) {
                this.disposeBoundary();
                if (this.windows.decrementAndGet() == 0) {
                    this.upstream.cancel();
                }
            }
        }

        @Override
        public void request(long n) {
            BackpressureHelper.add(this.requested, n);
        }

        void disposeBoundary() {
            Disposable d = this.boundarySubscriber.getAndSet(BOUNDARY_DISPOSED);
            if (d != null && d != BOUNDARY_DISPOSED) {
                d.dispose();
            }
        }

        @Override
        public void run() {
            if (this.windows.decrementAndGet() == 0) {
                this.upstream.cancel();
            }
        }

        void innerNext(WindowBoundaryInnerSubscriber<T, B> sender) {
            this.boundarySubscriber.compareAndSet(sender, null);
            this.queue.offer(NEXT_WINDOW);
            this.drain();
        }

        void innerError(Throwable e) {
            this.upstream.cancel();
            if (this.errors.addThrowable(e)) {
                this.done = true;
                this.drain();
            } else {
                RxJavaPlugins.onError(e);
            }
        }

        void innerComplete() {
            this.upstream.cancel();
            this.done = true;
            this.drain();
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            Subscriber<Flowable<UnicastProcessor<T>>> downstream = this.downstream;
            MpscLinkedQueue<Object> queue = this.queue;
            AtomicThrowable errors = this.errors;
            long emitted = this.emitted;
            while (true) {
                boolean empty;
                if (this.windows.get() == 0) {
                    queue.clear();
                    this.window = null;
                    return;
                }
                UnicastProcessor<Object> w = this.window;
                boolean d = this.done;
                if (d && errors.get() != null) {
                    queue.clear();
                    Throwable ex = errors.terminate();
                    if (w != null) {
                        this.window = null;
                        w.onError(ex);
                    }
                    downstream.onError(ex);
                    return;
                }
                Object v = queue.poll();
                boolean bl = empty = v == null;
                if (d && empty) {
                    Throwable ex = errors.terminate();
                    if (ex == null) {
                        if (w != null) {
                            this.window = null;
                            w.onComplete();
                        }
                        downstream.onComplete();
                    } else {
                        if (w != null) {
                            this.window = null;
                            w.onError(ex);
                        }
                        downstream.onError(ex);
                    }
                    return;
                }
                if (!empty) {
                    if (v != NEXT_WINDOW) {
                        w.onNext(v);
                        continue;
                    }
                    if (w != null) {
                        this.window = null;
                        w.onComplete();
                    }
                    if (this.stopWindows.get()) continue;
                    if (emitted != this.requested.get()) {
                        Publisher<B> otherSource;
                        w = UnicastProcessor.create(this.capacityHint, this);
                        this.window = w;
                        this.windows.getAndIncrement();
                        try {
                            otherSource = ObjectHelper.requireNonNull(this.other.call(), "The other Callable returned a null Publisher");
                        }
                        catch (Throwable ex) {
                            Exceptions.throwIfFatal(ex);
                            errors.addThrowable(ex);
                            this.done = true;
                            continue;
                        }
                        WindowBoundaryInnerSubscriber bo = new WindowBoundaryInnerSubscriber(this);
                        if (!this.boundarySubscriber.compareAndSet(null, bo)) continue;
                        otherSource.subscribe(bo);
                        ++emitted;
                        downstream.onNext(w);
                        continue;
                    }
                    this.upstream.cancel();
                    this.disposeBoundary();
                    errors.addThrowable(new MissingBackpressureException("Could not deliver a window due to lack of requests"));
                    this.done = true;
                    continue;
                }
                this.emitted = emitted;
                if ((missed = this.addAndGet(-missed)) == 0) break;
            }
        }
    }
}

