/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cache.impl;

import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.CacheCollection;
import org.infinispan.CacheSet;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.format.PropertyFormatter;
import org.infinispan.filter.KeyFilter;
import org.infinispan.jmx.annotations.DataType;
import org.infinispan.jmx.annotations.DisplayType;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.cachelistener.filter.CacheEventConverter;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilter;

public abstract class AbstractDelegatingCache<K, V>
implements Cache<K, V> {
    private final Cache<K, V> cache;

    public AbstractDelegatingCache(Cache<K, V> cache) {
        this.cache = cache;
        if (cache == null) {
            throw new IllegalArgumentException("Delegate cache cannot be null!");
        }
    }

    @Override
    public void putForExternalRead(K key, V value) {
        this.cache.putForExternalRead(key, value);
    }

    @Override
    public void putForExternalRead(K key, V value, long lifespan, TimeUnit unit) {
        this.cache.putForExternalRead(key, value, lifespan, unit);
    }

    @Override
    public void putForExternalRead(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        this.cache.putForExternalRead(key, value, lifespan, lifespanUnit, maxIdle, maxIdleUnit);
    }

    @Override
    public void evict(K key) {
        this.cache.evict(key);
    }

    @Override
    public Configuration getCacheConfiguration() {
        return this.cache.getCacheConfiguration();
    }

    @Override
    public boolean startBatch() {
        return this.cache.startBatch();
    }

    @Override
    public void endBatch(boolean successful) {
        this.cache.endBatch(successful);
    }

    @Override
    public String getName() {
        return this.cache.getName();
    }

    @ManagedAttribute(description="Returns the cache name", displayName="Cache name", dataType=DataType.TRAIT, displayType=DisplayType.SUMMARY)
    public String getCacheName() {
        String name = this.getName().equals("___defaultcache") ? "Default Cache" : this.getName();
        return name + "(" + this.getCacheConfiguration().clustering().cacheMode().toString().toLowerCase() + ")";
    }

    @Override
    @ManagedAttribute(description="Returns the version of Infinispan", displayName="Infinispan version", dataType=DataType.TRAIT, displayType=DisplayType.SUMMARY)
    public String getVersion() {
        return this.cache.getVersion();
    }

    @Override
    public EmbeddedCacheManager getCacheManager() {
        return this.cache.getCacheManager();
    }

    @Override
    public V put(K key, V value, long lifespan, TimeUnit unit) {
        return this.cache.put(key, value, lifespan, unit);
    }

    protected void set(K key, V value) {
        this.cache.put(key, value);
    }

    @Override
    public V putIfAbsent(K key, V value, long lifespan, TimeUnit unit) {
        return this.cache.putIfAbsent(key, value, lifespan, unit);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map, long lifespan, TimeUnit unit) {
        this.cache.putAll(map, lifespan, unit);
    }

    @Override
    public V replace(K key, V value, long lifespan, TimeUnit unit) {
        return this.cache.replace(key, value, lifespan, unit);
    }

    @Override
    public boolean replace(K key, V oldValue, V value, long lifespan, TimeUnit unit) {
        return this.cache.replace(key, oldValue, value, lifespan, unit);
    }

    @Override
    public V put(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        return this.cache.put(key, value, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
    }

    @Override
    public V putIfAbsent(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        return this.cache.putIfAbsent(key, value, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        this.cache.putAll(map, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
    }

    @Override
    public V replace(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        return this.cache.replace(key, value, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
    }

    @Override
    public boolean replace(K key, V oldValue, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        return this.cache.replace(key, oldValue, value, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        this.cache.replaceAll(function);
    }

    @Override
    public CompletableFuture<V> putAsync(K key, V value) {
        return this.cache.putAsync(key, value);
    }

    @Override
    public CompletableFuture<V> putAsync(K key, V value, long lifespan, TimeUnit unit) {
        return this.cache.putAsync(key, value, lifespan, unit);
    }

    @Override
    public CompletableFuture<V> putAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return this.cache.putAsync(key, value, lifespan, lifespanUnit, maxIdle, maxIdleUnit);
    }

    @Override
    public CompletableFuture<Void> putAllAsync(Map<? extends K, ? extends V> data) {
        return this.cache.putAllAsync(data);
    }

    @Override
    public CompletableFuture<Void> putAllAsync(Map<? extends K, ? extends V> data, long lifespan, TimeUnit unit) {
        return this.cache.putAllAsync(data, lifespan, unit);
    }

    @Override
    public CompletableFuture<Void> putAllAsync(Map<? extends K, ? extends V> data, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return this.cache.putAllAsync(data, lifespan, lifespanUnit, maxIdle, maxIdleUnit);
    }

    @Override
    public CompletableFuture<Void> clearAsync() {
        return this.cache.clearAsync();
    }

    @Override
    public CompletableFuture<V> putIfAbsentAsync(K key, V value) {
        return this.cache.putIfAbsentAsync(key, value);
    }

    @Override
    public CompletableFuture<V> putIfAbsentAsync(K key, V value, long lifespan, TimeUnit unit) {
        return this.cache.putIfAbsentAsync(key, value, lifespan, unit);
    }

    @Override
    public CompletableFuture<V> putIfAbsentAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return this.cache.putIfAbsentAsync(key, value, lifespan, lifespanUnit, maxIdle, maxIdleUnit);
    }

    @Override
    public CompletableFuture<V> removeAsync(Object key) {
        return this.cache.removeAsync(key);
    }

    @Override
    public CompletableFuture<Boolean> removeAsync(Object key, Object value) {
        return this.cache.removeAsync(key, value);
    }

    @Override
    public CompletableFuture<V> replaceAsync(K key, V value) {
        return this.cache.replaceAsync(key, value);
    }

    @Override
    public CompletableFuture<V> replaceAsync(K key, V value, long lifespan, TimeUnit unit) {
        return this.cache.replaceAsync(key, value, lifespan, unit);
    }

    @Override
    public CompletableFuture<V> replaceAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return this.cache.replaceAsync(key, value, lifespan, lifespanUnit, maxIdle, maxIdleUnit);
    }

    @Override
    public CompletableFuture<Boolean> replaceAsync(K key, V oldValue, V newValue) {
        return this.cache.replaceAsync(key, oldValue, newValue);
    }

    @Override
    public CompletableFuture<Boolean> replaceAsync(K key, V oldValue, V newValue, long lifespan, TimeUnit unit) {
        return this.cache.replaceAsync(key, oldValue, newValue, lifespan, unit);
    }

    @Override
    public CompletableFuture<Boolean> replaceAsync(K key, V oldValue, V newValue, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return this.cache.replaceAsync(key, oldValue, newValue, lifespan, lifespanUnit, maxIdle, maxIdleUnit);
    }

    @Override
    public CompletableFuture<V> computeAsync(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return this.cache.computeAsync((K)key, (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction);
    }

    @Override
    public CompletableFuture<V> computeAsync(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit) {
        return this.cache.computeAsync((K)key, (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction, lifespan, lifespanUnit);
    }

    @Override
    public CompletableFuture<V> computeAsync(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return this.cache.computeAsync((K)key, (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction, lifespan, lifespanUnit, maxIdle, maxIdleUnit);
    }

    @Override
    public CompletableFuture<V> computeIfAbsentAsync(K key, Function<? super K, ? extends V> mappingFunction) {
        return this.cache.computeIfAbsentAsync((K)key, mappingFunction);
    }

    @Override
    public CompletableFuture<V> computeIfAbsentAsync(K key, Function<? super K, ? extends V> mappingFunction, long lifespan, TimeUnit lifespanUnit) {
        return this.cache.computeIfAbsentAsync((K)key, mappingFunction, lifespan, lifespanUnit);
    }

    @Override
    public CompletableFuture<V> computeIfAbsentAsync(K key, Function<? super K, ? extends V> mappingFunction, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return this.cache.computeIfAbsentAsync((K)key, mappingFunction, lifespan, lifespanUnit, maxIdle, maxIdleUnit);
    }

    @Override
    public CompletableFuture<V> computeIfPresentAsync(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return this.cache.computeIfPresentAsync((K)key, (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction);
    }

    @Override
    public CompletableFuture<V> computeIfPresentAsync(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit) {
        return this.cache.computeIfPresentAsync((K)key, (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction, lifespan, lifespanUnit);
    }

    @Override
    public CompletableFuture<V> computeIfPresentAsync(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return this.cache.computeIfPresentAsync((K)key, (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction, lifespan, lifespanUnit, maxIdle, maxIdleUnit);
    }

    @Override
    public CompletableFuture<V> mergeAsync(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        return this.cache.mergeAsync(key, (V)value, (BiFunction<? extends V, ? extends V, ? extends V>)remappingFunction);
    }

    @Override
    public CompletableFuture<V> mergeAsync(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit) {
        return this.cache.mergeAsync(key, (V)value, (BiFunction<? extends V, ? extends V, ? extends V>)remappingFunction, lifespan, lifespanUnit);
    }

    @Override
    public CompletableFuture<V> mergeAsync(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return this.cache.mergeAsync(key, (V)value, (BiFunction<? extends V, ? extends V, ? extends V>)remappingFunction, lifespan, lifespanUnit, maxIdle, maxIdleUnit);
    }

    @Override
    public AdvancedCache<K, V> getAdvancedCache() {
        return this.cache.getAdvancedCache();
    }

    @Override
    public ComponentStatus getStatus() {
        return this.cache.getStatus();
    }

    @ManagedAttribute(description="Returns the cache status", displayName="Cache status", dataType=DataType.TRAIT, displayType=DisplayType.SUMMARY)
    public String getCacheStatus() {
        return this.getStatus().toString();
    }

    @Override
    public V putIfAbsent(K key, V value) {
        return this.cache.putIfAbsent(key, value);
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.cache.remove(key, value);
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        return this.cache.replace(key, oldValue, newValue);
    }

    @Override
    public V replace(K key, V value) {
        return this.cache.replace(key, value);
    }

    @Override
    public int size() {
        return this.cache.size();
    }

    @Override
    public boolean isEmpty() {
        return this.cache.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.cache.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.cache.containsValue(value);
    }

    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return this.cache.compute((K)key, (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction);
    }

    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit) {
        return this.cache.compute((K)key, (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction, lifespan, lifespanUnit);
    }

    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        return this.cache.compute((K)key, (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
    }

    @Override
    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return this.cache.computeIfPresent((K)key, (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction);
    }

    @Override
    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit) {
        return this.cache.computeIfPresent((K)key, (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction, lifespan, lifespanUnit);
    }

    @Override
    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        return this.cache.computeIfPresent((K)key, (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        return this.cache.computeIfAbsent((K)key, mappingFunction);
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction, long lifespan, TimeUnit lifespanUnit) {
        return this.computeIfAbsent(key, mappingFunction, lifespan, lifespanUnit);
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        return this.computeIfAbsent(key, mappingFunction, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
    }

    @Override
    public V get(Object key) {
        return this.cache.get(key);
    }

    @Override
    public V getOrDefault(Object key, V defaultValue) {
        return this.cache.getOrDefault(key, defaultValue);
    }

    @Override
    public V put(K key, V value) {
        return this.cache.put(key, value);
    }

    @Override
    public V remove(Object key) {
        return this.cache.remove(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> t) {
        this.cache.putAll(t);
    }

    @Override
    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        return this.cache.merge(key, (V)value, (BiFunction<? extends V, ? extends V, ? extends V>)remappingFunction);
    }

    @Override
    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit) {
        return this.cache.merge(key, (V)value, (BiFunction<? extends V, ? extends V, ? extends V>)remappingFunction, lifespan, lifespanUnit);
    }

    @Override
    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        return this.cache.merge(key, (V)value, (BiFunction<? extends V, ? extends V, ? extends V>)remappingFunction, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        this.cache.forEach(action);
    }

    @Override
    @ManagedOperation(description="Clears the cache", displayName="Clears the cache", name="clear")
    public void clear() {
        this.cache.clear();
    }

    @Override
    public CacheSet<K> keySet() {
        return this.cache.keySet();
    }

    @Override
    public CacheSet<Map.Entry<K, V>> entrySet() {
        return this.cache.entrySet();
    }

    @Override
    public CacheCollection<V> values() {
        return this.cache.values();
    }

    @Override
    @ManagedOperation(description="Starts the cache.", displayName="Starts cache.")
    public void start() {
        this.cache.start();
    }

    @Override
    @ManagedOperation(description="Stops the cache.", displayName="Stops cache.")
    public void stop() {
        this.cache.stop();
    }

    @Override
    @ManagedOperation(description="Shuts down the cache across the cluster", displayName="Clustered cache shutdown")
    public void shutdown() {
        this.cache.shutdown();
    }

    @Override
    public void addListener(Object listener) {
        this.cache.addListener(listener);
    }

    @Override
    public void addListener(Object listener, KeyFilter<? super K> filter) {
        this.cache.addListener(listener, filter);
    }

    @Override
    public <C> void addListener(Object listener, CacheEventFilter<? super K, ? super V> filter, CacheEventConverter<? super K, ? super V, C> converter) {
        this.cache.addListener(listener, filter, converter);
    }

    @Override
    public void removeListener(Object listener) {
        this.cache.removeListener(listener);
    }

    @Override
    public Set<Object> getListeners() {
        return this.cache.getListeners();
    }

    @Override
    public <C> void addFilteredListener(Object listener, CacheEventFilter<? super K, ? super V> filter, CacheEventConverter<? super K, ? super V, C> converter, Set<Class<? extends Annotation>> filterAnnotations) {
        this.cache.addFilteredListener(listener, filter, converter, filterAnnotations);
    }

    @Override
    public <C> void addStorageFormatFilteredListener(Object listener, CacheEventFilter<? super K, ? super V> filter, CacheEventConverter<? super K, ? super V, C> converter, Set<Class<? extends Annotation>> filterAnnotations) {
        this.cache.addStorageFormatFilteredListener(listener, filter, converter, filterAnnotations);
    }

    @Override
    public CompletableFuture<V> getAsync(K key) {
        return this.cache.getAsync(key);
    }

    @Override
    public CompletableFuture<Map<K, V>> getAllAsync(Set<?> keys) {
        return this.cache.getAllAsync(keys);
    }

    @ManagedAttribute(description="Returns the cache configuration in form of properties", displayName="Cache configuration properties", dataType=DataType.TRAIT, displayType=DisplayType.SUMMARY)
    public Properties getConfigurationAsProperties() {
        return new PropertyFormatter().format(this.getCacheConfiguration());
    }

    public String toString() {
        return this.cache.toString();
    }

    public Cache<K, V> getDelegate() {
        return this.cache;
    }

    public static <K, V> Cache<K, V> unwrapCache(Cache<K, V> cache) {
        if (cache instanceof AbstractDelegatingCache) {
            return AbstractDelegatingCache.unwrapCache(((AbstractDelegatingCache)cache).getDelegate());
        }
        return cache;
    }
}

