/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cache.impl;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.commons.util.InjectiveFunction;
import org.infinispan.encoding.DataConversion;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.annotations.Inject;

public class EncoderKeyMapper<K>
implements InjectiveFunction<K, K> {
    private final DataConversion dataConversion;

    public EncoderKeyMapper(DataConversion dataConversion) {
        this.dataConversion = dataConversion;
    }

    @Inject
    public void injectDependencies(ComponentRegistry registry) {
        registry.wireDependencies(this.dataConversion);
    }

    @Override
    public K apply(K k) {
        return (K)this.dataConversion.fromStorage(k);
    }

    public static class Externalizer
    implements AdvancedExternalizer<EncoderKeyMapper> {
        @Override
        public Set<Class<? extends EncoderKeyMapper>> getTypeClasses() {
            return Collections.singleton(EncoderKeyMapper.class);
        }

        @Override
        public Integer getId() {
            return 122;
        }

        @Override
        public void writeObject(ObjectOutput output, EncoderKeyMapper object) throws IOException {
            DataConversion.writeTo(output, object.dataConversion);
        }

        @Override
        public EncoderKeyMapper readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new EncoderKeyMapper(DataConversion.readFrom(input));
        }
    }
}

