/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.operations;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import javax.transaction.xa.Xid;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.impl.operations.RetryOnFailureOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.transaction.entry.Modification;
import org.infinispan.client.hotrod.impl.transport.netty.ByteBufUtil;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelFactory;
import org.infinispan.client.hotrod.impl.transport.netty.HeaderDecoder;

public class PrepareTransactionOperation
extends RetryOnFailureOperation<Integer> {
    private final Xid xid;
    private final boolean onePhaseCommit;
    private final Collection<Modification> modifications;
    private final boolean recoverable;
    private final long timeoutMs;
    private boolean retry;

    PrepareTransactionOperation(Codec codec, ChannelFactory channelFactory, byte[] cacheName, AtomicInteger topologyId, Configuration cfg, Xid xid, boolean onePhaseCommit, Collection<Modification> modifications, boolean recoverable, long timeoutMs) {
        super((short)125, (short)126, codec, channelFactory, cacheName, topologyId, 0, cfg, null);
        this.xid = xid;
        this.onePhaseCommit = onePhaseCommit;
        this.modifications = modifications;
        this.recoverable = recoverable;
        this.timeoutMs = timeoutMs;
    }

    public boolean shouldRetry() {
        return this.retry;
    }

    @Override
    public void acceptResponse(ByteBuf buf, short status, HeaderDecoder decoder) {
        if (status == 0) {
            this.complete(buf.readInt());
        } else {
            this.retry = status == 1;
            this.complete(0);
        }
    }

    @Override
    protected void executeOperation(Channel channel) {
        this.retry = false;
        this.scheduleRead(channel);
        ByteBuf buf = channel.alloc().buffer(this.estimateSize());
        this.codec.writeHeader(buf, this.header);
        ByteBufUtil.writeXid(buf, this.xid);
        buf.writeBoolean(this.onePhaseCommit);
        buf.writeBoolean(this.recoverable);
        buf.writeLong(this.timeoutMs);
        ByteBufUtil.writeVInt(buf, this.modifications.size());
        for (Modification m : this.modifications) {
            m.writeTo(buf, this.codec);
        }
        channel.writeAndFlush(buf);
    }

    private int estimateSize() {
        int size = this.codec.estimateHeaderSize(this.header) + ByteBufUtil.estimateXidSize(this.xid) + 1 + ByteBufUtil.estimateVIntSize(this.modifications.size());
        for (Modification modification : this.modifications) {
            size += modification.estimateSize(this.codec);
        }
        return size;
    }
}

