/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.operations;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.impl.query.RemoteQuery;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.protostream.ProtobufUtil;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.query.remote.client.BaseQueryResponse;
import org.infinispan.query.remote.client.JsonClientQueryResponse;
import org.infinispan.query.remote.client.QueryRequest;
import org.infinispan.query.remote.client.QueryResponse;

enum QuerySerializer {
    JSON(MediaType.APPLICATION_JSON){
        private final Gson mapper = new GsonBuilder().disableHtmlEscaping().create();

        @Override
        byte[] serializeQueryRequest(RemoteQuery remoteQuery, QueryRequest queryRequest) {
            JsonObject object = this.mapper.toJsonTree(queryRequest).getAsJsonObject();
            return object.toString().getBytes(StandardCharsets.UTF_8);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        JsonClientQueryResponse readQueryResponse(Marshaller marshaller, RemoteQuery remoteQuery, byte[] bytesResponse) {
            try (JsonReader reader = new JsonReader(new InputStreamReader(new ByteArrayInputStream(bytesResponse)));){
                JsonClientQueryResponse jsonClientQueryResponse = new JsonClientQueryResponse((JsonObject)this.mapper.fromJson(reader, (Type)((Object)JsonObject.class)));
                return jsonClientQueryResponse;
            }
            catch (IOException e) {
                throw new HotRodClientException(e);
            }
        }
    }
    ,
    DEFAULT(MediaType.MATCH_ALL){

        @Override
        byte[] serializeQueryRequest(RemoteQuery remoteQuery, QueryRequest queryRequest) {
            SerializationContext serCtx = remoteQuery.getSerializationContext();
            if (serCtx != null) {
                try {
                    return ProtobufUtil.toByteArray(serCtx, queryRequest);
                }
                catch (IOException e) {
                    throw new HotRodClientException(e);
                }
            }
            Marshaller marshaller = remoteQuery.getCache().getRemoteCacheManager().getMarshaller();
            try {
                return marshaller.objectToByteBuffer(queryRequest);
            }
            catch (IOException e) {
                throw new HotRodClientException(e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new HotRodClientException(e);
            }
        }

        @Override
        QueryResponse readQueryResponse(Marshaller marshaller, RemoteQuery remoteQuery, byte[] bytesResponse) {
            SerializationContext serCtx = remoteQuery.getSerializationContext();
            if (serCtx != null) {
                try {
                    return ProtobufUtil.fromByteArray(serCtx, bytesResponse, QueryResponse.class);
                }
                catch (IOException e) {
                    throw new HotRodClientException(e);
                }
            }
            try {
                return (QueryResponse)marshaller.objectFromByteBuffer(bytesResponse);
            }
            catch (IOException | ClassNotFoundException e) {
                throw new HotRodClientException(e);
            }
        }
    };

    private final MediaType mediaType;

    private QuerySerializer(MediaType mediaType) {
        this.mediaType = mediaType;
    }

    public String toString() {
        return this.mediaType.getTypeSubtype();
    }

    static QuerySerializer findByMediaType(MediaType mediaType) {
        return mediaType != null && mediaType.match(MediaType.APPLICATION_JSON) ? JSON : DEFAULT;
    }

    abstract byte[] serializeQueryRequest(RemoteQuery var1, QueryRequest var2);

    abstract BaseQueryResponse readQueryResponse(Marshaller var1, RemoteQuery var2, byte[] var3);
}

