/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.protocol;

import io.netty.buffer.ByteBuf;
import java.lang.annotation.Annotation;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.infinispan.client.hotrod.DataFormat;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.annotation.ClientListener;
import org.infinispan.client.hotrod.counter.impl.HotRodCounterEvent;
import org.infinispan.client.hotrod.event.impl.AbstractClientEvent;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.exceptions.InvalidResponseException;
import org.infinispan.client.hotrod.exceptions.RemoteNodeSuspectException;
import org.infinispan.client.hotrod.impl.operations.PingOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.protocol.CodecUtils;
import org.infinispan.client.hotrod.impl.protocol.HeaderParams;
import org.infinispan.client.hotrod.impl.transport.netty.ByteBufUtil;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelFactory;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.client.hotrod.marshall.MarshallerUtil;
import org.infinispan.commons.configuration.ClassWhiteList;
import org.infinispan.commons.marshall.Marshaller;

public class Codec10
implements Codec {
    private static final Log log = LogFactory.getLog(Codec10.class, Log.class);
    protected final boolean trace = this.getLog().isTraceEnabled();

    @Override
    public HeaderParams writeHeader(ByteBuf buf, HeaderParams params) {
        return this.writeHeader(buf, params, (byte)10);
    }

    @Override
    public void writeClientListenerParams(ByteBuf buf, ClientListener clientListener, byte[][] filterFactoryParams, byte[][] converterFactoryParams) {
    }

    @Override
    public void writeExpirationParams(ByteBuf buf, long lifespan, TimeUnit lifespanTimeUnit, long maxIdle, TimeUnit maxIdleTimeUnit) {
        if (!CodecUtils.isGreaterThan4bytes(lifespan)) {
            this.getLog().warn("Lifespan value greater than the max supported size (Integer.MAX_VALUE), this can cause precision loss");
        }
        if (!CodecUtils.isGreaterThan4bytes(maxIdle)) {
            this.getLog().warn("MaxIdle value greater than the max supported size (Integer.MAX_VALUE), this can cause precision loss");
        }
        int lifespanSeconds = CodecUtils.toSeconds(lifespan, lifespanTimeUnit);
        int maxIdleSeconds = CodecUtils.toSeconds(maxIdle, maxIdleTimeUnit);
        ByteBufUtil.writeVInt(buf, lifespanSeconds);
        ByteBufUtil.writeVInt(buf, maxIdleSeconds);
    }

    @Override
    public int estimateExpirationSize(long lifespan, TimeUnit lifespanTimeUnit, long maxIdle, TimeUnit maxIdleTimeUnit) {
        int lifespanSeconds = CodecUtils.toSeconds(lifespan, lifespanTimeUnit);
        int maxIdleSeconds = CodecUtils.toSeconds(maxIdle, maxIdleTimeUnit);
        return ByteBufUtil.estimateVIntSize(lifespanSeconds) + ByteBufUtil.estimateVIntSize(maxIdleSeconds);
    }

    protected HeaderParams writeHeader(ByteBuf buf, HeaderParams params, byte version) {
        buf.writeByte(160);
        ByteBufUtil.writeVLong(buf, params.messageId);
        buf.writeByte(version);
        buf.writeByte(params.opCode);
        ByteBufUtil.writeArray(buf, params.cacheName);
        int flagInt = params.flags & Flag.FORCE_RETURN_VALUE.getFlagInt();
        ByteBufUtil.writeVInt(buf, flagInt);
        buf.writeByte(params.clientIntel);
        ByteBufUtil.writeVInt(buf, params.topologyId.get());
        buf.writeByte(params.txMarker);
        if (this.trace) {
            this.getLog().tracef("Wrote header for message %d. Operation code: %#04x. Flags: %#x", params.messageId, (long)params.opCode, (long)flagInt);
        }
        return params;
    }

    @Override
    public int estimateHeaderSize(HeaderParams headerParams) {
        return 1 + ByteBufUtil.estimateVLongSize(headerParams.messageId) + 1 + 1 + ByteBufUtil.estimateArraySize(headerParams.cacheName) + ByteBufUtil.estimateVIntSize(headerParams.flags) + 1 + ByteBufUtil.estimateVIntSize(headerParams.topologyId.get()) + 1;
    }

    @Override
    public long readMessageId(ByteBuf buf) {
        short magic = buf.readUnsignedByte();
        Log localLog = this.getLog();
        if (magic != 161) {
            String message = "Invalid magic number. Expected %#x and received %#x";
            localLog.invalidMagicNumber((short)161, magic);
            if (this.trace) {
                localLog.tracef("Socket dump: %s", (Object)ByteBufUtil.hexDump(buf));
            }
            throw new InvalidResponseException(String.format(message, (short)161, magic));
        }
        long receivedMessageId = ByteBufUtil.readVLong(buf);
        if (this.trace) {
            this.getLog().tracef("Received response for messageId=%d", receivedMessageId);
        }
        return receivedMessageId;
    }

    @Override
    public short readOpCode(ByteBuf buf) {
        short receivedOpCode = buf.readUnsignedByte();
        if (this.trace) {
            this.getLog().tracef("Received operation code is: %#04x", receivedOpCode);
        }
        return receivedOpCode;
    }

    @Override
    public short readHeader(ByteBuf buf, double receivedOpCode, HeaderParams params, ChannelFactory channelFactory, SocketAddress serverAddress) {
        short status = buf.readUnsignedByte();
        this.readNewTopologyIfPresent(buf, params, channelFactory);
        if (receivedOpCode != (double)params.opRespCode) {
            if (receivedOpCode == 80.0) {
                this.checkForErrorsInResponseStatus(buf, params, status);
            }
            throw new InvalidResponseException(String.format("Invalid response operation. Expected %#x and received %#x", params.opRespCode, receivedOpCode));
        }
        return status;
    }

    @Override
    public AbstractClientEvent readCacheEvent(ByteBuf buf, Function<byte[], DataFormat> dataFormatFunction, short eventTypeId, ClassWhiteList whitelist, SocketAddress serverAddress) {
        return null;
    }

    @Override
    public HotRodCounterEvent readCounterEvent(ByteBuf buf) {
        return null;
    }

    @Override
    public boolean isObjectStorageHinted(PingOperation.PingResponse pingResponse) {
        return false;
    }

    @Override
    public Object returnPossiblePrevValue(ByteBuf buf, short status, DataFormat dataFormat, int flags, ClassWhiteList whitelist, Marshaller marshaller) {
        if (this.hasForceReturn(flags)) {
            return MarshallerUtil.bytes2obj(marshaller, ByteBufUtil.readArray(buf), dataFormat.isObjectStorage(), whitelist);
        }
        return null;
    }

    private boolean hasForceReturn(int flags) {
        return (flags & Flag.FORCE_RETURN_VALUE.getFlagInt()) != 0;
    }

    @Override
    public Log getLog() {
        return log;
    }

    @Override
    public void writeClientListenerInterests(ByteBuf buf, Set<Class<? extends Annotation>> classes) {
    }

    protected void checkForErrorsInResponseStatus(ByteBuf buf, HeaderParams params, short status) {
        Log localLog = this.getLog();
        if (this.trace) {
            localLog.tracef("Received operation status: %#x", status);
        }
        try {
            switch (status) {
                case 129: 
                case 130: 
                case 131: 
                case 132: 
                case 133: 
                case 134: {
                    String msgFromServer = ByteBufUtil.readString(buf);
                    if (status == 134 && this.trace) {
                        localLog.tracef("Server-side timeout performing operation: %s", (Object)msgFromServer);
                    }
                    if (msgFromServer.contains("SuspectException") || msgFromServer.contains("SuspectedException")) {
                        if (this.trace) {
                            localLog.tracef("A remote node was suspected while executing messageId=%d. Check if retry possible. Message from server: %s", params.messageId, (Object)msgFromServer);
                        }
                        throw new RemoteNodeSuspectException(msgFromServer, params.messageId, status);
                    }
                    localLog.errorFromServer(msgFromServer);
                    throw new HotRodClientException(msgFromServer, params.messageId, status);
                }
            }
            throw new IllegalStateException(String.format("Unknown status: %#04x", status));
        }
        catch (Throwable throwable) {
            switch (status) {
                default: 
            }
            throw throwable;
        }
    }

    protected void readNewTopologyIfPresent(ByteBuf buf, HeaderParams params, ChannelFactory channelFactory) {
        short topologyChangeByte = buf.readUnsignedByte();
        if (topologyChangeByte == 1) {
            this.readNewTopologyAndHash(buf, params.topologyId, params.cacheName, channelFactory);
        }
    }

    protected void readNewTopologyAndHash(ByteBuf buf, AtomicInteger topologyId, byte[] cacheName, ChannelFactory channelFactory) {
        Log localLog = this.getLog();
        int newTopologyId = ByteBufUtil.readVInt(buf);
        topologyId.set(newTopologyId);
        int numKeyOwners = buf.readUnsignedShort();
        short hashFunctionVersion = buf.readUnsignedByte();
        int hashSpace = ByteBufUtil.readVInt(buf);
        int clusterSize = ByteBufUtil.readVInt(buf);
        Map<SocketAddress, Set<Integer>> servers2Hash = this.computeNewHashes(buf, channelFactory, localLog, newTopologyId, numKeyOwners, hashFunctionVersion, hashSpace, clusterSize);
        Set<SocketAddress> socketAddresses = servers2Hash.keySet();
        int topologyAge = channelFactory.getTopologyAge();
        if (localLog.isInfoEnabled()) {
            localLog.newTopology(newTopologyId, topologyAge, socketAddresses.size(), socketAddresses);
        }
        channelFactory.updateServers(socketAddresses, cacheName, false);
        if (hashFunctionVersion == 0) {
            localLog.trace("Not using a consistent hash function (version 0).");
        } else if (hashFunctionVersion == 1) {
            localLog.trace("Ignoring obsoleted consistent hash function (version 1)");
        } else {
            channelFactory.updateHashFunction(servers2Hash, numKeyOwners, hashFunctionVersion, hashSpace, cacheName, topologyId);
        }
    }

    protected Map<SocketAddress, Set<Integer>> computeNewHashes(ByteBuf buf, ChannelFactory channelFactory, Log localLog, int newTopologyId, int numKeyOwners, short hashFunctionVersion, int hashSpace, int clusterSize) {
        if (this.trace) {
            localLog.tracef("Topology change request: newTopologyId=%d, numKeyOwners=%d, hashFunctionVersion=%d, hashSpaceSize=%d, clusterSize=%d", newTopologyId, numKeyOwners, hashFunctionVersion, hashSpace, clusterSize);
        }
        LinkedHashMap<SocketAddress, Set<Integer>> servers2Hash = new LinkedHashMap<SocketAddress, Set<Integer>>();
        for (int i = 0; i < clusterSize; ++i) {
            InetSocketAddress address;
            HashSet<Integer> hashes;
            String host = ByteBufUtil.readString(buf);
            int port = buf.readUnsignedShort();
            int hashCode = buf.readIntLE();
            if (this.trace) {
                localLog.tracef("Server read: %s:%d - hash code is %d", (Object)host, (Object)port, (Object)hashCode);
            }
            if ((hashes = (HashSet<Integer>)servers2Hash.get(address = InetSocketAddress.createUnresolved(host, port))) == null) {
                hashes = new HashSet<Integer>();
                servers2Hash.put(address, hashes);
            }
            hashes.add(hashCode);
            if (!this.trace) continue;
            localLog.tracef("Hash code is: %d", hashCode);
        }
        return servers2Hash;
    }
}

