/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.transaction;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.infinispan.client.hotrod.impl.transaction.TransactionContext;
import org.infinispan.client.hotrod.impl.transaction.TransactionTable;
import org.infinispan.client.hotrod.impl.transaction.TransactionalRemoteCacheImpl;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.client.hotrod.transaction.manager.RemoteXid;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.tx.Util;

public class SyncModeTransactionTable
implements TransactionTable {
    private static final Log log = LogFactory.getLog(SyncModeTransactionTable.class, Log.class);
    private static final boolean trace = log.isTraceEnabled();
    private final Map<Transaction, SynchronizationAdapter> registeredTransactions = new ConcurrentHashMap<Transaction, SynchronizationAdapter>();
    private final UUID uuid = UUID.randomUUID();
    private final Consumer<Transaction> cleanup = this.registeredTransactions::remove;
    private final long timeout;
    private final Function<Transaction, SynchronizationAdapter> constructor = this::createSynchronizationAdapter;

    public SyncModeTransactionTable(long timeout) {
        this.timeout = timeout;
    }

    @Override
    public <K, V> TransactionContext<K, V> enlist(TransactionalRemoteCacheImpl<K, V> txRemoteCache, Transaction tx) {
        SynchronizationAdapter adapter = this.registeredTransactions.computeIfAbsent(tx, this.constructor);
        TransactionContext context = adapter.registerCache(txRemoteCache);
        if (trace) {
            log.tracef("Xid=%s retrieving context: %s", (Object)adapter.xid, (Object)context);
        }
        return context;
    }

    private SynchronizationAdapter createSynchronizationAdapter(Transaction transaction) {
        SynchronizationAdapter adapter = new SynchronizationAdapter(transaction, this.cleanup, RemoteXid.create(this.uuid), this.timeout);
        try {
            transaction.registerSynchronization(adapter);
        }
        catch (RollbackException | SystemException e) {
            throw new CacheException(e);
        }
        if (trace) {
            log.tracef("Registered synchronization for transaction %s. Sync=%s", (Object)transaction, (Object)adapter);
        }
        return adapter;
    }

    private static class SynchronizationAdapter
    implements Synchronization {
        private final Map<String, TransactionContext<?, ?>> registeredCaches = new ConcurrentSkipListMap();
        private final Transaction transaction;
        private final Consumer<Transaction> cleanupTask;
        private final RemoteXid xid;
        private final long timeout;

        private SynchronizationAdapter(Transaction transaction, Consumer<Transaction> cleanupTask, RemoteXid xid, long timeout) {
            this.transaction = transaction;
            this.cleanupTask = cleanupTask;
            this.xid = xid;
            this.timeout = timeout;
        }

        public String toString() {
            return "SynchronizationAdapter{registeredCaches=" + this.registeredCaches.keySet() + ", transaction=" + this.transaction + ", xid=" + this.xid + '}';
        }

        @Override
        public void beforeCompletion() {
            if (trace) {
                log.tracef("BeforeCompletion(xid=%s, remote-caches=%s)", (Object)this.xid, (Object)this.registeredCaches.keySet());
            }
            if (this.isMarkedRollback()) {
                return;
            }
            block4: for (TransactionContext<?, ?> txContext : this.registeredCaches.values()) {
                switch (txContext.prepareContext(this.xid, false, this.timeout)) {
                    case 0: 
                    case 3: {
                        continue block4;
                    }
                    case -2147483648: {
                        this.markAsRollback();
                        return;
                    }
                }
                this.markAsRollback();
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void afterCompletion(int status) {
            if (trace) {
                log.tracef("AfterCompletion(xid=%s, status=%s, remote-caches=%s)", (Object)this.xid, (Object)Util.transactionStatusToString(status), (Object)this.registeredCaches.keySet());
            }
            TransactionContext<?, ?> ctx = this.registeredCaches.values().iterator().next();
            try {
                boolean commit = status == 3;
                ctx.complete(this.xid, commit);
            }
            finally {
                ctx.forget(this.xid);
                this.cleanupTask.accept(this.transaction);
            }
        }

        private void markAsRollback() {
            try {
                this.transaction.setRollbackOnly();
            }
            catch (SystemException e) {
                log.debug("Exception in markAsRollback", e);
            }
        }

        private boolean isMarkedRollback() {
            try {
                return this.transaction.getStatus() == 1;
            }
            catch (SystemException e) {
                log.debug("Exception in isMarkedRollback", e);
                return false;
            }
        }

        private <K, V> TransactionContext<K, V> registerCache(TransactionalRemoteCacheImpl<K, V> txRemoteCache) {
            return this.registeredCaches.computeIfAbsent(txRemoteCache.getName(), s -> this.createTxContext(txRemoteCache));
        }

        private <K, V> TransactionContext<K, V> createTxContext(TransactionalRemoteCacheImpl<K, V> remoteCache) {
            if (trace) {
                log.tracef("Registering remote cache '%s' for transaction xid=%s", (Object)remoteCache.getName(), (Object)this.xid);
            }
            return new TransactionContext<K, V>(remoteCache.keyMarshaller(), remoteCache.valueMarshaller(), remoteCache.getOperationsFactory(), remoteCache.getName(), false);
        }
    }
}

