/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.transaction;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.transaction.xa.Xid;
import org.infinispan.client.hotrod.MetadataValue;
import org.infinispan.client.hotrod.impl.operations.CompleteTransactionOperation;
import org.infinispan.client.hotrod.impl.operations.ForgetTransactionOperation;
import org.infinispan.client.hotrod.impl.operations.OperationsFactory;
import org.infinispan.client.hotrod.impl.operations.PrepareTransactionOperation;
import org.infinispan.client.hotrod.impl.transaction.entry.Modification;
import org.infinispan.client.hotrod.impl.transaction.entry.TransactionEntry;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.commons.util.ByRef;
import org.infinispan.commons.util.CloseableIteratorSet;
import org.infinispan.commons.util.Util;

public class TransactionContext<K, V> {
    private static final Log log = LogFactory.getLog(TransactionContext.class, Log.class);
    private static final boolean trace = log.isTraceEnabled();
    private final Map<WrappedKey<K>, TransactionEntry<K, V>> entries;
    private final Function<K, byte[]> keyMarshaller;
    private final Function<V, byte[]> valueMarshaller;
    private final OperationsFactory operationsFactory;
    private final String cacheName;
    private final boolean recoverable;

    TransactionContext(Function<K, byte[]> keyMarshaller, Function<V, byte[]> valueMarshaller, OperationsFactory operationsFactory, String cacheName, boolean recoveryEnabled) {
        this.keyMarshaller = keyMarshaller;
        this.valueMarshaller = valueMarshaller;
        this.operationsFactory = operationsFactory;
        this.cacheName = cacheName;
        this.recoverable = recoveryEnabled;
        this.entries = new ConcurrentHashMap<WrappedKey<K>, TransactionEntry<K, V>>();
    }

    public String toString() {
        return "TransactionContext{cacheName='" + this.cacheName + '\'' + ", context-size=" + this.entries.size() + " (entries)" + '}';
    }

    boolean containsKey(Object key, Function<K, MetadataValue<V>> remoteValueSupplier) {
        ByRef<Object> result = new ByRef<Object>(null);
        this.entries.compute(this.wrap(key), (? super K wKey, ? super V entry) -> {
            if (entry == null) {
                entry = this.createEntryFromRemote(((WrappedKey)wKey).key, remoteValueSupplier);
            }
            result.set((!entry.isNonExists() ? 1 : 0));
            return entry;
        });
        return result.get();
    }

    boolean containsValue(Object value, Supplier<CloseableIteratorSet<Map.Entry<K, V>>> iteratorSupplier, Function<K, MetadataValue<V>> remoteValueSupplier) {
        boolean found = this.entries.values().stream().map(TransactionEntry::getValue).filter(Objects::nonNull).anyMatch(v -> Objects.deepEquals(v, value));
        return found || this.searchValue(value, iteratorSupplier.get(), remoteValueSupplier);
    }

    <T> CompletableFuture<T> compute(K key, Function<TransactionEntry<K, V>, T> function) {
        CompletableFuture future = new CompletableFuture();
        this.entries.compute(this.wrap(key), (? super K wKey, ? super V entry) -> {
            if (entry == null) {
                entry = TransactionEntry.notReadEntry(((WrappedKey)wKey).key);
            }
            if (trace) {
                log.tracef("Compute key (%s). Before=%s", wKey, entry);
            }
            Object result = function.apply((TransactionEntry)entry);
            future.complete(result);
            if (trace) {
                log.tracef("Compute key (%s). After=%s (result=%s)", wKey, entry, result);
            }
            return entry;
        });
        return future;
    }

    OperationsFactory getOperationsFactory() {
        return this.operationsFactory;
    }

    String getCacheName() {
        return this.cacheName;
    }

    <T> CompletableFuture<T> compute(K key, Function<TransactionEntry<K, V>, T> function, Function<K, MetadataValue<V>> remoteValueSupplier) {
        CompletableFuture future = new CompletableFuture();
        this.entries.compute(this.wrap(key), (? super K wKey, ? super V entry) -> {
            if (entry == null) {
                entry = this.createEntryFromRemote(((WrappedKey)wKey).key, remoteValueSupplier);
                if (trace) {
                    log.tracef("Fetched key (%s) from remote. Entry=%s", wKey, entry);
                }
            }
            if (trace) {
                log.tracef("Compute key (%s). Before=%s", wKey, entry);
            }
            Object result = function.apply((TransactionEntry<K, V>)entry);
            future.complete(result);
            if (trace) {
                log.tracef("Compute key (%s). After=%s (result=%s)", wKey, entry, result);
            }
            return entry;
        });
        return future;
    }

    boolean isReadWrite() {
        return this.entries.values().stream().anyMatch(TransactionEntry::isModified);
    }

    Collection<Modification> toModification() {
        return this.entries.values().stream().filter(TransactionEntry::isModified).map(entry -> entry.toModification(this.keyMarshaller, this.valueMarshaller)).collect(Collectors.toList());
    }

    <T> T computeSync(K key, Function<TransactionEntry<K, V>, T> function, Function<K, MetadataValue<V>> remoteValueSupplier) {
        ByRef<Object> ref = new ByRef<Object>(null);
        this.entries.compute(this.wrap(key), (? super K wKey, ? super V entry) -> {
            if (entry == null) {
                entry = this.createEntryFromRemote(((WrappedKey)wKey).key, remoteValueSupplier);
                if (trace) {
                    log.tracef("Fetched key (%s) from remote. Entry=%s", wKey, entry);
                }
            }
            if (trace) {
                log.tracef("Compute key (%s). Before=%s", wKey, entry);
            }
            Object result = function.apply((TransactionEntry<K, V>)entry);
            ref.set(result);
            if (trace) {
                log.tracef("Compute key (%s). After=%s (result=%s)", wKey, entry, result);
            }
            return entry;
        });
        return ref.get();
    }

    int prepareContext(Xid xid, boolean onePhaseCommit, long timeout) {
        Collection<Modification> modifications;
        try {
            modifications = this.toModification();
            if (trace) {
                log.tracef("Preparing transaction xid=%s, remote-cache=%s, modification-size=%d", (Object)xid, (Object)this.cacheName, (Object)modifications.size());
            }
            if (modifications.isEmpty()) {
                return 3;
            }
        }
        catch (Exception e) {
            return Integer.MIN_VALUE;
        }
        try {
            int xaReturnCode;
            PrepareTransactionOperation operation;
            do {
                operation = this.operationsFactory.newPrepareTransactionOperation(xid, onePhaseCommit, modifications, this.recoverable, timeout);
                xaReturnCode = (Integer)operation.execute().get();
            } while (operation.shouldRetry());
            return xaReturnCode;
        }
        catch (Exception e) {
            log.exceptionDuringPrepare(xid, e);
            return 100;
        }
    }

    int complete(Xid xid, boolean commit) {
        try {
            if (trace) {
                log.tracef("Complete (%s) transaction xid=%s, cache-name=%s", (Object)commit, (Object)xid, (Object)this.cacheName);
            }
            CompleteTransactionOperation operation = this.operationsFactory.newCompleteTransactionOperation(xid, commit);
            return (Integer)operation.execute().get();
        }
        catch (Exception e) {
            log.debug("Exception while commit/rollback.", e);
            return 6;
        }
    }

    void forget(Xid xid) {
        block3: {
            try {
                if (trace) {
                    log.tracef("Forgetting transaction xid=%s, remote-cache=%s", (Object)xid, (Object)this.cacheName);
                }
                ForgetTransactionOperation operation = this.operationsFactory.newForgetTransactionOperation(xid);
                operation.execute().get();
            }
            catch (Exception e) {
                if (!trace) break block3;
                log.tracef((Throwable)e, "Exception in forget transaction xid=%s", (Object)xid);
            }
        }
    }

    CompletableFuture<Collection<Xid>> fetchPreparedTransactions() {
        if (trace) {
            log.trace("Fetch prepared transactions XID for recovery");
        }
        return this.operationsFactory.newRecoveryOperation().execute();
    }

    void cleanupEntries() {
        this.entries.clear();
    }

    private TransactionEntry<K, V> createEntryFromRemote(K key, Function<K, MetadataValue<V>> remoteValueSupplier) {
        MetadataValue<V> remoteValue = remoteValueSupplier.apply(key);
        return remoteValue == null ? TransactionEntry.nonExistingEntry(key) : TransactionEntry.read(key, remoteValue);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean searchValue(Object value, CloseableIteratorSet<Map.Entry<K, V>> iterator, Function<K, MetadataValue<V>> remoteValueSupplier) {
        try (Iterator it = iterator.iterator();){
            block17: {
                while (it.hasNext()) {
                    Map.Entry entry = (Map.Entry)it.next();
                    if (this.entries.containsKey(this.wrap(entry.getKey())) || !Objects.deepEquals(entry.getValue(), value)) continue;
                    ByRef.Boolean result = new ByRef.Boolean(false);
                    this.entries.computeIfAbsent(this.wrap(entry.getKey()), wrappedKey -> {
                        MetadataValue remoteValue = (MetadataValue)remoteValueSupplier.apply(((WrappedKey)wrappedKey).key);
                        if (Objects.deepEquals(remoteValue.getValue(), value)) {
                            result.set(true);
                            return TransactionEntry.read(((WrappedKey)wrappedKey).key, remoteValue);
                        }
                        return null;
                    });
                    if (!result.get()) {
                        continue;
                    }
                    break block17;
                }
                return false;
            }
            boolean bl = true;
            return bl;
        }
    }

    private WrappedKey<K> wrap(K key) {
        return new WrappedKey(key);
    }

    private static class WrappedKey<K> {
        private final K key;

        private WrappedKey(K key) {
            this.key = key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            WrappedKey that = (WrappedKey)o;
            return Objects.deepEquals(this.key, that.key);
        }

        public int hashCode() {
            if (this.key instanceof Object[]) {
                return Arrays.deepHashCode((Object[])this.key);
            }
            if (this.key instanceof byte[]) {
                return Arrays.hashCode((byte[])this.key);
            }
            if (this.key instanceof short[]) {
                return Arrays.hashCode((short[])this.key);
            }
            if (this.key instanceof int[]) {
                return Arrays.hashCode((int[])this.key);
            }
            if (this.key instanceof long[]) {
                return Arrays.hashCode((long[])this.key);
            }
            if (this.key instanceof char[]) {
                return Arrays.hashCode((char[])this.key);
            }
            if (this.key instanceof float[]) {
                return Arrays.hashCode((float[])this.key);
            }
            if (this.key instanceof double[]) {
                return Arrays.hashCode((double[])this.key);
            }
            if (this.key instanceof boolean[]) {
                return Arrays.hashCode((boolean[])this.key);
            }
            return Objects.hashCode(this.key);
        }

        public String toString() {
            return "WrappedKey{key=" + Util.toStr(this.key) + '}';
        }
    }
}

