/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.transaction;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.infinispan.client.hotrod.impl.transaction.TransactionContext;
import org.infinispan.client.hotrod.impl.transaction.TransactionTable;
import org.infinispan.client.hotrod.impl.transaction.TransactionalRemoteCacheImpl;
import org.infinispan.client.hotrod.impl.transaction.recovery.RecoveryIterator;
import org.infinispan.client.hotrod.impl.transaction.recovery.RecoveryManager;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.commons.CacheException;

public class XaModeTransactionTable
implements TransactionTable {
    private static final Log log = LogFactory.getLog(XaModeTransactionTable.class, Log.class);
    private static final boolean trace = log.isTraceEnabled();
    private final Map<Transaction, XaAdapter> registeredTransactions = new ConcurrentHashMap<Transaction, XaAdapter>();
    private final RecoveryManager recoveryManager = new RecoveryManager();
    private final Function<Transaction, XaAdapter> constructor = this::createTransactionData;
    private final long timeout;

    public XaModeTransactionTable(long timeout) {
        this.timeout = timeout;
    }

    @Override
    public <K, V> TransactionContext<K, V> enlist(TransactionalRemoteCacheImpl<K, V> txRemoteCache, Transaction tx) {
        XaAdapter xaAdapter = this.registeredTransactions.computeIfAbsent(tx, this.constructor);
        return xaAdapter.registerCache(txRemoteCache);
    }

    private XaAdapter createTransactionData(Transaction transaction) {
        XaAdapter xaAdapter = new XaAdapter(transaction, this.timeout);
        try {
            transaction.enlistResource(xaAdapter);
        }
        catch (RollbackException | SystemException e) {
            throw new CacheException(e);
        }
        return xaAdapter;
    }

    private class XaAdapter
    implements XAResource {
        private final Transaction transaction;
        private final Map<String, TransactionContext<?, ?>> registeredCaches = new ConcurrentSkipListMap();
        private volatile Xid currentXid;
        private volatile RecoveryIterator iterator;
        private long timeoutMs;
        private boolean needsRecovery = false;

        private XaAdapter(Transaction transaction, long timeout) {
            this.transaction = transaction;
            this.timeoutMs = timeout;
        }

        public String toString() {
            return "TransactionData{xid=" + this.currentXid + ", caches=" + this.registeredCaches.keySet() + '}';
        }

        @Override
        public void start(Xid xid, int flags) throws XAException {
            if (trace) {
                log.tracef("XaResource.start(%s, %s)", (Object)xid, (Object)flags);
            }
            switch (flags) {
                case 0x200000: 
                case 0x8000000: {
                    if (this.currentXid != null && !this.currentXid.equals(xid)) {
                        throw new XAException(-9);
                    }
                    this.assertStartInvoked();
                    break;
                }
                case 0: {
                    if (this.currentXid != null) {
                        throw new XAException(-3);
                    }
                    this.currentXid = xid;
                    break;
                }
                default: {
                    throw new XAException(-3);
                }
            }
        }

        @Override
        public void end(Xid xid, int flags) throws XAException {
            if (trace) {
                log.tracef("XaResource.end(%s, %s)", (Object)xid, (Object)flags);
            }
            this.assertStartInvoked();
            this.assertSameXid(xid, -9);
        }

        @Override
        public int prepare(Xid xid) throws XAException {
            if (trace) {
                log.tracef("XaResource.prepare(%s)", (Object)xid);
            }
            this.assertStartInvoked();
            this.assertSameXid(xid, -5);
            return this.internalPrepare();
        }

        @Override
        public void commit(Xid xid, boolean onePhaseCommit) throws XAException {
            if (trace) {
                log.tracef("XaResource.commit(%s, %s)", (Object)xid, (Object)onePhaseCommit);
            }
            if (this.currentXid == null) {
                this.currentXid = xid;
            } else {
                this.assertSameXid(xid, -5);
            }
            try {
                if (onePhaseCommit) {
                    this.onePhaseCommit();
                } else {
                    this.internalCommit();
                }
            }
            finally {
                this.cleanup();
            }
        }

        @Override
        public void rollback(Xid xid) throws XAException {
            if (trace) {
                log.tracef("XaResource.rollback(%s)", (Object)xid);
            }
            boolean ignoreNoTx = true;
            if (this.currentXid == null) {
                this.currentXid = xid;
                ignoreNoTx = false;
            } else {
                this.assertSameXid(xid, -5);
            }
            try {
                this.internalRollback(ignoreNoTx);
            }
            finally {
                this.cleanup();
            }
        }

        @Override
        public boolean isSameRM(XAResource xaResource) {
            if (trace) {
                log.tracef("XaResource.isSameRM(%s)", (Object)xaResource);
            }
            return xaResource == this;
        }

        @Override
        public void forget(Xid xid) {
            if (trace) {
                log.tracef("XaResource.forget(%s)", (Object)xid);
            }
            XaModeTransactionTable.this.recoveryManager.forgetTransaction(xid);
            this.getAnyTransactionContext().forget(xid);
        }

        @Override
        public Xid[] recover(int flags) throws XAException {
            if (trace) {
                log.tracef("XaResource.recover(%s)", flags);
            }
            RecoveryIterator it = this.iterator;
            if ((flags & 0x1000000) != 0) {
                if (it == null) {
                    this.iterator = it = XaModeTransactionTable.this.recoveryManager.startScan(this.getAnyTransactionContext().fetchPreparedTransactions());
                } else {
                    throw new XAException(-5);
                }
            }
            if ((flags & 0x800000) != 0) {
                if (it == null) {
                    throw new XAException(-5);
                }
                this.iterator.finish(this.timeoutMs);
                this.iterator = null;
            }
            if (it == null) {
                throw new XAException(-5);
            }
            return it.next();
        }

        @Override
        public boolean setTransactionTimeout(int timeoutSeconds) {
            this.timeoutMs = TimeUnit.SECONDS.toMillis(timeoutSeconds);
            return true;
        }

        @Override
        public int getTransactionTimeout() {
            return (int)TimeUnit.MILLISECONDS.toSeconds(this.timeoutMs);
        }

        private void assertStartInvoked() throws XAException {
            if (this.currentXid == null) {
                throw new XAException(-4);
            }
        }

        private void assertSameXid(Xid otherXid, int xaErrorCode) throws XAException {
            if (!this.currentXid.equals(otherXid)) {
                throw new XAException(xaErrorCode);
            }
        }

        private void internalRollback(boolean ignoreNoTx) throws XAException {
            int xa_code = this.getAnyTransactionContext().complete(this.currentXid, false);
            switch (xa_code) {
                case 0: 
                case 3: 
                case 6: {
                    break;
                }
                case -4: {
                    if (ignoreNoTx) break;
                }
                default: {
                    throw new XAException(xa_code);
                }
            }
        }

        private TransactionContext<?, ?> getAnyTransactionContext() {
            return this.registeredCaches.values().iterator().next();
        }

        private void internalCommit() throws XAException {
            int xa_code = this.getAnyTransactionContext().complete(this.currentXid, true);
            switch (xa_code) {
                case 0: 
                case 3: 
                case 7: {
                    break;
                }
                default: {
                    throw new XAException(xa_code);
                }
            }
        }

        private int internalPrepare() throws XAException {
            boolean readOnly = true;
            block5: for (TransactionContext<?, ?> ctx : this.registeredCaches.values()) {
                switch (ctx.prepareContext(this.currentXid, false, this.timeoutMs)) {
                    case 0: {
                        readOnly = false;
                        continue block5;
                    }
                    case 3: {
                        continue block5;
                    }
                    case -2147483648: {
                        throw new XAException(100);
                    }
                }
                throw new XAException(100);
            }
            if (this.needsRecovery) {
                XaModeTransactionTable.this.recoveryManager.addTransaction(this.currentXid);
            }
            return readOnly ? 3 : 0;
        }

        private void onePhaseCommit() throws XAException {
            List txCaches = this.registeredCaches.values().stream().filter(TransactionContext::isReadWrite).collect(Collectors.toList());
            int size = txCaches.size();
            if (size == 0) {
                return;
            }
            boolean commit = true;
            block4: for (int i = 0; i < size - 1; ++i) {
                TransactionContext ctx = (TransactionContext)txCaches.get(i);
                switch (ctx.prepareContext(this.currentXid, false, this.timeoutMs)) {
                    case 0: {
                        continue block4;
                    }
                    case -2147483648: {
                        commit = false;
                        break block4;
                    }
                    default: {
                        commit = false;
                        break block4;
                    }
                }
            }
            if (!commit || ((TransactionContext)txCaches.get(size - 1)).prepareContext(this.currentXid, true, this.timeoutMs) != 0) {
                this.internalRollback(true);
                throw new XAException(100);
            }
            this.internalCommit();
        }

        private <K, V> TransactionContext<K, V> registerCache(TransactionalRemoteCacheImpl<K, V> txRemoteCache) {
            if (this.currentXid == null) {
                throw new CacheException("XaResource wasn't invoked!");
            }
            this.needsRecovery |= txRemoteCache.isRecoveryEnabled();
            return this.registeredCaches.computeIfAbsent(txRemoteCache.getName(), s -> this.createTxContext(txRemoteCache));
        }

        private <K, V> TransactionContext<K, V> createTxContext(TransactionalRemoteCacheImpl<K, V> remoteCache) {
            if (trace) {
                log.tracef("Registering remote cache '%s' for transaction xid=%s", (Object)remoteCache.getName(), (Object)this.currentXid);
            }
            return new TransactionContext<K, V>(remoteCache.keyMarshaller(), remoteCache.valueMarshaller(), remoteCache.getOperationsFactory(), remoteCache.getName(), remoteCache.isRecoveryEnabled());
        }

        private void cleanup() {
            XaModeTransactionTable.this.registeredTransactions.remove(this.transaction);
            this.registeredCaches.values().forEach(TransactionContext::cleanupEntries);
            XaModeTransactionTable.this.recoveryManager.forgetTransaction(this.currentXid);
            this.currentXid = null;
        }
    }
}

