/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.functional;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.function.Function;
import org.infinispan.commands.CommandInvocationId;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.functional.AbstractWriteKeyCommand;
import org.infinispan.commands.functional.Mutation;
import org.infinispan.commands.functional.Mutations;
import org.infinispan.commands.functional.functions.InjectableComponent;
import org.infinispan.commands.write.ValueMatcher;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.util.Util;
import org.infinispan.container.entries.MVCCEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.encoding.DataConversion;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.Param;
import org.infinispan.functional.impl.EntryViews;
import org.infinispan.functional.impl.Params;
import org.infinispan.functional.impl.StatsEnvelope;

public final class ReadWriteKeyCommand<K, V, R>
extends AbstractWriteKeyCommand<K, V> {
    public static final byte COMMAND_ID = 50;
    private Function<EntryView.ReadWriteEntryView<K, V>, R> f;

    public ReadWriteKeyCommand(Object key, Function<EntryView.ReadWriteEntryView<K, V>, R> f, int segment, CommandInvocationId id, ValueMatcher valueMatcher, Params params, DataConversion keyDataConversion, DataConversion valueDataConversion, ComponentRegistry componentRegistry) {
        super(key, valueMatcher, segment, id, params, keyDataConversion, valueDataConversion);
        this.f = f;
        this.init(componentRegistry);
    }

    public ReadWriteKeyCommand() {
    }

    @Override
    public byte getCommandId() {
        return 50;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        output.writeObject(this.key);
        output.writeObject(this.f);
        MarshallUtil.marshallEnum(this.valueMatcher, output);
        UnsignedNumeric.writeUnsignedInt(output, this.segment);
        Params.writeObject(output, this.params);
        output.writeLong(FlagBitSets.copyWithoutRemotableFlags(this.getFlagsBitSet()));
        CommandInvocationId.writeTo(output, this.commandInvocationId);
        DataConversion.writeTo(output, this.keyDataConversion);
        DataConversion.writeTo(output, this.valueDataConversion);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.key = input.readObject();
        this.f = (Function)input.readObject();
        this.valueMatcher = MarshallUtil.unmarshallEnum(input, ValueMatcher::valueOf);
        this.segment = UnsignedNumeric.readUnsignedInt(input);
        this.params = Params.readObject(input);
        this.setFlagsBitSet(input.readLong());
        this.commandInvocationId = CommandInvocationId.readFrom(input);
        this.keyDataConversion = DataConversion.readFrom(input);
        this.valueDataConversion = DataConversion.readFrom(input);
    }

    @Override
    public boolean isConditional() {
        return true;
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        if (this.valueMatcher == ValueMatcher.MATCH_NEVER) {
            this.successful = false;
            return null;
        }
        MVCCEntry e = (MVCCEntry)ctx.lookupEntry(this.key);
        if (e == null) {
            return null;
        }
        boolean exists = e.getValue() != null;
        EntryViews.AccessLoggingReadWriteView view = EntryViews.readWrite(e, this.keyDataConversion, this.valueDataConversion);
        R ret = EntryViews.snapshot(this.f.apply(view));
        if (!e.isChanged() && !this.hasAnyFlag(FlagBitSets.COMMAND_RETRY)) {
            this.successful = false;
        }
        return Param.StatisticsMode.isSkip(this.params) ? ret : StatsEnvelope.create(ret, e, exists, view.isRead());
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitReadWriteKeyCommand(ctx, this);
    }

    @Override
    public VisitableCommand.LoadType loadType() {
        return VisitableCommand.LoadType.OWNER;
    }

    @Override
    public Mutation<K, V, ?> toMutation(Object key) {
        return new Mutations.ReadWrite<K, V, R>(this.keyDataConversion, this.valueDataConversion, this.f);
    }

    public Function<EntryView.ReadWriteEntryView<K, V>, R> getFunction() {
        return this.f;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("ReadWriteKeyCommand{");
        sb.append("key=").append(Util.toStr(this.key));
        sb.append(", f=").append(this.f.getClass().getName());
        sb.append(", flags=").append(this.printFlags());
        sb.append(", commandInvocationId=").append(this.commandInvocationId);
        sb.append(", topologyId=").append(this.getTopologyId());
        sb.append(", params=").append(this.params);
        sb.append(", valueMatcher=").append((Object)this.valueMatcher);
        sb.append(", successful=").append(this.successful);
        sb.append(", keyDataConversion=").append(this.keyDataConversion);
        sb.append(", valueDataConversion=").append(this.valueDataConversion);
        sb.append('}');
        return sb.toString();
    }

    @Override
    public void init(ComponentRegistry componentRegistry) {
        componentRegistry.wireDependencies(this.keyDataConversion);
        componentRegistry.wireDependencies(this.valueDataConversion);
        if (this.f instanceof InjectableComponent) {
            ((InjectableComponent)((Object)this.f)).inject(componentRegistry);
        }
    }
}

