/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.read;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.read.AbstractDataCommand;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.util.Util;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.impl.InternalEntryFactory;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;

public final class GetCacheEntryCommand
extends AbstractDataCommand {
    public static final byte COMMAND_ID = 45;
    private InternalEntryFactory entryFactory;

    public GetCacheEntryCommand(Object key, int segment, long flagsBitSet, InternalEntryFactory entryFactory) {
        super(key, segment, flagsBitSet);
        this.entryFactory = entryFactory;
    }

    public GetCacheEntryCommand() {
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitGetCacheEntryCommand(ctx, this);
    }

    @Override
    public VisitableCommand.LoadType loadType() {
        return VisitableCommand.LoadType.OWNER;
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        CacheEntry entry = ctx.lookupEntry(this.key);
        if (entry.isNull() || entry.isRemoved()) {
            return null;
        }
        return this.entryFactory.copy(entry);
    }

    @Override
    public byte getCommandId() {
        return 45;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        output.writeObject(this.key);
        UnsignedNumeric.writeUnsignedInt(output, this.segment);
        output.writeLong(FlagBitSets.copyWithoutRemotableFlags(this.getFlagsBitSet()));
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.key = input.readObject();
        this.segment = UnsignedNumeric.readUnsignedInt(input);
        this.setFlagsBitSet(input.readLong());
    }

    @Override
    public String toString() {
        return "GetCacheEntryCommand {key=" + Util.toStr(this.key) + ", flags=" + this.printFlags() + "}";
    }
}

