/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.read;

import java.util.AbstractCollection;
import java.util.Map;
import java.util.Set;
import org.infinispan.Cache;
import org.infinispan.CacheSet;
import org.infinispan.CacheStream;
import org.infinispan.cache.impl.AbstractDelegatingCache;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.read.AbstractLocalCommand;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.commons.util.CloseableSpliterator;
import org.infinispan.commons.util.EnumUtil;
import org.infinispan.commons.util.IteratorMapper;
import org.infinispan.commons.util.SpliteratorMapper;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.impl.InternalDataContainer;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.stream.impl.local.LocalCacheStream;
import org.infinispan.stream.impl.local.SegmentedKeyStreamSupplier;
import org.infinispan.util.DataContainerRemoveIterator;

public class KeySetCommand<K, V>
extends AbstractLocalCommand
implements VisitableCommand {
    private final Cache<K, V> cache;
    private final InternalDataContainer<K, V> dataContainer;
    private final KeyPartitioner keyPartitioner;

    public KeySetCommand(Cache<K, V> cache, InternalDataContainer<K, V> dataContainer, KeyPartitioner keyPartitioner, long flagsBitSet) {
        this.setFlagsBitSet(flagsBitSet);
        cache = AbstractDelegatingCache.unwrapCache(cache);
        this.cache = flagsBitSet != 0L ? cache.getAdvancedCache().withFlags((Flag[])EnumUtil.enumArrayOf((long)flagsBitSet, Flag.class)) : cache;
        this.dataContainer = dataContainer;
        this.keyPartitioner = keyPartitioner;
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitKeySetCommand(ctx, this);
    }

    @Override
    public VisitableCommand.LoadType loadType() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<K> perform(InvocationContext ctx) throws Throwable {
        boolean isRemoteIteration = EnumUtil.containsAny(this.getFlagsBitSet(), FlagBitSets.REMOTE_ITERATION);
        return new BackingKeySet<K, V>(this.cache, this.dataContainer, this.keyPartitioner, isRemoteIteration);
    }

    public String toString() {
        return "KeySetCommand{cache=" + this.cache.getName() + ", flags=" + this.printFlags() + '}';
    }

    private static class BackingKeySet<K, V>
    extends AbstractCollection<K>
    implements CacheSet<K> {
        private final boolean isRemoteIteration;
        private final Cache<K, V> cache;
        private final InternalDataContainer<K, V> dataContainer;
        private final KeyPartitioner keyPartitioner;

        BackingKeySet(Cache<K, V> cache, InternalDataContainer<K, V> dataContainer, KeyPartitioner keyPartitioner, boolean isRemoteIteration) {
            this.cache = cache;
            this.dataContainer = dataContainer;
            this.keyPartitioner = keyPartitioner;
            this.isRemoteIteration = isRemoteIteration;
        }

        @Override
        public CloseableIterator<K> iterator() {
            if (this.isRemoteIteration) {
                return new IteratorMapper<InternalCacheEntry, Object>(this.dataContainer.iterator(), Map.Entry::getKey);
            }
            return new IteratorMapper<CacheEntry, Object>(new DataContainerRemoveIterator<K, V>(this.cache, this.dataContainer), Map.Entry::getKey);
        }

        @Override
        public CloseableSpliterator<K> spliterator() {
            return new SpliteratorMapper<InternalCacheEntry, Object>(this.dataContainer.spliterator(), Map.Entry::getKey);
        }

        @Override
        public int size() {
            return this.dataContainer.size();
        }

        @Override
        public boolean contains(Object o) {
            return this.dataContainer.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return this.cache.remove(o) != null;
        }

        private CacheStream<K> doStream(boolean parallel) {
            return new LocalCacheStream<K>(new SegmentedKeyStreamSupplier<K, V>(this.cache, this.keyPartitioner, this.dataContainer), parallel, this.cache.getAdvancedCache().getComponentRegistry());
        }

        @Override
        public CacheStream<K> stream() {
            return this.doStream(false);
        }

        @Override
        public CacheStream<K> parallelStream() {
            return this.doStream(true);
        }
    }
}

