/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.triangle;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Function;
import org.infinispan.commands.functional.AbstractWriteManyCommand;
import org.infinispan.commands.functional.ReadWriteManyCommand;
import org.infinispan.commands.functional.WriteOnlyManyCommand;
import org.infinispan.commands.triangle.FunctionalBackupWriteCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.context.InvocationContextFactory;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.interceptors.AsyncInterceptorChain;
import org.infinispan.util.ByteString;

public class MultiKeyFunctionalBackupWriteCommand
extends FunctionalBackupWriteCommand {
    public static final byte COMMAND_ID = 80;
    private boolean writeOnly;
    private Collection<?> keys;

    public MultiKeyFunctionalBackupWriteCommand() {
        super(null);
    }

    public MultiKeyFunctionalBackupWriteCommand(ByteString cacheName) {
        super(cacheName);
    }

    public void init(InvocationContextFactory factory, AsyncInterceptorChain chain, ComponentRegistry componentRegistry) {
        this.injectDependencies(factory, chain);
        this.componentRegistry = componentRegistry;
    }

    @Override
    public byte getCommandId() {
        return 80;
    }

    public <K, V> void setWriteOnly(WriteOnlyManyCommand<K, V> command, Collection<Object> keys) {
        this.setCommonAttributesFromCommand(command);
        this.setFunctionalCommand(command);
        this.writeOnly = true;
        this.keys = keys;
        this.function = command.getConsumer();
    }

    public <K, V, R> void setReadWrite(ReadWriteManyCommand<K, V, R> command, Collection<Object> keys) {
        this.setCommonAttributesFromCommand(command);
        this.setFunctionalCommand(command);
        this.writeOnly = false;
        this.keys = keys;
        this.function = command.getBiFunction();
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        this.writeBase(output);
        this.writeFunctionAndParams(output);
        output.writeBoolean(this.writeOnly);
        MarshallUtil.marshallCollection(this.keys, output);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.readBase(input);
        this.readFunctionAndParams(input);
        this.writeOnly = input.readBoolean();
        this.keys = MarshallUtil.unmarshallCollection(input, ArrayList::new);
    }

    @Override
    WriteCommand createWriteCommand() {
        AbstractWriteManyCommand cmd = this.writeOnly ? new WriteOnlyManyCommand(this.keys, (Consumer)this.function, this.params, this.getCommandInvocationId(), this.keyDataConversion, this.valueDataConversion, this.componentRegistry) : new ReadWriteManyCommand(this.keys, (Function)this.function, this.params, this.getCommandInvocationId(), this.keyDataConversion, this.valueDataConversion, this.componentRegistry);
        cmd.setForwarded(true);
        return cmd;
    }
}

