/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.triangle;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.infinispan.commands.triangle.BackupWriteCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.context.InvocationContextFactory;
import org.infinispan.interceptors.AsyncInterceptorChain;
import org.infinispan.metadata.Metadata;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.util.ByteString;
import org.infinispan.util.TriangleFunctionsUtil;

public class PutMapBackupWriteCommand
extends BackupWriteCommand {
    public static final byte COMMAND_ID = 78;
    private Map<Object, Object> map;
    private Metadata metadata;
    private CacheNotifier cacheNotifier;

    public PutMapBackupWriteCommand() {
        super(null);
    }

    public PutMapBackupWriteCommand(ByteString cacheName) {
        super(cacheName);
    }

    public void init(InvocationContextFactory factory, AsyncInterceptorChain chain, CacheNotifier cacheNotifier) {
        this.injectDependencies(factory, chain);
        this.cacheNotifier = cacheNotifier;
    }

    @Override
    public byte getCommandId() {
        return 78;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        this.writeBase(output);
        MarshallUtil.marshallMap(this.map, output);
        output.writeObject(this.metadata);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.readBase(input);
        this.map = MarshallUtil.unmarshallMap(input, HashMap::new);
        this.metadata = (Metadata)input.readObject();
    }

    public void setPutMapCommand(PutMapCommand command, Collection<Object> keys) {
        this.setCommonAttributesFromCommand(command);
        this.map = TriangleFunctionsUtil.filterEntries(command.getMap(), keys);
        this.metadata = command.getMetadata();
    }

    @Override
    public String toString() {
        return "PutMapBackupWriteCommand{" + this.toStringFields() + '}';
    }

    @Override
    WriteCommand createWriteCommand() {
        PutMapCommand cmd = new PutMapCommand(this.map, this.cacheNotifier, this.metadata, this.getFlags(), this.getCommandInvocationId());
        cmd.setForwarded(true);
        return cmd;
    }

    @Override
    String toStringFields() {
        return super.toStringFields() + ", map=" + this.map + ", metadata=" + this.metadata;
    }
}

