/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.write;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Objects;
import org.infinispan.commands.CommandInvocationId;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ValueMatcher;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.Util;
import org.infinispan.container.entries.ExpiryHelper;
import org.infinispan.container.entries.MVCCEntry;
import org.infinispan.container.versioning.IncrementableEntryVersion;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.metadata.Metadata;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class RemoveExpiredCommand
extends RemoveCommand {
    public static final int COMMAND_ID = 58;
    private static final Log log = LogFactory.getLog(RemoveExpiredCommand.class);
    private static final boolean trace = log.isTraceEnabled();
    private static final int CLOCK_BUFFER = 100;
    private boolean maxIdle;
    private Long lifespan;
    private IncrementableEntryVersion nonExistentVersion;
    private TimeService timeService;

    public RemoveExpiredCommand() {
        this.valueMatcher = ValueMatcher.MATCH_EXPECTED_OR_NULL;
    }

    public RemoveExpiredCommand(Object key, Object value, Long lifespan, boolean maxIdle, CacheNotifier notifier, int segment, long flagBitSet, CommandInvocationId commandInvocationId, IncrementableEntryVersion nonExistentVersion, TimeService timeService) {
        super(key, value, notifier, segment, flagBitSet, commandInvocationId);
        this.lifespan = lifespan;
        this.maxIdle = maxIdle;
        this.valueMatcher = ValueMatcher.MATCH_EXPECTED_OR_NULL;
        this.nonExistentVersion = nonExistentVersion;
        this.timeService = timeService;
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitRemoveExpiredCommand(ctx, this);
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        MVCCEntry e = (MVCCEntry)ctx.lookupEntry(this.key);
        if (e != null && !e.isRemoved()) {
            Object prevValue = e.getValue();
            Metadata metadata = e.getMetadata();
            if (this.lifespan == null) {
                if (this.valueMatcher.matches(prevValue, this.value, null)) {
                    e.setExpired(true);
                    return this.performRemove(e, prevValue, ctx);
                }
            } else if (metadata == null || metadata.version() == this.nonExistentVersion) {
                if (this.value == null || this.valueMatcher.matches(prevValue, this.value, null)) {
                    e.setExpired(true);
                    return this.performRemove(e, prevValue, ctx);
                }
            } else if (e.getLifespan() > 0L && e.getLifespan() == this.lifespan.longValue()) {
                if (this.valueMatcher.matches(prevValue, this.value, null)) {
                    if (ExpiryHelper.isExpiredMortal(this.lifespan, e.getCreated(), this.timeService.wallClockTime() + 100L)) {
                        if (trace) {
                            log.tracef("Removing entry as its lifespan and value match and it created on %s with a current time of %s", e.getCreated(), this.timeService.wallClockTime());
                        }
                        e.setExpired(true);
                        return this.performRemove(e, prevValue, ctx);
                    }
                    if (trace) {
                        log.tracef("Cannot remove entry due to it not being expired - this can be caused by different clocks on nodes or a concurrent write", new Object[0]);
                    }
                }
            } else if (trace) {
                log.trace("Cannot remove entry as its lifespan or value do not match");
            }
        } else if (trace) {
            log.trace("Nothing to remove since the entry doesn't exist in the context or it is already removed");
        }
        this.successful = false;
        return false;
    }

    @Override
    public boolean isConditional() {
        return true;
    }

    @Override
    public void notify(InvocationContext ctx, Object removedValue, Metadata removedMetadata, boolean isPre) {
        if (!isPre) {
            this.notifier.notifyCacheEntryExpired(this.key, this.value, removedMetadata, ctx);
        }
    }

    @Override
    public byte getCommandId() {
        return 58;
    }

    @Override
    public String toString() {
        return "RemoveExpiredCommand{key=" + Util.toStr(this.key) + ", value=" + Util.toStr(this.value) + ", lifespan=" + this.lifespan + ", maxIde=" + this.maxIdle + '}';
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        CommandInvocationId.writeTo(output, this.commandInvocationId);
        output.writeObject(this.key);
        output.writeObject(this.value);
        UnsignedNumeric.writeUnsignedInt(output, this.segment);
        if (this.lifespan != null) {
            output.writeBoolean(true);
            output.writeLong(this.lifespan);
        } else {
            output.writeBoolean(false);
        }
        output.writeBoolean(this.maxIdle);
        output.writeLong(FlagBitSets.copyWithoutRemotableFlags(this.getFlagsBitSet()));
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.commandInvocationId = CommandInvocationId.readFrom(input);
        this.key = input.readObject();
        this.value = input.readObject();
        this.segment = UnsignedNumeric.readUnsignedInt(input);
        boolean lifespanProvided = input.readBoolean();
        this.lifespan = lifespanProvided ? Long.valueOf(input.readLong()) : null;
        this.maxIdle = input.readBoolean();
        this.setFlagsBitSet(input.readLong());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RemoveExpiredCommand that = (RemoveExpiredCommand)o;
        return this.maxIdle == that.maxIdle && Objects.equals(this.lifespan, that.lifespan);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.lifespan, this.maxIdle);
    }

    public boolean isMaxIdle() {
        return this.maxIdle;
    }

    public void init(CacheNotifier notifier, IncrementableEntryVersion nonExistentVersion, TimeService timeService) {
        super.init(notifier);
        this.nonExistentVersion = nonExistentVersion;
        this.timeService = timeService;
    }
}

