/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.write;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.infinispan.commands.CommandInvocationId;
import org.infinispan.commands.MetadataAwareCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.write.AbstractDataWriteCommand;
import org.infinispan.commands.write.ValueMatcher;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.util.Util;
import org.infinispan.container.entries.MVCCEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.metadata.Metadata;
import org.infinispan.metadata.Metadatas;
import org.infinispan.notifications.cachelistener.CacheNotifier;

public class ReplaceCommand
extends AbstractDataWriteCommand
implements MetadataAwareCommand {
    public static final byte COMMAND_ID = 11;
    private Object oldValue;
    private Object newValue;
    private Metadata metadata;
    private CacheNotifier<Object, Object> notifier;
    private boolean successful = true;
    private ValueMatcher valueMatcher;

    public ReplaceCommand() {
    }

    public ReplaceCommand(Object key, Object oldValue, Object newValue, CacheNotifier notifier, Metadata metadata, int segment, long flagsBitSet, CommandInvocationId commandInvocationId) {
        super(key, segment, flagsBitSet, commandInvocationId);
        this.oldValue = oldValue;
        this.newValue = newValue;
        this.notifier = notifier;
        this.metadata = metadata;
        this.valueMatcher = oldValue != null ? ValueMatcher.MATCH_EXPECTED : ValueMatcher.MATCH_NON_NULL;
    }

    public void init(CacheNotifier notifier) {
        this.notifier = notifier;
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitReplaceCommand(ctx, this);
    }

    @Override
    public VisitableCommand.LoadType loadType() {
        return VisitableCommand.LoadType.PRIMARY;
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        if (this.valueMatcher == ValueMatcher.MATCH_NEVER) {
            this.successful = false;
            return null;
        }
        MVCCEntry e = (MVCCEntry)ctx.lookupEntry(this.key);
        Object prevValue = e.getValue();
        if (this.valueMatcher.matches(prevValue, this.oldValue, this.newValue)) {
            e.setChanged(true);
            Object old = e.setValue(this.newValue);
            Metadatas.updateMetadata(e, this.metadata);
            if (this.valueMatcher != ValueMatcher.MATCH_EXPECTED_OR_NEW) {
                return this.returnValue(old, e.getMetadata(), true, ctx);
            }
            return this.returnValue(this.oldValue, e.getMetadata(), true, ctx);
        }
        return this.returnValue(null, null, false, ctx);
    }

    private Object returnValue(Object beingReplaced, Metadata previousMetadata, boolean successful, InvocationContext ctx) {
        Object previousValue;
        this.successful = successful;
        Object object = previousValue = this.oldValue == null ? beingReplaced : this.oldValue;
        if (successful) {
            this.notifier.notifyCacheEntryModified(this.key, this.newValue, this.metadata, previousValue, previousMetadata, true, ctx, this);
        }
        if (this.oldValue == null) {
            return beingReplaced;
        }
        return successful;
    }

    @Override
    public byte getCommandId() {
        return 11;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        output.writeObject(this.key);
        output.writeObject(this.oldValue);
        output.writeObject(this.newValue);
        UnsignedNumeric.writeUnsignedInt(output, this.segment);
        output.writeObject(this.metadata);
        MarshallUtil.marshallEnum(this.valueMatcher, output);
        output.writeLong(FlagBitSets.copyWithoutRemotableFlags(this.getFlagsBitSet()));
        CommandInvocationId.writeTo(output, this.commandInvocationId);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.key = input.readObject();
        this.oldValue = input.readObject();
        this.newValue = input.readObject();
        this.segment = UnsignedNumeric.readUnsignedInt(input);
        this.metadata = (Metadata)input.readObject();
        this.valueMatcher = MarshallUtil.unmarshallEnum(input, ValueMatcher::valueOf);
        this.setFlagsBitSet(input.readLong());
        this.commandInvocationId = CommandInvocationId.readFrom(input);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ReplaceCommand that = (ReplaceCommand)o;
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.newValue != null ? !this.newValue.equals(that.newValue) : that.newValue != null) {
            return false;
        }
        return this.oldValue != null ? this.oldValue.equals(that.oldValue) : that.oldValue == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.oldValue != null ? this.oldValue.hashCode() : 0);
        result = 31 * result + (this.newValue != null ? this.newValue.hashCode() : 0);
        result = 31 * result + (this.metadata != null ? this.metadata.hashCode() : 0);
        return result;
    }

    @Override
    public boolean isSuccessful() {
        return this.successful;
    }

    @Override
    public boolean isConditional() {
        return true;
    }

    @Override
    public Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    public Object getOldValue() {
        return this.oldValue;
    }

    public void setOldValue(Object oldValue) {
        this.oldValue = oldValue;
    }

    public Object getNewValue() {
        return this.newValue;
    }

    public void setNewValue(Object newValue) {
        this.newValue = newValue;
    }

    @Override
    public ValueMatcher getValueMatcher() {
        return this.valueMatcher;
    }

    @Override
    public void setValueMatcher(ValueMatcher valueMatcher) {
        this.valueMatcher = valueMatcher;
    }

    @Override
    public void fail() {
        this.successful = false;
    }

    @Override
    public final boolean isReturnValueExpected() {
        return true;
    }

    @Override
    public String toString() {
        return "ReplaceCommand{key=" + Util.toStr(this.key) + ", oldValue=" + Util.toStr(this.oldValue) + ", newValue=" + Util.toStr(this.newValue) + ", metadata=" + this.metadata + ", flags=" + this.printFlags() + ", commandInvocationId=" + CommandInvocationId.show(this.commandInvocationId) + ", successful=" + this.successful + ", valueMatcher=" + (Object)((Object)this.valueMatcher) + ", topologyId=" + this.getTopologyId() + '}';
    }
}

