/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.jmx;

import java.util.Properties;
import java.util.Set;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.jmx.MBeanServerLookup;
import org.infinispan.commons.jmx.SecurityActions;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.logging.LogFactory;

public class JmxUtil {
    private static final Log log = LogFactory.getLog(JmxUtil.class);
    private static final boolean trace = log.isTraceEnabled();

    public static MBeanServer lookupMBeanServer(MBeanServerLookup lookup, Properties properties) {
        return lookup.getMBeanServer(properties);
    }

    public static String buildJmxDomain(String domain, MBeanServer mBeanServer, String groupName) {
        return JmxUtil.findJmxDomain(domain, mBeanServer, groupName);
    }

    public static void registerMBean(Object mbean, ObjectName objectName, MBeanServer mBeanServer) throws Exception {
        if (!mBeanServer.isRegistered(objectName)) {
            try {
                SecurityActions.registerMBean(mbean, objectName, mBeanServer);
                log.tracef("Registered %s under %s", mbean, (Object)objectName);
            }
            catch (InstanceAlreadyExistsException e) {
                log.couldNotRegisterObjectName(objectName, e);
            }
        } else {
            log.debugf("Object name %s already registered", (Object)objectName);
        }
    }

    public static void unregisterMBean(ObjectName objectName, MBeanServer mBeanServer) throws Exception {
        if (mBeanServer.isRegistered(objectName)) {
            SecurityActions.unregisterMBean(objectName, mBeanServer);
            log.tracef("Unregistered %s", (Object)objectName);
        }
    }

    public static int unregisterMBeans(String filter, MBeanServer mBeanServer) {
        try {
            ObjectName filterObjName = new ObjectName(filter);
            Set<ObjectInstance> mbeans = mBeanServer.queryMBeans(filterObjName, null);
            for (ObjectInstance mbean : mbeans) {
                ObjectName name = mbean.getObjectName();
                if (trace) {
                    log.trace("Unregistering mbean with name: " + name);
                }
                SecurityActions.unregisterMBean(name, mBeanServer);
            }
            return mbeans.size();
        }
        catch (Exception e) {
            throw new CacheException("Unable to register mbeans with filter=" + filter, e);
        }
    }

    private static String findJmxDomain(String jmxDomain, MBeanServer mBeanServer, String groupName) {
        int index = 2;
        String finalName = jmxDomain;
        boolean done = false;
        while (!done) {
            done = true;
            try {
                ObjectName targetName = new ObjectName(finalName + ':' + groupName + ",*");
                if (SecurityActions.queryNames(targetName, null, mBeanServer).size() <= 0) continue;
                finalName = jmxDomain + index++;
                done = false;
            }
            catch (MalformedObjectNameException e) {
                throw new CacheException("Unable to check for duplicate names", e);
            }
        }
        return finalName;
    }
}

