/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.Properties;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.configuration.cache.AsyncStoreConfiguration;
import org.infinispan.configuration.cache.SingletonStoreConfiguration;
import org.infinispan.configuration.cache.StoreConfiguration;

public class AbstractStoreConfiguration
implements StoreConfiguration {
    public static final AttributeDefinition<Boolean> FETCH_PERSISTENT_STATE = AttributeDefinition.builder("fetchPersistentState", false).xmlName("fetch-state").immutable().build();
    public static final AttributeDefinition<Boolean> PURGE_ON_STARTUP = AttributeDefinition.builder("purgeOnStartup", false).immutable().xmlName("purge").build();
    public static final AttributeDefinition<Boolean> IGNORE_MODIFICATIONS = AttributeDefinition.builder("ignoreModifications", false).immutable().xmlName("read-only").build();
    public static final AttributeDefinition<Boolean> PRELOAD = AttributeDefinition.builder("preload", false).immutable().build();
    public static final AttributeDefinition<Boolean> SHARED = AttributeDefinition.builder("shared", false).immutable().build();
    public static final AttributeDefinition<Boolean> TRANSACTIONAL = AttributeDefinition.builder("transactional", false).immutable().build();
    public static final AttributeDefinition<Integer> MAX_BATCH_SIZE = AttributeDefinition.builder("maxBatchSize", 100).immutable().build();
    public static final AttributeDefinition<Boolean> SEGMENTED = AttributeDefinition.builder("segmented", false).immutable().build();
    public static final AttributeDefinition<TypedProperties> PROPERTIES = AttributeDefinition.builder("properties", null, TypedProperties.class).initializer(() -> new TypedProperties()).autoPersist(false).immutable().build();
    private final Attribute<Boolean> fetchPersistentState;
    private final Attribute<Boolean> purgeOnStartup;
    private final Attribute<Boolean> ignoreModifications;
    private final Attribute<Boolean> preload;
    private final Attribute<Boolean> shared;
    private final Attribute<Boolean> transactional;
    private final Attribute<Integer> maxBatchSize;
    private final Attribute<Boolean> segmented;
    private final Attribute<TypedProperties> properties;
    protected final AttributeSet attributes;
    private final AsyncStoreConfiguration async;
    private final SingletonStoreConfiguration singletonStore;

    public static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(AbstractStoreConfiguration.class, FETCH_PERSISTENT_STATE, PURGE_ON_STARTUP, IGNORE_MODIFICATIONS, PRELOAD, SHARED, TRANSACTIONAL, MAX_BATCH_SIZE, SEGMENTED, PROPERTIES);
    }

    @Deprecated
    public AbstractStoreConfiguration(boolean purgeOnStartup, boolean fetchPersistentState, boolean ignoreModifications, AsyncStoreConfiguration async, SingletonStoreConfiguration singletonStore, boolean preload, boolean shared, Properties properties) {
        this.attributes = AbstractStoreConfiguration.attributeDefinitionSet();
        this.attributes.attribute(PURGE_ON_STARTUP).set(purgeOnStartup);
        this.attributes.attribute(FETCH_PERSISTENT_STATE).set(fetchPersistentState);
        this.attributes.attribute(IGNORE_MODIFICATIONS).set(ignoreModifications);
        this.attributes.attribute(PRELOAD).set(preload);
        this.attributes.attribute(SHARED).set(shared);
        this.attributes.attribute(TRANSACTIONAL).set(false);
        this.attributes.attribute(SEGMENTED).set(false);
        this.attributes.attribute(PROPERTIES).set(TypedProperties.toTypedProperties(properties));
        this.async = async;
        this.singletonStore = singletonStore;
        this.fetchPersistentState = this.attributes.attribute(FETCH_PERSISTENT_STATE);
        this.purgeOnStartup = this.attributes.attribute(PURGE_ON_STARTUP);
        this.ignoreModifications = this.attributes.attribute(IGNORE_MODIFICATIONS);
        this.preload = this.attributes.attribute(PRELOAD);
        this.shared = this.attributes.attribute(SHARED);
        this.transactional = this.attributes.attribute(TRANSACTIONAL);
        this.maxBatchSize = this.attributes.attribute(MAX_BATCH_SIZE);
        this.segmented = this.attributes.attribute(SEGMENTED);
        this.properties = this.attributes.attribute(PROPERTIES);
    }

    public AbstractStoreConfiguration(AttributeSet attributes, AsyncStoreConfiguration async, SingletonStoreConfiguration singletonStore) {
        this.attributes = attributes.checkProtection();
        this.async = async;
        this.singletonStore = singletonStore;
        this.fetchPersistentState = attributes.attribute(FETCH_PERSISTENT_STATE);
        this.purgeOnStartup = attributes.attribute(PURGE_ON_STARTUP);
        this.ignoreModifications = attributes.attribute(IGNORE_MODIFICATIONS);
        this.preload = attributes.attribute(PRELOAD);
        this.shared = attributes.attribute(SHARED);
        this.transactional = attributes.attribute(TRANSACTIONAL);
        this.maxBatchSize = attributes.attribute(MAX_BATCH_SIZE);
        this.segmented = attributes.attribute(SEGMENTED);
        this.properties = attributes.attribute(PROPERTIES);
    }

    @Override
    public AsyncStoreConfiguration async() {
        return this.async;
    }

    @Override
    public SingletonStoreConfiguration singletonStore() {
        return this.singletonStore;
    }

    @Override
    public boolean purgeOnStartup() {
        return this.purgeOnStartup.get();
    }

    @Override
    public boolean shared() {
        return this.shared.get();
    }

    @Override
    public boolean transactional() {
        return this.transactional.get();
    }

    @Override
    public int maxBatchSize() {
        return this.maxBatchSize.get();
    }

    @Override
    public boolean segmented() {
        return this.segmented.get();
    }

    @Override
    public boolean fetchPersistentState() {
        return this.fetchPersistentState.get();
    }

    @Override
    public boolean ignoreModifications() {
        return this.ignoreModifications.get();
    }

    @Override
    public boolean preload() {
        return this.preload.get();
    }

    @Override
    public Properties properties() {
        return this.properties.get();
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public String toString() {
        return "AbstractStoreConfiguration [attributes=" + this.attributes + ", async=" + this.async + ", singletonStore=" + this.singletonStore + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.async == null ? 0 : this.async.hashCode());
        result = 31 * result + (this.attributes == null ? 0 : this.attributes.hashCode());
        result = 31 * result + (this.singletonStore == null ? 0 : this.singletonStore.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractStoreConfiguration other = (AbstractStoreConfiguration)obj;
        if (this.async == null ? other.async != null : !this.async.equals(other.async)) {
            return false;
        }
        if (this.attributes == null ? other.attributes != null : !this.attributes.equals(other.attributes)) {
            return false;
        }
        return !(this.singletonStore == null ? other.singletonStore != null : !this.singletonStore.equals(other.singletonStore));
    }
}

