/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.dataconversion.MediaType;

public class ContentTypeConfiguration {
    public static final String DEFAULT_MEDIA_TYPE = "application/x-java-object";
    public static final AttributeDefinition<String> MEDIA_TYPE = AttributeDefinition.builder("media-type", null, String.class).build();
    private final Attribute<String> mediaType;
    private final AttributeSet attributes;

    ContentTypeConfiguration(AttributeSet attributes) {
        this.attributes = attributes.checkProtection();
        this.mediaType = attributes.attribute(MEDIA_TYPE);
    }

    public static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(ContentTypeConfiguration.class, MEDIA_TYPE);
    }

    public MediaType mediaType() {
        if (this.mediaType.isNull()) {
            return null;
        }
        return MediaType.fromString(this.mediaType.get());
    }

    public void mediaType(MediaType mediaType) {
        this.attributes.attribute(MEDIA_TYPE).set(mediaType.toString());
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public boolean isMediaTypeChanged() {
        return this.attributes.attribute(MEDIA_TYPE).isModified();
    }

    public boolean isEncodingChanged() {
        return this.attributes.attribute(MEDIA_TYPE).isModified();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ContentTypeConfiguration other = (ContentTypeConfiguration)obj;
        return !(this.attributes == null ? other.attributes != null : !this.attributes.equals(other.attributes));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attributes == null ? 0 : this.attributes.hashCode());
        return result;
    }

    public String toString() {
        return "ContentTypeConfiguration [attributes=" + this.attributes + "]";
    }
}

