/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import org.infinispan.commons.configuration.Builder;
import org.infinispan.configuration.cache.AbstractConfigurationChildBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.ContentTypeConfiguration;
import org.infinispan.configuration.cache.ContentTypeConfigurationBuilder;
import org.infinispan.configuration.cache.EncodingConfiguration;
import org.infinispan.configuration.global.GlobalConfiguration;

public class EncodingConfigurationBuilder
extends AbstractConfigurationChildBuilder
implements Builder<EncodingConfiguration> {
    private ContentTypeConfigurationBuilder keyContentTypeBuilder = new ContentTypeConfigurationBuilder(this);
    private ContentTypeConfigurationBuilder valueContentTypeBuilder = new ContentTypeConfigurationBuilder(this);

    EncodingConfigurationBuilder(ConfigurationBuilder builder) {
        super(builder);
    }

    @Override
    public void validate() {
        this.keyContentTypeBuilder.validate();
        this.valueContentTypeBuilder.validate();
    }

    public ContentTypeConfigurationBuilder key() {
        return this.keyContentTypeBuilder;
    }

    public ContentTypeConfigurationBuilder value() {
        return this.valueContentTypeBuilder;
    }

    @Override
    public EncodingConfiguration create() {
        ContentTypeConfiguration keyContentType = this.keyContentTypeBuilder.create();
        ContentTypeConfiguration valueContentType = this.valueContentTypeBuilder.create();
        return new EncodingConfiguration(keyContentType, valueContentType);
    }

    @Override
    public Builder<?> read(EncodingConfiguration template) {
        this.keyContentTypeBuilder = new ContentTypeConfigurationBuilder(this).read(template.keyDataType());
        this.valueContentTypeBuilder = new ContentTypeConfigurationBuilder(this).read(template.valueDataType());
        return this;
    }

    @Override
    public void validate(GlobalConfiguration globalConfig) {
        this.keyContentTypeBuilder.validate();
        this.valueContentTypeBuilder.validate();
    }

    public String toString() {
        return "DataTypeConfigurationBuilder{keyContentTypeBuilder=" + this.keyContentTypeBuilder + ", valueContentTypeBuilder=" + this.valueContentTypeBuilder + '}';
    }
}

