/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.concurrent.TimeUnit;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.Matchable;
import org.infinispan.util.concurrent.IsolationLevel;

public class LockingConfiguration
implements Matchable<LockingConfiguration> {
    public static final AttributeDefinition<Integer> CONCURRENCY_LEVEL = AttributeDefinition.builder("concurrencyLevel", 32).immutable().build();
    public static final AttributeDefinition<IsolationLevel> ISOLATION_LEVEL = AttributeDefinition.builder("isolationLevel", IsolationLevel.REPEATABLE_READ).xmlName("isolation").immutable().build();
    public static final AttributeDefinition<Long> LOCK_ACQUISITION_TIMEOUT = AttributeDefinition.builder("lockAcquisitionTimeout", TimeUnit.SECONDS.toMillis(10L)).xmlName("acquire-timeout").build();
    public static final AttributeDefinition<Boolean> USE_LOCK_STRIPING = AttributeDefinition.builder("striping", false).immutable().build();
    public static final AttributeDefinition<Boolean> WRITE_SKEW_CHECK = AttributeDefinition.builder("writeSkewCheck", true).xmlName("write-skew").immutable().build();
    private final Attribute<Integer> concurrencyLevel;
    private final Attribute<IsolationLevel> isolationLevel;
    private final Attribute<Long> lockAcquisitionTimeout;
    private final Attribute<Boolean> useLockStriping;
    private final AttributeSet attributes;

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(LockingConfiguration.class, CONCURRENCY_LEVEL, ISOLATION_LEVEL, LOCK_ACQUISITION_TIMEOUT, USE_LOCK_STRIPING, WRITE_SKEW_CHECK);
    }

    LockingConfiguration(AttributeSet attributes) {
        attributes.checkProtection();
        this.attributes = attributes;
        this.concurrencyLevel = attributes.attribute(CONCURRENCY_LEVEL);
        this.isolationLevel = attributes.attribute(ISOLATION_LEVEL);
        this.lockAcquisitionTimeout = attributes.attribute(LOCK_ACQUISITION_TIMEOUT);
        this.useLockStriping = attributes.attribute(USE_LOCK_STRIPING);
    }

    public int concurrencyLevel() {
        return this.concurrencyLevel.get();
    }

    @Deprecated
    public boolean supportsConcurrentUpdates() {
        return true;
    }

    public IsolationLevel isolationLevel() {
        return this.isolationLevel.get();
    }

    public long lockAcquisitionTimeout() {
        return this.lockAcquisitionTimeout.get();
    }

    public LockingConfiguration lockAcquisitionTimeout(long timeout) {
        this.lockAcquisitionTimeout.set(timeout);
        return this;
    }

    public boolean useLockStriping() {
        return this.useLockStriping.get();
    }

    @Deprecated
    public boolean writeSkewCheck() {
        return true;
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public String toString() {
        return "LockingConfiguration [attributes=" + this.attributes + "]";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LockingConfiguration other = (LockingConfiguration)obj;
        return !(this.attributes == null ? other.attributes != null : !this.attributes.equals(other.attributes));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attributes == null ? 0 : this.attributes.hashCode());
        return result;
    }
}

