/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.global;

import java.util.function.Supplier;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.global.SecurityActions;
import org.infinispan.globalstate.ConfigurationStorage;
import org.infinispan.globalstate.LocalConfigurationStorage;

public class GlobalStateConfiguration {
    public static final AttributeDefinition<Boolean> ENABLED = AttributeDefinition.builder("enabled", false).immutable().build();
    public static final AttributeDefinition<String> PERSISTENT_LOCATION = AttributeDefinition.builder("persistentLocation", null, String.class).initializer(() -> SecurityActions.getSystemProperty("user.dir")).immutable().build();
    public static final AttributeDefinition<String> SHARED_PERSISTENT_LOCATION = AttributeDefinition.builder("sharedPersistentLocation", null, String.class).initializer(() -> SecurityActions.getSystemProperty("user.dir")).immutable().build();
    public static final AttributeDefinition<String> TEMPORARY_LOCATION = AttributeDefinition.builder("temporaryLocation", null, String.class).initializer(() -> SecurityActions.getSystemProperty("java.io.tmpdir")).immutable().build();
    public static final AttributeDefinition<ConfigurationStorage> CONFIGURATION_STORAGE = AttributeDefinition.builder("configurationStorage", ConfigurationStorage.VOLATILE, ConfigurationStorage.class).autoPersist(false).immutable().build();
    public static final AttributeDefinition<Supplier<? extends LocalConfigurationStorage>> CONFIGURATION_STORAGE_SUPPLIER = AttributeDefinition.supplierBuilder("configurationStorageSupplier", LocalConfigurationStorage.class).autoPersist(false).immutable().build();
    private final AttributeSet attributes;
    private final Attribute<Boolean> enabled;
    private final Attribute<String> persistentLocation;
    private Attribute<String> sharedPersistentLocation;
    private final Attribute<String> temporaryLocation;
    private final Attribute<ConfigurationStorage> configurationStorage;
    private final Attribute<Supplier<? extends LocalConfigurationStorage>> configurationStorageSupplier;

    public static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(GlobalStateConfiguration.class, ENABLED, PERSISTENT_LOCATION, SHARED_PERSISTENT_LOCATION, TEMPORARY_LOCATION, CONFIGURATION_STORAGE, CONFIGURATION_STORAGE_SUPPLIER);
    }

    public GlobalStateConfiguration(AttributeSet attributes) {
        this.attributes = attributes.checkProtection();
        this.enabled = attributes.attribute(ENABLED);
        this.persistentLocation = attributes.attribute(PERSISTENT_LOCATION);
        this.sharedPersistentLocation = attributes.attribute(SHARED_PERSISTENT_LOCATION);
        this.temporaryLocation = attributes.attribute(TEMPORARY_LOCATION);
        this.configurationStorage = attributes.attribute(CONFIGURATION_STORAGE);
        this.configurationStorageSupplier = attributes.attribute(CONFIGURATION_STORAGE_SUPPLIER);
    }

    public boolean enabled() {
        return this.enabled.get();
    }

    public String persistentLocation() {
        return this.persistentLocation.get();
    }

    public String sharedPersistentLocation() {
        return this.sharedPersistentLocation.get();
    }

    public String temporaryLocation() {
        return this.temporaryLocation.get();
    }

    public ConfigurationStorage configurationStorage() {
        return this.configurationStorage.get();
    }

    public Supplier<? extends LocalConfigurationStorage> configurationStorageClass() {
        return this.configurationStorageSupplier.get();
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public String toString() {
        return "GlobalStateConfiguration [attributes=" + this.attributes + "]";
    }
}

