/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.serializing;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.configuration.cache.AbstractStoreConfiguration;
import org.infinispan.configuration.cache.AsyncStoreConfiguration;
import org.infinispan.configuration.cache.SingletonStoreConfiguration;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.configuration.parsing.Attribute;
import org.infinispan.configuration.parsing.Element;
import org.infinispan.configuration.serializing.SerializeUtils;
import org.infinispan.configuration.serializing.XMLExtendedStreamWriter;

public abstract class AbstractStoreSerializer {
    protected void writeCommonStoreSubAttributes(XMLExtendedStreamWriter writer, AbstractStoreConfiguration configuration) throws XMLStreamException {
        configuration.singletonStore().attributes().write((XMLStreamWriter)writer, SingletonStoreConfiguration.ENABLED, Attribute.SINGLETON);
    }

    protected void writeCommonStoreElements(XMLExtendedStreamWriter writer, StoreConfiguration configuration) throws XMLStreamException {
        if (configuration.async().enabled()) {
            this.writeStoreWriteBehind(writer, configuration);
        }
        SerializeUtils.writeTypedProperties(writer, TypedProperties.toTypedProperties(configuration.properties()));
    }

    private void writeStoreWriteBehind(XMLExtendedStreamWriter writer, StoreConfiguration configuration) throws XMLStreamException {
        AttributeSet writeBehind = configuration.async().attributes();
        if (writeBehind.isModified()) {
            writer.writeStartElement(Element.WRITE_BEHIND);
            writeBehind.write((XMLStreamWriter)writer, AsyncStoreConfiguration.MODIFICATION_QUEUE_SIZE, Attribute.MODIFICATION_QUEUE_SIZE);
            writeBehind.write((XMLStreamWriter)writer, AsyncStoreConfiguration.THREAD_POOL_SIZE, Attribute.THREAD_POOL_SIZE);
            writeBehind.write((XMLStreamWriter)writer, AsyncStoreConfiguration.FAIL_SILENTLY, Attribute.FAIL_SILENTLY);
            writer.writeEndElement();
        }
    }
}

