/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.offheap;

import java.util.stream.LongStream;
import org.infinispan.commons.util.Util;
import org.infinispan.container.offheap.OffHeapMemory;
import org.infinispan.container.offheap.OffHeapMemoryAllocator;
import org.infinispan.container.offheap.OffsetCalculator;
import org.infinispan.container.offheap.UnsafeHolder;
import sun.misc.Unsafe;

public class MemoryAddressHash {
    private static final Unsafe UNSAFE = UnsafeHolder.UNSAFE;
    private static final OffHeapMemory MEMORY = OffHeapMemory.INSTANCE;
    private final long memory;
    private final int pointerCount;
    private final OffsetCalculator offSetCalculator;
    private final OffHeapMemoryAllocator allocator;

    public MemoryAddressHash(int pointers, OffsetCalculator offSetCalculator, OffHeapMemoryAllocator allocator) {
        this.pointerCount = Util.findNextHighestPowerOfTwo(pointers);
        long bytes = (long)this.pointerCount << 3;
        this.offSetCalculator = offSetCalculator;
        this.allocator = allocator;
        this.memory = allocator.allocate(bytes);
        UNSAFE.setMemory(this.memory, bytes, (byte)0);
    }

    private long findOffset(Object instance) {
        return this.offSetCalculator.calculateOffset(instance);
    }

    public void putMemoryAddress(Object instance, long address) {
        long offset = this.findOffset(instance);
        MEMORY.putLong(this.memory, offset << 3, address);
    }

    public long getMemoryAddress(Object instance) {
        return MEMORY.getLong(this.memory, this.findOffset(instance) << 3);
    }

    public long getMemoryAddressOffset(int offset) {
        return MEMORY.getLong(this.memory, (long)offset << 3);
    }

    public long getMemoryAddressOffsetNoTraceIfAbsent(int offset) {
        return MEMORY.getLongNoTraceIfAbsent(this.memory, (long)offset << 3);
    }

    public void deallocate() {
        this.allocator.deallocate(this.memory, this.pointerCount << 3);
    }

    public LongStream toStream() {
        return LongStream.iterate(this.memory, l -> l + 8L).limit(this.pointerCount).map(UNSAFE::getLong).filter(l -> l != 0L);
    }

    public LongStream toStreamRemoved() {
        return LongStream.iterate(this.memory, l -> l + 8L).limit(this.pointerCount).map(l -> UNSAFE.getAndSetLong(null, l, 0L)).filter(l -> l != 0L);
    }
}

