/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.offheap;

import java.lang.invoke.MethodHandles;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.infinispan.commons.api.Lifecycle;
import org.infinispan.commons.marshall.WrappedBytes;
import org.infinispan.commons.util.PeekableMap;
import org.infinispan.commons.util.ProcessorInfo;
import org.infinispan.commons.util.Util;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.offheap.MemoryAddressHash;
import org.infinispan.container.offheap.ModulusOffsetCalculator;
import org.infinispan.container.offheap.OffHeapEntryFactory;
import org.infinispan.container.offheap.OffHeapMemoryAllocator;
import org.infinispan.container.offheap.OffsetCalculator;
import org.infinispan.container.offheap.StripedLock;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class OffHeapConcurrentMap
implements ConcurrentMap<WrappedBytes, InternalCacheEntry<WrappedBytes, WrappedBytes>>,
PeekableMap<WrappedBytes, InternalCacheEntry<WrappedBytes, WrappedBytes>>,
Lifecycle {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private static final boolean trace = log.isTraceEnabled();
    private static final int MAX_ADDRESS_COUNT = 0x40000000;
    private final AtomicLong size = new AtomicLong();
    private final int lockCount;
    private final int memoryAddressCount;
    private final StripedLock locks;
    private final OffHeapMemoryAllocator allocator;
    private final OffHeapEntryFactory offHeapEntryFactory;
    private final EntryListener listener;
    private MemoryAddressHash memoryLookup;
    private boolean dellocated = false;

    private void entryCreated(long newAddress) {
        if (this.listener != null) {
            this.listener.entryCreated(newAddress);
        }
    }

    private void entryRemoved(long removedAddress) {
        if (this.listener != null) {
            this.listener.entryRemoved(removedAddress);
        } else {
            this.allocator.deallocate(removedAddress, this.offHeapEntryFactory.getSize(removedAddress, false));
        }
    }

    private void entryReplaced(long newAddress, long oldAddress) {
        if (this.listener != null) {
            this.listener.entryReplaced(newAddress, oldAddress);
        } else {
            this.allocator.deallocate(oldAddress, this.offHeapEntryFactory.getSize(oldAddress, false));
        }
    }

    private void entryRetrieved(long entryAddress) {
        if (this.listener != null) {
            this.listener.entryRetrieved(entryAddress);
        }
    }

    public OffHeapConcurrentMap(int desiredSize, OffHeapMemoryAllocator allocator, OffHeapEntryFactory offHeapEntryFactory, EntryListener listener) {
        this.allocator = Objects.requireNonNull(allocator);
        this.offHeapEntryFactory = Objects.requireNonNull(offHeapEntryFactory);
        this.listener = listener;
        this.lockCount = Util.findNextHighestPowerOfTwo(ProcessorInfo.availableProcessors() << 1);
        this.memoryAddressCount = OffHeapConcurrentMap.getActualAddressCount(desiredSize, this.lockCount);
        this.locks = new StripedLock(this.lockCount, this.offsetCalculatorWithNumberOfBlocks(this.lockCount));
    }

    private OffsetCalculator offsetCalculatorWithNumberOfBlocks(int numBlocks) {
        return new ModulusOffsetCalculator(numBlocks);
    }

    private void checkDeallocation() {
        if (this.dellocated) {
            throw new IllegalStateException("Map was already shut down!");
        }
    }

    static int getActualAddressCount(int desiredSize, int lockCount) {
        int memoryAddresses;
        int n = memoryAddresses = desiredSize >= 0x40000000 ? 0x40000000 : lockCount;
        while (memoryAddresses < desiredSize) {
            memoryAddresses <<= 1;
        }
        return memoryAddresses;
    }

    public StripedLock getLocks() {
        return this.locks;
    }

    @Override
    public void start() {
        this.locks.lockAll();
        try {
            this.memoryLookup = new MemoryAddressHash(this.memoryAddressCount, this.offsetCalculatorWithNumberOfBlocks(this.memoryAddressCount), this.allocator);
            this.dellocated = false;
        }
        finally {
            this.locks.unlockAll();
        }
    }

    @Override
    public void stop() {
        this.locks.lockAll();
        try {
            this.clear();
            this.memoryLookup.deallocate();
            this.dellocated = true;
        }
        finally {
            this.locks.unlockAll();
        }
    }

    @Override
    public int size() {
        return (int)Math.min(this.size.get(), Integer.MAX_VALUE);
    }

    @Override
    public boolean isEmpty() {
        return this.size.get() == 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InternalCacheEntry<WrappedBytes, WrappedBytes> compute(WrappedBytes key, BiFunction<? super WrappedBytes, ? super InternalCacheEntry<WrappedBytes, WrappedBytes>, ? extends InternalCacheEntry<WrappedBytes, WrappedBytes>> remappingFunction) {
        Lock lock = this.locks.getLock(key).writeLock();
        lock.lock();
        try {
            this.checkDeallocation();
            long bucketAddress = this.memoryLookup.getMemoryAddress(key);
            long actualAddress = bucketAddress == 0L ? 0L : this.performGet(bucketAddress, key);
            InternalCacheEntry<WrappedBytes, WrappedBytes> prev = actualAddress != 0L ? this.offHeapEntryFactory.fromMemory(actualAddress) : null;
            InternalCacheEntry<WrappedBytes, WrappedBytes> result = remappingFunction.apply(key, prev);
            if (prev != result) {
                if (result != null) {
                    long newAddress = this.offHeapEntryFactory.create(key, (WrappedBytes)result.getValue(), result.getMetadata());
                    this.performPut(bucketAddress, actualAddress, newAddress, key, false);
                } else {
                    this.performRemove(bucketAddress, actualAddress, key, null, false);
                }
            }
            InternalCacheEntry<WrappedBytes, WrappedBytes> internalCacheEntry = result;
            return internalCacheEntry;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object key) {
        if (!(key instanceof WrappedBytes)) {
            return false;
        }
        Lock lock = this.locks.getLock(key).readLock();
        lock.lock();
        try {
            this.checkDeallocation();
            long address = this.memoryLookup.getMemoryAddress(key);
            if (address == 0L) {
                boolean bl = false;
                return bl;
            }
            while (address != 0L) {
                long nextAddress = this.offHeapEntryFactory.getNext(address);
                if (this.offHeapEntryFactory.equalsKey(address, (WrappedBytes)key)) {
                    boolean bl = !this.offHeapEntryFactory.isExpired(address);
                    return bl;
                }
                address = nextAddress;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public boolean containsValue(Object value) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InternalCacheEntry<WrappedBytes, WrappedBytes> peekOrGet(WrappedBytes k, boolean peek) {
        Lock lock = this.locks.getLock(k).readLock();
        lock.lock();
        try {
            this.checkDeallocation();
            long bucketAddress = this.memoryLookup.getMemoryAddress(k);
            if (bucketAddress == 0L) {
                InternalCacheEntry<WrappedBytes, WrappedBytes> internalCacheEntry = null;
                return internalCacheEntry;
            }
            long actualAddress = this.performGet(bucketAddress, k);
            if (actualAddress != 0L) {
                InternalCacheEntry<WrappedBytes, WrappedBytes> ice = this.offHeapEntryFactory.fromMemory(actualAddress);
                if (!peek) {
                    this.entryRetrieved(actualAddress);
                }
                InternalCacheEntry<WrappedBytes, WrappedBytes> internalCacheEntry = ice;
                return internalCacheEntry;
            }
        }
        finally {
            lock.unlock();
        }
        return null;
    }

    private long performGet(long bucketHeadAddress, WrappedBytes k) {
        long address = bucketHeadAddress;
        while (address != 0L) {
            long nextAddress = this.offHeapEntryFactory.getNext(address);
            if (this.offHeapEntryFactory.equalsKey(address, k)) break;
            address = nextAddress;
        }
        return address;
    }

    @Override
    public InternalCacheEntry<WrappedBytes, WrappedBytes> get(Object key) {
        if (!(key instanceof WrappedBytes)) {
            return null;
        }
        return this.peekOrGet((WrappedBytes)key, false);
    }

    @Override
    public InternalCacheEntry<WrappedBytes, WrappedBytes> peek(Object key) {
        if (!(key instanceof WrappedBytes)) {
            return null;
        }
        return this.peekOrGet((WrappedBytes)key, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InternalCacheEntry<WrappedBytes, WrappedBytes> put(WrappedBytes key, InternalCacheEntry<WrappedBytes, WrappedBytes> value) {
        Lock lock = this.locks.getLock(key).writeLock();
        lock.lock();
        try {
            this.checkDeallocation();
            long newAddress = this.offHeapEntryFactory.create(key, (WrappedBytes)value.getValue(), value.getMetadata());
            long address = this.memoryLookup.getMemoryAddress(key);
            InternalCacheEntry<WrappedBytes, WrappedBytes> internalCacheEntry = this.performPut(address, 0L, newAddress, key, true);
            return internalCacheEntry;
        }
        finally {
            lock.unlock();
        }
    }

    private InternalCacheEntry<WrappedBytes, WrappedBytes> performPut(long bucketHeadAddress, long actualAddress, long newAddress, WrappedBytes key, boolean requireReturn) {
        if (bucketHeadAddress == 0L) {
            this.memoryLookup.putMemoryAddress(key, newAddress);
            this.entryCreated(newAddress);
            this.size.incrementAndGet();
            return null;
        }
        boolean replaceHead = false;
        boolean foundPrevious = false;
        InternalCacheEntry<WrappedBytes, WrappedBytes> previousValue = null;
        long address = bucketHeadAddress;
        long prevAddress = 0L;
        while (address != 0L) {
            long nextAddress = this.offHeapEntryFactory.getNext(address);
            if (!foundPrevious && (actualAddress == 0L ? this.offHeapEntryFactory.equalsKey(address, key) : actualAddress == address)) {
                foundPrevious = true;
                if (requireReturn) {
                    previousValue = this.offHeapEntryFactory.fromMemory(address);
                }
                this.entryReplaced(newAddress, address);
                if (prevAddress == 0L) {
                    if (nextAddress == 0L) {
                        replaceHead = true;
                    } else {
                        this.memoryLookup.putMemoryAddress(key, nextAddress);
                    }
                } else {
                    this.offHeapEntryFactory.setNext(prevAddress, nextAddress);
                    address = nextAddress;
                    continue;
                }
            }
            prevAddress = address;
            address = nextAddress;
        }
        if (!foundPrevious) {
            this.entryCreated(newAddress);
            this.size.incrementAndGet();
        }
        if (replaceHead) {
            this.memoryLookup.putMemoryAddress(key, newAddress);
        } else {
            this.offHeapEntryFactory.setNext(prevAddress, newAddress);
        }
        return previousValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InternalCacheEntry<WrappedBytes, WrappedBytes> remove(Object key) {
        if (!(key instanceof WrappedBytes)) {
            return null;
        }
        Lock lock = this.locks.getLock(key).writeLock();
        lock.lock();
        try {
            this.checkDeallocation();
            long address = this.memoryLookup.getMemoryAddress(key);
            if (address == 0L) {
                InternalCacheEntry<WrappedBytes, WrappedBytes> internalCacheEntry = null;
                return internalCacheEntry;
            }
            InternalCacheEntry<WrappedBytes, WrappedBytes> internalCacheEntry = this.performRemove(address, 0L, (WrappedBytes)key, null, true);
            return internalCacheEntry;
        }
        finally {
            lock.unlock();
        }
    }

    void remove(WrappedBytes key, long address) {
        long bucketAddress = this.memoryLookup.getMemoryAddress(key);
        assert (bucketAddress != 0L);
        this.performRemove(bucketAddress, address, key, null, false);
    }

    private InternalCacheEntry<WrappedBytes, WrappedBytes> performRemove(long bucketHeadAddress, long actualAddress, WrappedBytes key, WrappedBytes value, boolean requireReturn) {
        long prevAddress = 0L;
        long address = bucketHeadAddress;
        InternalCacheEntry<WrappedBytes, WrappedBytes> ice = null;
        while (address != 0L) {
            boolean removeThisAddress;
            long nextAddress = this.offHeapEntryFactory.getNext(address);
            boolean bl = actualAddress == 0L ? this.offHeapEntryFactory.equalsKey(address, key) : (removeThisAddress = actualAddress == address);
            if (removeThisAddress) {
                if (value != null && !value.equalsWrappedBytes((WrappedBytes)(ice = this.offHeapEntryFactory.fromMemory(address)).getValue())) {
                    ice = null;
                    break;
                }
                if (requireReturn && ice == null) {
                    ice = this.offHeapEntryFactory.fromMemory(address);
                }
                this.entryRemoved(address);
                if (prevAddress != 0L) {
                    this.offHeapEntryFactory.setNext(prevAddress, nextAddress);
                } else {
                    this.memoryLookup.putMemoryAddress(key, nextAddress);
                }
                this.size.decrementAndGet();
                break;
            }
            prevAddress = address;
            address = nextAddress;
        }
        return ice;
    }

    @Override
    public void putAll(Map<? extends WrappedBytes, ? extends InternalCacheEntry<WrappedBytes, WrappedBytes>> m) {
        for (Map.Entry<? extends WrappedBytes, ? extends InternalCacheEntry<WrappedBytes, WrappedBytes>> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.locks.lockAll();
        try {
            this.checkDeallocation();
            if (trace) {
                log.trace("Clearing off heap data");
            }
            this.memoryLookup.toStreamRemoved().forEach((long address) -> {
                while (address != 0L) {
                    long nextAddress = this.offHeapEntryFactory.getNext(address);
                    this.entryRemoved(address);
                    address = nextAddress;
                }
            });
            this.size.set(0L);
            if (trace) {
                log.trace("Cleared off heap data");
            }
        }
        finally {
            this.locks.unlockAll();
        }
    }

    @Override
    public InternalCacheEntry<WrappedBytes, WrappedBytes> putIfAbsent(WrappedBytes key, InternalCacheEntry<WrappedBytes, WrappedBytes> value) {
        return this.compute(key, (? super WrappedBytes k, ? super InternalCacheEntry<WrappedBytes, WrappedBytes> v) -> {
            if (v == null) {
                return value;
            }
            return v;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object key, Object value) {
        if (!(key instanceof WrappedBytes) || !(value instanceof InternalCacheEntry)) {
            return false;
        }
        Object innerValue = ((InternalCacheEntry)value).getValue();
        if (!(innerValue instanceof WrappedBytes)) {
            return false;
        }
        Lock lock = this.locks.getLock(key).writeLock();
        lock.lock();
        try {
            this.checkDeallocation();
            long address = this.memoryLookup.getMemoryAddress(key);
            boolean bl = address != 0L && this.performRemove(address, 0L, (WrappedBytes)key, (WrappedBytes)innerValue, true) != null;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean replace(WrappedBytes key, InternalCacheEntry<WrappedBytes, WrappedBytes> oldValue, InternalCacheEntry<WrappedBytes, WrappedBytes> newValue) {
        Lock lock = this.locks.getLock(key).writeLock();
        lock.lock();
        try {
            this.checkDeallocation();
            long address = this.memoryLookup.getMemoryAddress(key);
            boolean bl = address != 0L && this.performReplace(address, key, oldValue, newValue) != null;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InternalCacheEntry<WrappedBytes, WrappedBytes> replace(WrappedBytes key, InternalCacheEntry<WrappedBytes, WrappedBytes> value) {
        Lock lock = this.locks.getLock(key).writeLock();
        lock.lock();
        try {
            this.checkDeallocation();
            long address = this.memoryLookup.getMemoryAddress(key);
            if (address == 0L) {
                InternalCacheEntry<WrappedBytes, WrappedBytes> internalCacheEntry = null;
                return internalCacheEntry;
            }
            InternalCacheEntry<WrappedBytes, WrappedBytes> internalCacheEntry = this.performReplace(address, key, null, value);
            return internalCacheEntry;
        }
        finally {
            lock.unlock();
        }
    }

    private InternalCacheEntry<WrappedBytes, WrappedBytes> performReplace(long bucketHeadAddress, WrappedBytes key, InternalCacheEntry<WrappedBytes, WrappedBytes> oldValue, InternalCacheEntry<WrappedBytes, WrappedBytes> newValue) {
        long prevAddress = 0L;
        long address = bucketHeadAddress;
        InternalCacheEntry<WrappedBytes, WrappedBytes> ice = null;
        while (address != 0L) {
            long nextAddress = this.offHeapEntryFactory.getNext(address);
            if (this.offHeapEntryFactory.equalsKey(address, key)) {
                if (oldValue != null && !((WrappedBytes)(ice = this.offHeapEntryFactory.fromMemory(address)).getValue()).equalsWrappedBytes((WrappedBytes)oldValue.getValue())) {
                    ice = null;
                    break;
                }
                if (ice == null) {
                    ice = this.offHeapEntryFactory.fromMemory(address);
                }
                long newAddress = this.offHeapEntryFactory.create(key, (WrappedBytes)newValue.getValue(), newValue.getMetadata());
                this.entryReplaced(newAddress, address);
                if (prevAddress != 0L) {
                    this.offHeapEntryFactory.setNext(prevAddress, newAddress);
                } else {
                    this.memoryLookup.putMemoryAddress(key, newAddress);
                }
                this.offHeapEntryFactory.setNext(newAddress, nextAddress);
                break;
            }
            prevAddress = address;
            address = nextAddress;
        }
        return ice;
    }

    @Override
    public Set<WrappedBytes> keySet() {
        return new AbstractSet<WrappedBytes>(){

            @Override
            public Iterator<WrappedBytes> iterator() {
                return OffHeapConcurrentMap.this.entryStream().map(CacheEntry::getKey).iterator();
            }

            @Override
            public int size() {
                return OffHeapConcurrentMap.this.size();
            }

            @Override
            public boolean remove(Object o) {
                return OffHeapConcurrentMap.this.remove(o) != null;
            }
        };
    }

    @Override
    public Collection<InternalCacheEntry<WrappedBytes, WrappedBytes>> values() {
        return new AbstractCollection<InternalCacheEntry<WrappedBytes, WrappedBytes>>(){

            @Override
            public Iterator<InternalCacheEntry<WrappedBytes, WrappedBytes>> iterator() {
                return OffHeapConcurrentMap.this.entryStream().iterator();
            }

            @Override
            public int size() {
                return OffHeapConcurrentMap.this.size();
            }

            @Override
            public boolean remove(Object o) {
                return o instanceof InternalCacheEntry && OffHeapConcurrentMap.this.remove(((InternalCacheEntry)o).getKey(), ((InternalCacheEntry)o).getValue());
            }
        };
    }

    private Stream<InternalCacheEntry<WrappedBytes, WrappedBytes>> entryStream() {
        return IntStream.range(0, this.memoryAddressCount).mapToObj(a -> {
            Lock lock = this.locks.getLockWithOffset(a % this.lockCount).readLock();
            lock.lock();
            try {
                long nextAddress;
                this.checkDeallocation();
                long address = this.memoryLookup.getMemoryAddressOffsetNoTraceIfAbsent(a);
                if (address == 0L) {
                    Stream stream = null;
                    return stream;
                }
                Stream.Builder<InternalCacheEntry<WrappedBytes, WrappedBytes>> builder = Stream.builder();
                do {
                    nextAddress = this.offHeapEntryFactory.getNext(address);
                    builder.accept(this.offHeapEntryFactory.fromMemory(address));
                } while ((address = nextAddress) != 0L);
                Stream stream = builder.build();
                return stream;
            }
            finally {
                lock.unlock();
            }
        }).flatMap(Function.identity());
    }

    @Override
    public Set<Map.Entry<WrappedBytes, InternalCacheEntry<WrappedBytes, WrappedBytes>>> entrySet() {
        return new AbstractSet<Map.Entry<WrappedBytes, InternalCacheEntry<WrappedBytes, WrappedBytes>>>(){

            @Override
            public Iterator<Map.Entry<WrappedBytes, InternalCacheEntry<WrappedBytes, WrappedBytes>>> iterator() {
                Stream<Map.Entry> stream = OffHeapConcurrentMap.this.entryStream().map(ice -> new AbstractMap.SimpleImmutableEntry(ice.getKey(), (InternalCacheEntry)ice));
                return stream.iterator();
            }

            @Override
            public int size() {
                return OffHeapConcurrentMap.this.size();
            }
        };
    }

    public static interface EntryListener {
        public void entryCreated(long var1);

        public void entryRemoved(long var1);

        public void entryReplaced(long var1, long var3);

        public void entryRetrieved(long var1);
    }
}

