/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.offheap;

import java.util.concurrent.ConcurrentHashMap;
import org.infinispan.container.offheap.UnsafeHolder;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import sun.misc.Unsafe;

class OffHeapMemory {
    private static final Log log = LogFactory.getLog(OffHeapMemory.class);
    private static final boolean trace = log.isTraceEnabled();
    private static final Unsafe UNSAFE = UnsafeHolder.UNSAFE;
    static final OffHeapMemory INSTANCE = new OffHeapMemory();
    private static final int BYTE_ARRAY_BASE_OFFSET = Unsafe.ARRAY_BYTE_BASE_OFFSET;
    private static ConcurrentHashMap<Long, Long> allocatedBlocks = new ConcurrentHashMap();

    private OffHeapMemory() {
    }

    byte getByte(long srcAddress, long offset) {
        OffHeapMemory.checkAddress(srcAddress, offset + 4L);
        byte value = UNSAFE.getByte(srcAddress + offset);
        if (trace) {
            log.tracef("Read byte value 0x%02x from address 0x%016x+%d", (long)value, srcAddress, offset);
        }
        return value;
    }

    void putByte(long destAddress, long offset, byte value) {
        OffHeapMemory.checkAddress(destAddress, offset + 4L);
        if (trace) {
            log.tracef("Wrote byte value 0x%02x to address 0x%016x+%d", (long)value, destAddress, offset);
        }
        UNSAFE.putByte(destAddress + offset, value);
    }

    int getInt(long srcAddress, long offset) {
        OffHeapMemory.checkAddress(srcAddress, offset + 4L);
        int value = UNSAFE.getInt(srcAddress + offset);
        if (trace) {
            log.tracef("Read int value 0x%08x from address 0x%016x+%d", (long)value, srcAddress, offset);
        }
        return value;
    }

    void putInt(long destAddress, long offset, int value) {
        OffHeapMemory.checkAddress(destAddress, offset + 4L);
        if (trace) {
            log.tracef("Wrote int value 0x%08x to address 0x%016x+%d", (long)value, destAddress, offset);
        }
        UNSAFE.putInt(destAddress + offset, value);
    }

    long getLong(long srcAddress, long offset) {
        return this.getLong(srcAddress, offset, true);
    }

    long getLongNoTraceIfAbsent(long srcAddress, long offset) {
        return this.getLong(srcAddress, offset, false);
    }

    private long getLong(long srcAddress, long offset, boolean alwaysTrace) {
        OffHeapMemory.checkAddress(srcAddress, offset + 8L);
        long value = UNSAFE.getLong(srcAddress + offset);
        if (trace && (alwaysTrace || value != 0L)) {
            log.tracef("Read long value 0x%016x from address 0x%016x+%d", value, srcAddress, offset);
        }
        return value;
    }

    void putLong(long destAddress, long offset, long value) {
        OffHeapMemory.checkAddress(destAddress, offset + 8L);
        if (trace) {
            log.tracef("Wrote long value 0x%016x to address 0x%016x+%d", value, destAddress, offset);
        }
        UNSAFE.putLong(destAddress + offset, value);
    }

    void getBytes(long srcAddress, long srcOffset, byte[] destArray, long destOffset, long length) {
        OffHeapMemory.checkAddress(srcAddress, srcOffset + length);
        if (trace) {
            log.tracef("Read %d bytes from address 0x%016x+%d into array %s+%d", length, srcAddress, srcOffset, destArray, destOffset);
        }
        UNSAFE.copyMemory(null, srcAddress + srcOffset, destArray, (long)BYTE_ARRAY_BASE_OFFSET + destOffset, length);
    }

    void putBytes(byte[] srcArray, long srcOffset, long destAddress, long destOffset, long length) {
        OffHeapMemory.checkAddress(destAddress, destOffset + length);
        if (trace) {
            log.tracef("Wrote %d bytes from array %s+%d to address 0x%016x+%d", length, srcArray, srcOffset, destAddress, destOffset);
        }
        UNSAFE.copyMemory(srcArray, (long)BYTE_ARRAY_BASE_OFFSET + srcOffset, null, destAddress + destOffset, length);
    }

    private static byte[] getBytes(long srcAddress, long srcOffset, int length) {
        OffHeapMemory.checkAddress(srcAddress, srcOffset + (long)length);
        byte[] bytes = new byte[length];
        UNSAFE.copyMemory(null, srcAddress + srcOffset, bytes, BYTE_ARRAY_BASE_OFFSET, length);
        return bytes;
    }

    private static void checkAddress(long address, long offset) {
        if (!trace) {
            return;
        }
        Long blockSize = allocatedBlocks.get(address);
        if (blockSize == null || blockSize < offset) {
            throw new IllegalArgumentException(String.format("Trying to access address 0x%016x+%d, but blockSize was %d", address, offset, blockSize));
        }
    }

    long allocate(long size) {
        Long prev;
        long address = UNSAFE.allocateMemory(size);
        if (trace && (prev = allocatedBlocks.put(address, size)) != null) {
            throw new IllegalArgumentException();
        }
        return address;
    }

    void free(long address) {
        Long prev = allocatedBlocks.remove(address);
        if (trace && prev == null) {
            throw new IllegalArgumentException();
        }
        UNSAFE.freeMemory(address);
    }
}

