/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.offheap;

import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.infinispan.commons.util.Util;
import org.infinispan.container.offheap.OffsetCalculator;

public class StripedLock {
    private final ReadWriteLock[] locks;
    private final OffsetCalculator offSetCalculator;

    public StripedLock(int lockCount, OffsetCalculator offSetCalculator) {
        this.locks = new ReadWriteLock[Util.findNextHighestPowerOfTwo(lockCount)];
        for (int i = 0; i < this.locks.length; ++i) {
            this.locks[i] = new ReentrantReadWriteLock();
        }
        this.offSetCalculator = offSetCalculator;
    }

    public ReadWriteLock getLock(Object obj) {
        return this.getLockFromHashCode(obj.hashCode());
    }

    public ReadWriteLock getLockFromHashCode(int hashCode) {
        int offset = this.offSetCalculator.calculateOffsetUsingHashCode(hashCode);
        return this.locks[offset];
    }

    public ReadWriteLock getLockWithOffset(int offset) {
        if (offset >= this.locks.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.locks[offset];
    }

    public void lockAll() {
        for (ReadWriteLock rwLock : this.locks) {
            rwLock.writeLock().lock();
        }
    }

    void unlockAll() {
        for (ReadWriteLock rwLock : this.locks) {
            rwLock.writeLock().unlock();
        }
    }
}

