/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.ch.impl;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import net.jcip.annotations.Immutable;
import org.infinispan.commons.hash.Hash;
import org.infinispan.commons.marshall.InstanceReusingAdvancedExternalizer;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.IntSets;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.ch.impl.AbstractConsistentHash;
import org.infinispan.distribution.ch.impl.OwnershipStatistics;
import org.infinispan.globalstate.ScopedPersistentState;
import org.infinispan.remoting.transport.Address;
import org.infinispan.topology.PersistentUUID;

@Immutable
public class ScatteredConsistentHash
extends AbstractConsistentHash {
    private PersistentUUID ZERO_UUID = new PersistentUUID(0L, 0L);
    private static final String STATE_SEGMENT_OWNER = "segmentOwner.%d";
    private static final String REBALANCED = "rebalanced";
    private final Address[] segmentOwners;
    private final List<Address>[] segmentOwnerLists;
    private final boolean isRebalanced;

    public ScatteredConsistentHash(Hash hashFunction, int numSegments, List<Address> members, Map<Address, Float> capacityFactors, Address[] segmentOwners, boolean isRebalanced) {
        super(hashFunction, numSegments, members, capacityFactors);
        this.segmentOwners = Arrays.copyOf(segmentOwners, segmentOwners.length);
        this.segmentOwnerLists = (List[])Stream.of(segmentOwners).map(ScatteredConsistentHash::toList).toArray(List[]::new);
        this.isRebalanced = isRebalanced;
    }

    private ScatteredConsistentHash(Hash hashFunction, int numSegments, List<Address> members, float[] capacityFactors, Address[] segmentOwners, boolean isRebalanced) {
        super(hashFunction, numSegments, members, capacityFactors);
        this.segmentOwners = segmentOwners;
        this.segmentOwnerLists = (List[])Stream.of(segmentOwners).map(ScatteredConsistentHash::toList).toArray(List[]::new);
        this.isRebalanced = isRebalanced;
    }

    private static List<Address> toList(Address address) {
        return address == null ? Collections.emptyList() : Collections.singletonList(address);
    }

    ScatteredConsistentHash(ScopedPersistentState state) {
        super(state);
        int numSegments = ScatteredConsistentHash.parseNumSegments(state);
        this.segmentOwners = new Address[numSegments];
        this.segmentOwnerLists = new List[numSegments];
        for (int i = 0; i < this.segmentOwners.length; ++i) {
            PersistentUUID persistentUUID = PersistentUUID.fromString(state.getProperty(String.format(STATE_SEGMENT_OWNER, i)));
            if (persistentUUID.getMostSignificantBits() == 0L && persistentUUID.getLeastSignificantBits() == 0L) {
                this.segmentOwners[i] = null;
                this.segmentOwnerLists[i] = Collections.emptyList();
                continue;
            }
            this.segmentOwners[i] = persistentUUID;
            this.segmentOwnerLists[i] = Collections.singletonList(persistentUUID);
        }
        this.isRebalanced = Boolean.parseBoolean(state.getProperty(REBALANCED));
    }

    @Override
    public int getNumSegments() {
        return this.segmentOwners.length;
    }

    @Override
    public Set<Integer> getSegmentsForOwner(Address owner) {
        if (owner == null) {
            throw new IllegalArgumentException("owner cannot be null");
        }
        if (!this.members.contains(owner)) {
            throw new IllegalArgumentException("Node " + owner + " is not a member");
        }
        IntSet segments = IntSets.mutableEmptySet(this.segmentOwners.length);
        for (int segment = 0; segment < this.segmentOwners.length; ++segment) {
            if (!Objects.equals(this.segmentOwners[segment], owner)) continue;
            segments.set(segment);
        }
        return segments;
    }

    @Override
    public Set<Integer> getPrimarySegmentsForOwner(Address owner) {
        return this.getSegmentsForOwner(owner);
    }

    @Override
    public List<Address> locateOwnersForSegment(int segmentId) {
        return this.segmentOwnerLists[segmentId];
    }

    @Override
    public Address locatePrimaryOwnerForSegment(int segmentId) {
        return this.segmentOwners[segmentId];
    }

    @Override
    public int getNumOwners() {
        return 1;
    }

    @Override
    public Set<Address> locateAllOwners(Collection<Object> keys) {
        HashSet<Integer> segments = new HashSet<Integer>();
        for (Object key : keys) {
            segments.add(this.getSegment(key));
        }
        HashSet<Address> ownersUnion = new HashSet<Address>();
        for (Integer segment : segments) {
            if (this.segmentOwners[segment] == null) continue;
            ownersUnion.add(this.segmentOwners[segment]);
        }
        return ownersUnion;
    }

    @Override
    public boolean isSegmentLocalToNode(Address nodeAddress, int segmentId) {
        return Objects.equals(this.segmentOwners[segmentId], nodeAddress);
    }

    public int hashCode() {
        int result = this.members.hashCode() + (this.isRebalanced ? 1 : 0);
        result = 31 * result + Arrays.hashCode(this.segmentOwners);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScatteredConsistentHash that = (ScatteredConsistentHash)o;
        if (this.isRebalanced != that.isRebalanced) {
            return false;
        }
        if (this.segmentOwners.length != that.segmentOwners.length) {
            return false;
        }
        if (!this.hashFunction.equals(that.hashFunction)) {
            return false;
        }
        if (!this.members.equals(that.members)) {
            return false;
        }
        return Arrays.equals(this.segmentOwners, that.segmentOwners);
    }

    public String toString() {
        OwnershipStatistics stats = new OwnershipStatistics(this, this.members);
        StringBuilder sb = new StringBuilder("ScatteredConsistentHash{");
        sb.append("ns=").append(this.segmentOwners.length);
        sb.append(", rebalanced=").append(this.isRebalanced);
        sb.append(", owners = (").append(this.members.size()).append(")[");
        boolean first = true;
        for (Address a : this.members) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            int primaryOwned = stats.getPrimaryOwned(a);
            sb.append(a).append(": ").append(primaryOwned);
        }
        sb.append("]}");
        return sb.toString();
    }

    @Override
    public String getRoutingTableAsString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.segmentOwners.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(i).append(": ").append(this.members.indexOf(this.segmentOwners[i]));
        }
        return sb.toString();
    }

    public ScatteredConsistentHash union(ScatteredConsistentHash sch2) {
        this.checkSameHashAndSegments(sch2);
        ArrayList<Address> unionMembers = new ArrayList<Address>(this.members);
        ScatteredConsistentHash.mergeLists(unionMembers, sch2.getMembers());
        Address[] unionSegmentOwners = new Address[this.segmentOwners.length];
        for (int i = 0; i < unionSegmentOwners.length; ++i) {
            unionSegmentOwners[i] = Optional.ofNullable(sch2.locatePrimaryOwnerForSegment(i)).orElse(this.locatePrimaryOwnerForSegment(i));
        }
        Map<Address, Float> unionCapacityFactors = this.unionCapacityFactors(sch2);
        return new ScatteredConsistentHash(this.hashFunction, unionSegmentOwners.length, unionMembers, unionCapacityFactors, unionSegmentOwners, false);
    }

    @Override
    public void toScopedState(ScopedPersistentState state) {
        super.toScopedState(state);
        for (int i = 0; i < this.segmentOwners.length; ++i) {
            state.setProperty(String.format(STATE_SEGMENT_OWNER, i), (this.segmentOwners[i] == null ? this.ZERO_UUID : this.segmentOwners[i]).toString());
        }
        state.setProperty(REBALANCED, String.valueOf(this.isRebalanced));
    }

    @Override
    public ConsistentHash remapAddresses(UnaryOperator<Address> remapper) {
        List<Address> remappedMembers = this.remapMembers(remapper);
        if (remappedMembers == null) {
            return null;
        }
        Map<Address, Float> remappedCapacityFactors = this.remapCapacityFactors(remapper);
        Address[] remappedSegmentOwners = (Address[])Stream.of(this.segmentOwners).map(remapper).toArray(Address[]::new);
        return new ScatteredConsistentHash(this.hashFunction, this.segmentOwners.length, remappedMembers, remappedCapacityFactors, remappedSegmentOwners, this.isRebalanced);
    }

    public static class Externalizer
    extends InstanceReusingAdvancedExternalizer<ScatteredConsistentHash> {
        @Override
        public void doWriteObject(ObjectOutput output, ScatteredConsistentHash ch) throws IOException {
            output.writeInt(ch.segmentOwners.length);
            output.writeObject(ch.members);
            output.writeObject(ch.capacityFactors);
            output.writeObject(ch.hashFunction);
            HashMap<Address, Integer> memberIndexes = AbstractConsistentHash.getMemberIndexMap(ch.members);
            for (int i = 0; i < ch.segmentOwners.length; ++i) {
                output.writeInt(ch.segmentOwners[i] == null ? -1 : memberIndexes.get(ch.segmentOwners[i]));
            }
            output.writeBoolean(ch.isRebalanced);
        }

        @Override
        public ScatteredConsistentHash doReadObject(ObjectInput unmarshaller) throws IOException, ClassNotFoundException {
            int numSegments = unmarshaller.readInt();
            List members = (List)unmarshaller.readObject();
            float[] capacityFactors = (float[])unmarshaller.readObject();
            Hash hash = (Hash)unmarshaller.readObject();
            Address[] segmentOwners = new Address[numSegments];
            for (int i = 0; i < numSegments; ++i) {
                int ownerIndex = unmarshaller.readInt();
                if (ownerIndex < 0) continue;
                segmentOwners[i] = (Address)members.get(ownerIndex);
            }
            boolean isRebalanced = unmarshaller.readBoolean();
            return new ScatteredConsistentHash(hash, numSegments, members, capacityFactors, segmentOwners, isRebalanced);
        }

        @Override
        public Integer getId() {
            return 128;
        }

        @Override
        public Set<Class<? extends ScatteredConsistentHash>> getTypeClasses() {
            return Collections.singleton(ScatteredConsistentHash.class);
        }
    }
}

