/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.group.impl;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.infinispan.commons.util.CollectionFactory;
import org.infinispan.commons.util.ReflectionUtil;
import org.infinispan.commons.util.Util;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.group.Group;
import org.infinispan.distribution.group.Grouper;
import org.infinispan.distribution.group.impl.GroupManager;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.remoting.transport.Address;

public class GroupManagerImpl
implements GroupManager {
    @Inject
    private ComponentRegistry componentRegistry;
    private DistributionManager distributionManager;
    private final ConcurrentMap<Class<?>, GroupMetadata> groupMetadataCache = CollectionFactory.makeConcurrentMap();
    private final List<Grouper<?>> groupers;

    public GroupManagerImpl(List<Grouper<?>> groupers) {
        this.groupers = groupers != null ? groupers : Collections.emptyList();
    }

    @Start
    public void start() {
        this.distributionManager = this.componentRegistry.getDistributionManager();
    }

    @Override
    public Object getGroup(Object key) {
        GroupMetadata metadata = this.getMetadata(key);
        if (metadata != null) {
            return this.applyGroupers(metadata.getGroup(key), key);
        }
        return this.applyGroupers(null, key);
    }

    @Override
    public boolean isOwner(Object group) {
        return this.distributionManager.getCacheTopology().isWriteOwner(group);
    }

    @Override
    public Address getPrimaryOwner(Object group) {
        return this.distributionManager.getCacheTopology().getDistribution(group).primary();
    }

    @Override
    public boolean isPrimaryOwner(Object group) {
        return this.distributionManager.getCacheTopology().getDistribution(group).isPrimary();
    }

    private static GroupMetadata createGroupMetadata(Class<?> clazz) {
        Collection<Method> possibleMethods = System.getSecurityManager() == null ? ReflectionUtil.getAllMethods(clazz, Group.class) : (Collection)AccessController.doPrivileged(() -> ReflectionUtil.getAllMethods(clazz, Group.class));
        if (possibleMethods.isEmpty()) {
            return GroupMetadata.NONE;
        }
        if (possibleMethods.size() == 1) {
            return new GroupMetadataImpl(possibleMethods.iterator().next());
        }
        throw new IllegalStateException(Util.formatString("Cannot define more that one @Group method for class hierarchy rooted at %s", clazz.getName()));
    }

    private Object applyGroupers(Object group, Object key) {
        for (Grouper<?> grouper : this.groupers) {
            if (!grouper.getKeyType().isAssignableFrom(key.getClass())) continue;
            group = grouper.computeGroup(key, group);
        }
        return group;
    }

    private GroupMetadata getMetadata(Object key) {
        GroupMetadata previous;
        Class<?> keyClass = key.getClass();
        GroupMetadata groupMetadata = (GroupMetadata)this.groupMetadataCache.get(keyClass);
        if (groupMetadata == null && (previous = this.groupMetadataCache.putIfAbsent(keyClass, groupMetadata = GroupManagerImpl.createGroupMetadata(keyClass))) != null) {
            return previous;
        }
        return groupMetadata;
    }

    private static class GroupMetadataImpl
    implements GroupMetadata {
        private final Method method;

        GroupMetadataImpl(Method method) {
            if (method.getParameterTypes().length > 0) {
                throw new IllegalArgumentException(Util.formatString("@Group method %s must have zero arguments", method));
            }
            this.method = method;
        }

        @Override
        public Object getGroup(Object instance) {
            if (System.getSecurityManager() == null) {
                return ReflectionUtil.invokeAccessibly(instance, this.method, Util.EMPTY_OBJECT_ARRAY);
            }
            return AccessController.doPrivileged(() -> ReflectionUtil.invokeAccessibly(instance, this.method, Util.EMPTY_OBJECT_ARRAY));
        }
    }

    private static interface GroupMetadata {
        public static final GroupMetadata NONE = instance -> null;

        public Object getGroup(Object var1);
    }
}

