/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.executors;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.jcip.annotations.GuardedBy;
import org.infinispan.IllegalLifecycleStateException;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.concurrent.WithinThreadExecutor;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.jboss.logging.NDC;

public class LimitedExecutor
implements Executor {
    private static final Log log = LogFactory.getLog(LimitedExecutor.class);
    private final Lock lock = new ReentrantLock();
    private final Condition taskFinishedCondition = this.lock.newCondition();
    private final String name;
    private final Executor executor;
    private final boolean blocking;
    private final Runner runner = new Runner();
    private volatile boolean running = true;
    @GuardedBy(value="lock")
    private int availablePermits;
    @GuardedBy(value="lock")
    private Map<Thread, Object> threads;
    @GuardedBy(value="lock")
    private final Deque<Runnable> queue = new ArrayDeque<Runnable>();

    public LimitedExecutor(String name, Executor executor, int maxConcurrentTasks) {
        this.name = name;
        this.executor = executor;
        this.availablePermits = maxConcurrentTasks;
        this.blocking = executor instanceof WithinThreadExecutor;
        this.threads = new IdentityHashMap<Thread, Object>(maxConcurrentTasks);
    }

    public void shutdownNow() {
        log.tracef("Stopping limited executor %s", (Object)this.name);
        this.running = false;
        this.lock.lock();
        try {
            this.queue.clear();
            for (Thread t : this.threads.keySet()) {
                t.interrupt();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Runnable command) {
        if (!this.running) {
            throw new IllegalLifecycleStateException("Limited executor " + this.name + " is not running!");
        }
        if (this.blocking) {
            CompletableFuture f1 = new CompletableFuture();
            this.executeInternal(() -> {
                f1.complete(null);
                this.removePermit();
            });
            try {
                CompletableFutures.await(f1);
                command.run();
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                throw new IllegalLifecycleStateException(ie);
            }
            catch (Exception e) {
                log.error("Exception in task", e);
            }
            finally {
                this.addPermit();
                this.tryExecute();
            }
            return;
        }
        this.executeInternal(command);
    }

    private void executeInternal(Runnable command) {
        this.lock.lock();
        try {
            this.queue.add(command);
        }
        finally {
            this.lock.unlock();
        }
        this.tryExecute();
    }

    public void executeAsync(Supplier<CompletionStage<Void>> asyncCommand) {
        this.execute(() -> {
            CompletionStage future = (CompletionStage)asyncCommand.get();
            assert (future != null);
            this.removePermit();
            future.whenComplete(this.runner);
        });
    }

    private void tryExecute() {
        boolean addRunner = false;
        this.lock.lock();
        try {
            if (this.availablePermits > 0) {
                --this.availablePermits;
                addRunner = true;
            }
        }
        finally {
            this.lock.unlock();
        }
        if (addRunner) {
            this.executor.execute(this.runner);
        }
    }

    private void runTasks() {
        this.runnerStarting();
        while (this.running) {
            Runnable runnable = null;
            this.lock.lock();
            try {
                if (this.availablePermits >= 0) {
                    runnable = this.queue.poll();
                }
                if (runnable == null) {
                    ++this.availablePermits;
                    break;
                }
            }
            finally {
                this.lock.unlock();
            }
            try {
                NDC.push(this.name);
                runnable.run();
            }
            catch (Throwable t) {
                log.error("Exception in task", t);
            }
            finally {
                NDC.pop();
            }
        }
        this.runnerFinished();
    }

    private void runnerStarting() {
        this.lock.lock();
        try {
            Thread thread = Thread.currentThread();
            this.threads.put(thread, thread);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void runnerFinished() {
        this.lock.lock();
        try {
            Thread thread = Thread.currentThread();
            this.threads.remove(thread);
            this.taskFinishedCondition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void removePermit() {
        this.lock.lock();
        try {
            --this.availablePermits;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void addPermit() {
        this.lock.lock();
        try {
            ++this.availablePermits;
        }
        finally {
            this.lock.unlock();
        }
    }

    private class Runner
    implements Runnable,
    BiConsumer<Void, Throwable> {
        private Runner() {
        }

        @Override
        public void run() {
            LimitedExecutor.this.runTasks();
        }

        @Override
        public void accept(Void aVoid, Throwable throwable) {
            LimitedExecutor.this.addPermit();
            LimitedExecutor.this.tryExecute();
        }
    }
}

