/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories;

import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.util.ReflectionUtil;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.factories.ComponentFactory;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Scope(value=Scopes.GLOBAL)
public abstract class AbstractComponentFactory
implements ComponentFactory {
    protected static final Log log = LogFactory.getLog(AbstractComponentFactory.class);
    @Inject
    protected GlobalComponentRegistry globalComponentRegistry;
    @Inject
    protected GlobalConfiguration globalConfiguration;

    @Override
    public Object construct(String name) {
        Class<?> componentType;
        try {
            componentType = ReflectionUtil.getClassForName(name, this.globalComponentRegistry.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new CacheConfigurationException(e);
        }
        return this.construct(componentType);
    }

    @Deprecated
    public <T> T construct(Class<T> componentType) {
        throw new UnsupportedOperationException();
    }

    protected void assertTypeConstructable(Class<?> requestedType, Class<?> ... ableToConstruct) {
        boolean canConstruct = false;
        for (Class<?> c : ableToConstruct) {
            canConstruct = canConstruct || requestedType.isAssignableFrom(c);
        }
        if (!canConstruct) {
            throw log.factoryCannotConstructComponent(requestedType.getName());
        }
    }
}

