/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import net.jcip.annotations.ThreadSafe;
import org.infinispan.Version;
import org.infinispan.commands.module.ModuleCommandFactory;
import org.infinispan.commands.module.ModuleCommandInitializer;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.uberjar.ManifestUberJarDuplicatedJarsWarner;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.ShutdownHookBehavior;
import org.infinispan.conflict.EntryMergePolicyFactoryRegistry;
import org.infinispan.factories.AbstractComponentRegistry;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.annotations.SurvivesRestarts;
import org.infinispan.factories.components.ComponentMetadataRepo;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.globalstate.GlobalConfigurationManager;
import org.infinispan.jmx.CacheManagerJmxRegistration;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.lifecycle.ModuleLifecycle;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.marshall.core.EncoderRegistry;
import org.infinispan.notifications.cachemanagerlistener.CacheManagerNotifier;
import org.infinispan.notifications.cachemanagerlistener.CacheManagerNotifierImpl;
import org.infinispan.persistence.factory.CacheStoreFactoryRegistry;
import org.infinispan.registry.InternalCacheRegistry;
import org.infinispan.registry.impl.InternalCacheRegistryImpl;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.stats.ClusterContainerStats;
import org.infinispan.topology.ClusterTopologyManager;
import org.infinispan.topology.LocalTopologyManager;
import org.infinispan.util.ByteString;
import org.infinispan.util.ModuleProperties;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.util.logging.events.EventLogManager;
import org.infinispan.xsite.GlobalXSiteAdminOperations;

@Scope(value=Scopes.GLOBAL)
@SurvivesRestarts
@ThreadSafe
public class GlobalComponentRegistry
extends AbstractComponentRegistry {
    private static final Log log = LogFactory.getLog(GlobalComponentRegistry.class);
    private static final AtomicBoolean versionLogged = new AtomicBoolean(false);
    private Thread shutdownHook;
    private boolean invokedFromShutdownHook;
    private final GlobalConfiguration globalConfiguration;
    private final Set<String> createdCaches;
    private final ModuleProperties moduleProperties = new ModuleProperties();
    final Collection<ModuleLifecycle> moduleLifecycles;
    boolean modulesStarted;
    final ConcurrentMap<ByteString, ComponentRegistry> namedComponents = new ConcurrentHashMap<ByteString, ComponentRegistry>(4);
    protected final ClassLoader classLoader;

    public GlobalComponentRegistry(GlobalConfiguration configuration, EmbeddedCacheManager cacheManager, Set<String> createdCaches) {
        super(new ComponentMetadataRepo(), configuration.classLoader(), Scopes.GLOBAL, null);
        ClassLoader configuredClassLoader = configuration.classLoader();
        this.moduleLifecycles = ModuleProperties.resolveModuleLifecycles(configuredClassLoader);
        this.componentMetadataRepo.initialize(ModuleProperties.getModuleMetadataFiles(configuredClassLoader), configuredClassLoader);
        this.classLoader = configuredClassLoader;
        try {
            this.globalConfiguration = configuration;
            this.registerComponent((Object)this.componentMetadataRepo, ComponentMetadataRepo.class);
            this.registerComponent((Object)this, GlobalComponentRegistry.class);
            this.registerComponent((Object)configuration, GlobalConfiguration.class);
            this.registerComponent((Object)cacheManager, EmbeddedCacheManager.class);
            this.basicComponentRegistry.registerComponent(CacheManagerJmxRegistration.class.getName(), new CacheManagerJmxRegistration(), true);
            this.basicComponentRegistry.registerComponent(CacheManagerNotifier.class.getName(), new CacheManagerNotifierImpl(), true);
            this.basicComponentRegistry.registerComponent(InternalCacheRegistry.class.getName(), new InternalCacheRegistryImpl(), true);
            this.basicComponentRegistry.registerComponent(CacheStoreFactoryRegistry.class.getName(), new CacheStoreFactoryRegistry(), true);
            this.basicComponentRegistry.registerComponent(EntryMergePolicyFactoryRegistry.class.getName(), new EntryMergePolicyFactoryRegistry(), true);
            this.basicComponentRegistry.registerComponent(GlobalXSiteAdminOperations.class.getName(), new GlobalXSiteAdminOperations(), true);
            this.moduleProperties.loadModuleCommandHandlers(configuredClassLoader);
            Map<Byte, ModuleCommandFactory> factories = this.moduleProperties.moduleCommandFactories();
            if (factories != null && !factories.isEmpty()) {
                this.registerNonVolatileComponent(factories, "org.infinispan.modules.command.factories");
            } else {
                this.registerNonVolatileComponent(Collections.emptyMap(), "org.infinispan.modules.command.factories");
            }
            Map<Byte, ModuleCommandInitializer> initializers = this.moduleProperties.moduleCommandInitializers();
            if (initializers != null && !initializers.isEmpty()) {
                this.registerNonVolatileComponent(initializers, "org.infinispan.modules.command.initializers");
                for (ModuleCommandInitializer mci : initializers.values()) {
                    if (this.basicComponentRegistry.getComponent(mci.getClass()) != null) continue;
                    this.basicComponentRegistry.registerComponent(mci.getClass(), mci, false);
                }
            } else {
                this.registerNonVolatileComponent(Collections.emptyMap(), "org.infinispan.modules.command.initializers");
            }
            this.createdCaches = createdCaches;
            this.basicComponentRegistry.getComponent(EventLogManager.class);
            this.basicComponentRegistry.getComponent(Transport.class);
            this.basicComponentRegistry.getComponent(LocalTopologyManager.class);
            this.basicComponentRegistry.getComponent(ClusterTopologyManager.class);
            this.basicComponentRegistry.getComponent(ClusterContainerStats.class);
            this.basicComponentRegistry.getComponent(EncoderRegistry.class);
            this.basicComponentRegistry.getComponent(GlobalConfigurationManager.class);
            this.basicComponentRegistry.getComponent(CacheManagerJmxRegistration.class);
            this.basicComponentRegistry.getComponent("org.infinispan.executors.timeout", ScheduledExecutorService.class);
        }
        catch (Exception e) {
            throw new CacheException("Unable to construct a GlobalComponentRegistry!", e);
        }
    }

    @Override
    protected ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    protected Log getLog() {
        return log;
    }

    @Override
    public ComponentMetadataRepo getComponentMetadataRepo() {
        return this.componentMetadataRepo;
    }

    @Override
    protected synchronized void removeShutdownHook() {
        if (!this.invokedFromShutdownHook && this.shutdownHook != null) {
            Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
        }
    }

    @Override
    public TimeService getTimeService() {
        return this.getOrCreateComponent(TimeService.class);
    }

    @Override
    protected synchronized void addShutdownHook() {
        boolean registerShutdownHook;
        ArrayList<MBeanServer> al = MBeanServerFactory.findMBeanServer(null);
        ShutdownHookBehavior shutdownHookBehavior = this.globalConfiguration.shutdown().hookBehavior();
        boolean bl = registerShutdownHook = shutdownHookBehavior == ShutdownHookBehavior.DEFAULT && al.isEmpty() || shutdownHookBehavior == ShutdownHookBehavior.REGISTER;
        if (registerShutdownHook) {
            log.tracef("Registering a shutdown hook.  Configured behavior = %s", (Object)shutdownHookBehavior);
            this.shutdownHook = new Thread(() -> {
                try {
                    this.invokedFromShutdownHook = true;
                    this.stop();
                }
                finally {
                    this.invokedFromShutdownHook = false;
                }
            });
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        } else {
            log.tracef("Not registering a shutdown hook.  Configured behavior = %s", (Object)shutdownHookBehavior);
        }
    }

    public final ComponentRegistry getNamedComponentRegistry(String name) {
        return this.getNamedComponentRegistry(ByteString.fromString(name));
    }

    public final ComponentRegistry getNamedComponentRegistry(ByteString name) {
        return (ComponentRegistry)this.namedComponents.get(name);
    }

    public final synchronized void registerNamedComponentRegistry(ComponentRegistry componentRegistry, String name) {
        this.namedComponents.put(ByteString.fromString(name), componentRegistry);
    }

    public final synchronized void unregisterNamedComponentRegistry(String name) {
        this.namedComponents.remove(ByteString.fromString(name));
    }

    public final synchronized void rewireNamedRegistries() {
        for (ComponentRegistry cr : this.namedComponents.values()) {
            cr.rewire();
        }
    }

    public Map<Byte, ModuleCommandInitializer> getModuleCommandInitializers() {
        return Collections.unmodifiableMap(this.moduleProperties.moduleCommandInitializers());
    }

    @Override
    protected void preStart() {
        for (ModuleLifecycle l : this.moduleLifecycles) {
            if (log.isTraceEnabled()) {
                log.tracef("Invoking %s.cacheManagerStarting()", (Object)l);
            }
            l.cacheManagerStarting(this, this.globalConfiguration);
        }
        if (versionLogged.compareAndSet(false, true)) {
            log.version(Version.printVersion());
        }
    }

    @Override
    protected void postStart() {
        for (ModuleLifecycle l : this.moduleLifecycles) {
            if (log.isTraceEnabled()) {
                log.tracef("Invoking %s.cacheManagerStarted()", (Object)l);
            }
            l.cacheManagerStarted(this);
        }
        this.warnAboutUberJarDuplicates();
    }

    private void warnAboutUberJarDuplicates() {
        ManifestUberJarDuplicatedJarsWarner scanner = new ManifestUberJarDuplicatedJarsWarner();
        scanner.isClasspathCorrectAsync().thenAcceptAsync(isClasspathCorrect -> {
            if (!isClasspathCorrect.booleanValue()) {
                log.warnAboutUberJarDuplicates();
            }
        });
    }

    @Override
    protected void preStop() {
        for (ModuleLifecycle l : this.moduleLifecycles) {
            if (log.isTraceEnabled()) {
                log.tracef("Invoking %s.cacheManagerStopping()", (Object)l);
            }
            try {
                l.cacheManagerStopping(this);
            }
            catch (Throwable t) {
                log.moduleStopError(l.getClass().getName(), t);
            }
        }
    }

    @Override
    protected void postStop() {
        if (this.state == ComponentStatus.TERMINATED) {
            for (ModuleLifecycle l : this.moduleLifecycles) {
                if (log.isTraceEnabled()) {
                    log.tracef("Invoking %s.cacheManagerStopped()", (Object)l);
                }
                try {
                    l.cacheManagerStopped(this);
                }
                catch (Throwable t) {
                    log.moduleStopError(l.getClass().getName(), t);
                }
            }
        }
    }

    public void notifyCacheStarted(String cacheName) {
        ComponentRegistry cr = this.getNamedComponentRegistry(cacheName);
        for (ModuleLifecycle l : this.moduleLifecycles) {
            if (log.isTraceEnabled()) {
                log.tracef("Invoking %s.cacheStarted()", (Object)l);
            }
            l.cacheStarted(cr, cacheName);
        }
    }

    public final GlobalConfiguration getGlobalConfiguration() {
        return this.globalConfiguration;
    }

    public synchronized boolean removeCache(String cacheName) {
        return this.createdCaches.remove(cacheName);
    }

    public ModuleProperties getModuleProperties() {
        return this.moduleProperties;
    }
}

